<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:variable name="newline">
		<xsl:text>
</xsl:text>
	</xsl:variable>
	<xsl:param name="datamodel_id"></xsl:param>
	<xsl:variable name="tab">
		<xsl:text disable-output-escaping="yes">	</xsl:text>
	</xsl:variable>

	<xsl:template match="/">
		<!-- Ignore empty datamodels or datamodels tied to empty datasource -->
		<xsl:if
			test="//dataBinding//dataModel[@modelName=$datamodel_id][@dataSource != ''][@modelType != 'Empty']">
			<xsl:apply-templates
				select="//dataBinding//dataModel[@modelName=$datamodel_id]" />
		</xsl:if>
	</xsl:template>

	<xsl:template match="dataModel">
		<xsl:text disable-output-escaping="yes">
<![CDATA[/*******************************************************************************
* This file was generated by UI Builder.
* This file will be auto-generated each and everytime you save your project.
* Do not hand edit this file.
********************************************************************************/

#include "uib_datasources.h"
]]>
</xsl:text>
		<xsl:variable name="datasource_id" select="@dataSource" />
		<xsl:value-of
			select="concat('#include &quot;uib_',$datamodel_id,'_datamodel.h&quot;',$newline)" />
		<xsl:value-of
			select="concat('uib_datamodel_context* ',$datamodel_id,'_datamodel_context = NULL;',$newline,$newline)" />

		<!-- uib_datamodel_context* get_model0_datamodel_context() -->
		<xsl:value-of
			select="concat('uib_datamodel_context* get_',$datamodel_id,'_datamodel_context() {',$newline,
					$tab,'if (',$datamodel_id,'_datamodel_context == NULL) {',$newline,
					$tab,$tab,$datamodel_id,'_datamodel_context = (uib_datamodel_context*) malloc(sizeof(uib_datamodel_context));',$newline,
					$tab,$tab,$datamodel_id,'_datamodel_context->datasource = uib_datasource_manager_get_instance()->get_datasource_instance(&quot;',$datasource_id,'&quot;);',$newline,
					$tab,$tab,$datamodel_id,'_datamodel_context->root_element = ',$datamodel_id,'_datamodel_context->datasource->root_element;',$newline,
					$tab,$tab,$datamodel_id,'_datamodel_context->dataModelName = &quot;',$datamodel_id,'&quot;;',$newline,
					$tab,'}',$newline,
					$tab,'return ',$datamodel_id,'_datamodel_context;',$newline,
					'}',$newline)" />

		<!-- void cleanup_model0_datamodel() -->
		<xsl:value-of
			select="concat('void cleanup_',$datamodel_id,'_datamodel() {',$newline,
					$tab,'free(',$datamodel_id,'_datamodel_context);',$newline,
					'}',$newline)" />

	</xsl:template>
</xsl:stylesheet>
