<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:variable name="newline">
		<xsl:text>
</xsl:text>
	</xsl:variable>
	<xsl:param name="datasource_id"></xsl:param>
	<xsl:variable name="tab">
		<xsl:text disable-output-escaping="yes">	</xsl:text>
	</xsl:variable>

	<xsl:template match="/">
		<!-- Ignore empty type datasource -->
		<xsl:if
			test="//dataBinding//dataSource[@dataSource=$datasource_id][@modelType != 'Empty']">
			<xsl:apply-templates
				select="//dataBinding//dataSource[@dataSource=$datasource_id]" />
		</xsl:if>
	</xsl:template>

	<xsl:template match="dataSource">
		<xsl:text disable-output-escaping="yes">
<![CDATA[/*******************************************************************************
* This file was generated by UI Builder.
* This file will be auto-generated each and everytime you save your project.
* Do not hand edit this file.
********************************************************************************/
]]>
</xsl:text>
		<xsl:variable name="smallcase" select="'abcdefghijklmnopqrstuvwxyz'" />
		<xsl:variable name="uppercase" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZ'" />
		<xsl:variable name="capital_datasource_id"
			select="translate( $datasource_id, $smallcase, $uppercase)"/>
		<xsl:value-of
			select="concat('#ifndef MANAGED_INC_DATABINDING_UIB_',$capital_datasource_id,'_DATASOURCE_H_',$newline,
			'#define MANAGED_INC_DATABINDING_UIB_',$capital_datasource_id,'_DATASOURCE_H_',$newline)" />
		<xsl:value-of
			select="concat('#include &quot;uib_datasources.h&quot;', $newline)" />	
		<xsl:value-of
			select="concat('uib_datasource_instance* get_',$datasource_id,'_dataSource_handle();', $newline)" />
		<xsl:value-of
			select="concat('void cleanup_',$datasource_id,'_datasource();',$newline)" />
		<xsl:value-of select="concat('#endif', $newline)" />
	</xsl:template>
</xsl:stylesheet>








