<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:variable name="newline">
		<xsl:text>
</xsl:text>
	</xsl:variable>
	<xsl:param name="datasource_id"></xsl:param>
	<xsl:variable name="tab">
		<xsl:text disable-output-escaping="yes">	</xsl:text>
	</xsl:variable>
	<xsl:variable name="apos">'</xsl:variable>
	<xsl:template match="/">
		<!-- Ignore empty type datasource -->
		<xsl:if
			test="//dataBinding//dataSource[@dataSource=$datasource_id][@modelType != 'Empty']">
			<xsl:apply-templates
				select="//dataBinding//dataSource[@dataSource=$datasource_id]" />
		</xsl:if>
	</xsl:template>

	<xsl:template match="dataSource">
		<xsl:text disable-output-escaping="yes">
<![CDATA[/*******************************************************************************
* This file was generated by UI Builder.
* This file will be auto-generated each and everytime you save your project.
* Do not hand edit this file.
********************************************************************************/
]]>
</xsl:text>

		<xsl:variable name="datasource_type" select="@modelType" />
		<xsl:variable name="enum_datasource_type">
			<xsl:choose>
				<xsl:when test="$datasource_type='static'">
					<xsl:value-of select="'static_source'" />
				</xsl:when>
				<xsl:when test="$datasource_type='calendar'">
					<xsl:value-of select="'calendar_API'" />
				</xsl:when>
				<xsl:when test="$datasource_type='call_history'">
					<xsl:value-of select="'call_history_API'" />
				</xsl:when>
				<xsl:when test="$datasource_type='contacts'">
					<xsl:value-of select="'contacts_API'" />
				</xsl:when>
				<xsl:when test="$datasource_type='remote'">
					<xsl:value-of select="'remote_API'" />
				</xsl:when>
				<xsl:otherwise />
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="datasource_content_type" select="@sourceType" />
		<xsl:variable name="enum_datasource_content_type">
			<xsl:choose>
				<xsl:when test="$datasource_content_type='json'">
					<xsl:value-of select="'UIB_JSON'" />
				</xsl:when>
				<xsl:when test="$datasource_content_type='xml'">
					<xsl:value-of select="'UIB_XML'" />
				</xsl:when>
				<xsl:otherwise />
			</xsl:choose>
		</xsl:variable>
		<xsl:value-of
			select="concat('#include &quot;uib_',$datasource_id,'_datasource.h&quot;',$newline)" />
		<xsl:value-of
			select="concat('#include &quot;uib_datasource_handler_',$datasource_type,'.h&quot;',$newline)" />

		<xsl:value-of
			select="concat($newline,'static uib_datasource_instance* ',$datasource_id,'_datasource;',$newline)" />
		<xsl:if test="$datasource_type='remote'">
			<xsl:value-of
				select="concat($newline,'static remote_ds_s* ds;',$newline,$newline)" />
		</xsl:if>

		<!-- static void prepare_datasource() -->
		<xsl:value-of select="concat('static void prepare_datasource() {',$newline)" />

		<!-- Add remote datasource population logic -->
		<xsl:if test="$datasource_type='remote'">
			<xsl:call-template name="remote_datasource_populate">
				<xsl:with-param name="enum_datasource_content_type" select="$enum_datasource_content_type" />
			</xsl:call-template>
		</xsl:if>

		<xsl:value-of
			select="concat($tab,$datasource_id,'_datasource = (uib_datasource_instance*) malloc(sizeof(uib_datasource_instance));',$newline)" />

		<xsl:value-of
			select="concat($tab,$datasource_id,'_datasource->datasource_interface = uib_datasource_manager_get_instance()->get_datasource_interface_for_datasource_type(',$enum_datasource_type,');',$newline,
				$tab,$datasource_id,'_datasource->name = &quot;',$datasource_id,'&quot;;',$newline,
				$tab,$datasource_id,'_datasource->ds_content_type = ',$enum_datasource_content_type,';',$newline,
				$tab,$datasource_id,'_datasource->root_element = ',$datasource_id,'_datasource->datasource_interface->get_datasource_root_element();')" />

		<!-- Add static datasource population logic -->
		<xsl:if
			test="($datasource_type='static') and ($datasource_content_type='json')">
			<xsl:call-template name="static_json_datasource_populate" />
		</xsl:if>
		<xsl:if
			test="($datasource_type='static') and ($datasource_content_type='xml')">
			<xsl:call-template name="static_xml_datasource_populate" />
		</xsl:if>

		<xsl:value-of select="concat($newline,'}',$newline,$newline)" />
		<xsl:value-of
			select="concat('uib_datasource_instance* get_',$datasource_id,'_dataSource_handle() {',$newline)" />
		<xsl:value-of
			select="concat($tab,'if (',$datasource_id,'_datasource == NULL) {',$newline)" />
		<xsl:value-of
			select="concat($tab,$tab,'prepare_datasource();',$newline,$tab,'}',$newline)" />
		<xsl:value-of
			select="concat($tab,'return ',$datasource_id,'_datasource;',$newline,'}',$newline)" />

		<!-- void cleanup_source0_datasource() -->
		<xsl:value-of
			select="concat($newline,'void cleanup_',$datasource_id,'_datasource() {',$newline,
					$tab,'free(',$datasource_id,'_datasource->root_element[0]);',$newline,
					$tab,$datasource_id,'_datasource->root_element[0] = NULL;',$newline,
					$tab,'free(',$datasource_id,'_datasource);',$newline)" />
		<xsl:if test="$datasource_type='remote'">
			<xsl:value-of
				select="concat($tab,'eina_lock_free(&amp;ds->mutex);',$newline,
					$tab,'free(ds);',$newline)" />
		</xsl:if>
		<xsl:value-of select="concat('}',$newline )" />
	</xsl:template>
	<xsl:template name="static_json_datasource_populate">
		<xsl:value-of
			select="concat($newline,$tab,'//Begin root node',$newline,
			$tab,'JsonBuilder* jsonBuilder = json_builder_new();',$newline,
			$tab,'jsonBuilder = json_builder_begin_object(jsonBuilder);',$newline,$newline)"></xsl:value-of>

		<xsl:call-template name="json_observable_object">
			<xsl:with-param name="indent" select="concat($tab, $tab)"/>
		</xsl:call-template>

		<xsl:value-of
			select="concat($tab,'//End root node',$newline,
			$tab,'jsonBuilder = json_builder_end_object(jsonBuilder);',$newline,$newline,
			$tab,'char *json_data = get_json_data_from_builder(jsonBuilder);',$newline,
			$tab,'JsonParser *parser = json_parser_new();',$newline,
			$tab,'json_parser_load_from_data(parser,json_data,strlen(json_data),NULL);',$newline,$newline,
			$tab, $datasource_id, '_datasource->root_element[0] = convert_json_to_xml(json_parser_get_root(parser));',$newline,
			$tab,'g_object_unref(jsonBuilder);',$newline,
			$tab,'g_object_unref(parser);',$newline)" />

	</xsl:template>
	<xsl:template name="json_observable_object">
		<xsl:param name="indent"></xsl:param>
		<!-- Check for object/array type -->
		<xsl:for-each select="./observableObject">
			<xsl:variable name="type" select="@type"></xsl:variable>
			<xsl:variable name="name" select="@name"></xsl:variable>
			<xsl:variable name="value" select="@value"></xsl:variable>
			<xsl:variable name="parentType" select="../@type"></xsl:variable>
			<xsl:choose>
				<xsl:when test="$type='Array'">
					<xsl:value-of
						select="concat($indent,'//Start array',$newline,
						$indent,'jsonBuilder = json_builder_set_member_name(jsonBuilder,&quot;',$name,'&quot;);',$newline,
                        $indent,'jsonBuilder = json_builder_begin_array(jsonBuilder);',$newline)" />
					<xsl:call-template name="json_observable_object">
						<xsl:with-param name="indent" select="concat($indent,$tab )"></xsl:with-param>
					</xsl:call-template>
					<xsl:value-of
						select="concat($indent,'//End array',$newline,
						$indent,'jsonBuilder = json_builder_end_array(jsonBuilder);',$newline)" />
				</xsl:when>
				<xsl:when test="$type='Object'">
					<xsl:value-of select="concat($indent,'//Start object',$newline)" />
					<xsl:if test="not($parentType) or ($parentType != 'Array')">
						<xsl:value-of
							select="concat($indent,'jsonBuilder = json_builder_set_member_name(jsonBuilder,&quot;',$name,'&quot;);',$newline)" />
					</xsl:if>
					<xsl:value-of
						select="concat($indent,'jsonBuilder = json_builder_begin_object(jsonBuilder);',$newline)" />
					<xsl:call-template name="json_observable_object">
						<xsl:with-param name="indent" select="concat($indent,$tab )" />
					</xsl:call-template>
					<xsl:value-of
						select="concat($indent,'//End object',$newline,
						$indent,'jsonBuilder = json_builder_end_object(jsonBuilder);',$newline)" />
				</xsl:when>
				<xsl:when test="$type='Number'">
					<xsl:if test="not($parentType) or ($parentType != 'Array')">
						<xsl:value-of
							select="concat($indent,'jsonBuilder = json_builder_set_member_name(jsonBuilder,&quot;',$name,'&quot;);',$newline)" />
					</xsl:if>
					<xsl:value-of
						select="concat($indent,'jsonBuilder = json_builder_add_int_value(jsonBuilder,',$value,');',$newline)" />
				</xsl:when>
				<xsl:when test="$type='String'">
					<xsl:if test="not($parentType) or ($parentType != 'Array')">
						<xsl:value-of
							select="concat($indent,'jsonBuilder = json_builder_set_member_name(jsonBuilder,&quot;',$name,'&quot;);',$newline)" />
					</xsl:if>
					<xsl:value-of
						select="concat($indent,'jsonBuilder = json_builder_add_string_value(jsonBuilder,&quot;',$value,'&quot;);',$newline)" />
				</xsl:when>
				<xsl:when test="$type = 'Boolean'">
					<xsl:if test="not($parentType) or ($parentType != 'Array')">
						<xsl:value-of
							select="concat($indent,'jsonBuilder = json_builder_set_member_name(jsonBuilder,&quot;',$name,'&quot;);',$newline)" />
					</xsl:if>
					<xsl:value-of
						select="concat($indent,'jsonBuilder = json_builder_add_boolean_value(jsonBuilder,',$value,');',$newline)" />
				</xsl:when>
				<xsl:when test="$type = 'Index'"> <!-- Index is child of Array node -->
					<!-- <xsl:value-of select="concat($indent,'jsonBuilder = json_builder_set_member_name(jsonBuilder,&quot;',$name,'&quot;);',$newline)" 
						/> -->
					<xsl:value-of
						select="concat($indent,'jsonBuilder = json_builder_add_string_value(jsonBuilder,&quot;',$value,'&quot;);',$newline)" />
				</xsl:when>
				<xsl:when test="$type = 'IndexObject'"> <!-- IndexObject is child object of Array node -->
					<xsl:value-of select="concat($indent,'//Start object',$newline)" />
					<xsl:if test="not($parentType) or ($parentType != 'Array')">
						<xsl:value-of
							select="concat($indent,'jsonBuilder = json_builder_set_member_name(jsonBuilder,&quot;',$name,'&quot;);',$newline)" />
					</xsl:if>
					<xsl:value-of
						select="concat($indent,'jsonBuilder = json_builder_begin_object(jsonBuilder);',$newline)" />
					<xsl:call-template name="json_observable_object">
						<xsl:with-param name="indent" select="concat($indent,$tab )" />
					</xsl:call-template>
					<xsl:value-of
						select="concat($indent,'//End object',$newline,
						$indent,'jsonBuilder = json_builder_end_object(jsonBuilder);',$newline)" />
				</xsl:when>
				<xsl:otherwise />
			</xsl:choose>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="static_xml_datasource_populate">
		<xsl:value-of
			select="concat($newline,$tab,'//Initialize xml data',$newline,
			$tab,'char xml_data[] = &quot;',translate(@jsonData,'&quot;',$apos),'&quot;;',$newline,
			$tab,'xmlDocPtr parsedXMLDoc = xmlReadMemory(xml_data,',$newline,
			$tab,'strlen(xml_data), NULL, NULL, 0);',$newline,
			$tab,'if (parsedXMLDoc != NULL) {',$newline,
		    $tab,$tab,$datasource_id,'_datasource->root_element[0] = parsedXMLDoc;',$newline,
		    $tab,'}',$newline)" />
	</xsl:template>
	<xsl:template name="remote_datasource_populate">
		<xsl:param name="enum_datasource_content_type" />
		<xsl:value-of
			select="concat($newline,$tab,'//Begin remote datasource definition',$newline)" />
		<xsl:value-of
			select="concat($tab,'ds = (remote_ds_s *)malloc(sizeof(remote_ds_s));',$newline)" />
		<xsl:choose>
			<xsl:when test=" not(@query)">
				<xsl:value-of
					select="concat($tab,'char* url = &quot;',@url,'&quot; ;',$newline)" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of
					select="concat($tab,'char* url = &quot;',@url,'?',@query,'&quot; ;',$newline)" />
			</xsl:otherwise>
		</xsl:choose>
		<xsl:value-of
			select="concat($tab,'strcpy(ds->url, url);//curl_easy_escape(ds->curl,url,strlen(url))',$newline)" />
		<xsl:value-of
			select="concat($tab,'ds->response_data = (char*)malloc(1*sizeof(char));',$newline)" />
		<xsl:value-of
			select="concat($tab,'strcpy(ds->response_data,&quot;&quot;);',$newline)" />
		<xsl:value-of
			select="concat($tab,'ds->prev_response_data = (char*)malloc(1*sizeof(char));',$newline)" />
		<xsl:value-of
			select="concat($tab,'strcpy(ds->prev_response_data,&quot;&quot;);',$newline)" />
		<xsl:value-of
			select="concat($tab,'ds->polling_interval = ',@pollingInterval,'; //in ms',$newline)" />
		<xsl:value-of
			select="concat($tab,'ds->timeout_ms = ',@timeout,'L; //in ms',$newline)" />
		<xsl:value-of
			select="concat($tab,'ds->source_name = &quot;',$datasource_id,'&quot;;',$newline)" />
		<xsl:value-of select="concat($tab,'ds->thread_running = false;',$newline)" />
		<xsl:value-of
			select="concat($tab,'ds->content_type = ',$enum_datasource_content_type,';',$newline)" />
		<xsl:value-of
			select="concat($tab,'eina_lock_new(&amp;ds->mutex);',$newline,$newline)" />
		<xsl:value-of
			select="concat($tab,'set_remote_datasource(ds);',$newline,$newline)" />
	</xsl:template>
</xsl:stylesheet>



