<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:variable name="newline">
		<xsl:text>
</xsl:text>
	</xsl:variable>
	<xsl:variable name="tab">
		<xsl:text disable-output-escaping="yes">	</xsl:text>
	</xsl:variable>
	<xsl:param name="current_view_name" />
	<xsl:variable name="data_bind_count"
		select="count(//views//view[@id=$current_view_name]//*[@data_bind != ''])" />
	<xsl:variable name="databinding_done">
		<xsl:choose>
			<xsl:when test="$data_bind_count>0">
				<xsl:value-of select="'yes'" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="'no'" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:template match="/">
		<xsl:if test="$databinding_done='yes'">
			<xsl:apply-templates select="//views//view[@id=$current_view_name]" />
		</xsl:if>
	</xsl:template>

	<xsl:template match="view">
		<xsl:text disable-output-escaping="yes">
<![CDATA[/*******************************************************************************
* This file was generated by UI Builder.
* This file will be auto-generated each and everytime you save your project.
* Do not hand edit this file.
********************************************************************************/
]]>
</xsl:text>
		<xsl:variable name="smallcase" select="'abcdefghijklmnopqrstuvwxyz'" />
		<xsl:variable name="uppercase" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZ'" />
		<xsl:variable name="capital_current_view_name"
			select="translate( $current_view_name, $smallcase, $uppercase)"></xsl:variable>
		<xsl:value-of
			select="concat('#ifndef MANAGED_INC_UIB_',$capital_current_view_name,'_BINDINGS_H_',$newline,'#define MANAGED_INC_UIB_',$capital_current_view_name,'_BINDINGS_H_',$newline)" />

		<xsl:text disable-output-escaping="yes">
<![CDATA[
#include "uib_views_binding.h"
#include "uib_databinding_common.h"
]]>
</xsl:text>

		<xsl:value-of
			select="concat('#include &quot;uib_',$current_view_name,'_view.h&quot;',$newline)" />

		<!-- <xsl:text disable-output-escaping="yes"> <![CDATA[uib_binding_info** 
			add_binding_info();]]></xsl:text> -->
		<xsl:value-of
			select="concat($newline,'uib_binding_info** get_',$current_view_name,'_binding_info();',$newline)" />
		<xsl:value-of
			select="concat($newline,'int get_',$current_view_name,'_binding_count();',$newline)" />

		<xsl:value-of
			select="concat('void set_',$current_view_name,'_view_context(uib_',$current_view_name,'_view_context* arg_view_context);',$newline)" />
		<xsl:value-of
			select="concat('void cleanup_',$current_view_name,'_binding();')" />
		<xsl:text disable-output-escaping="yes">
<![CDATA[
#endif
]]>
</xsl:text>

	</xsl:template>
</xsl:stylesheet>
