<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:param name="current_view_name" />
	<xsl:param name="profile" />

	<xsl:template match="/">
		<xsl:apply-templates select="//view">
		</xsl:apply-templates>
	</xsl:template>

	<xsl:variable name="newline">
		<xsl:text>
</xsl:text>
	</xsl:variable>
	<xsl:variable name="tab">
		<xsl:text disable-output-escaping="yes">	</xsl:text>
	</xsl:variable>
	<xsl:template name="uib_view_header">

		<!-- Parameter -->
		<xsl:param name="view_name" />
		<xsl:param name="view_type" />
		<xsl:param name="path" />
		<xsl:param name="current_view_position" />

		<!-- Variables -->
		<xsl:variable name="view_context_name">
			<xsl:call-template name="get_view_context_name">
				<xsl:with-param name="view_name" select="$view_name" />
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="view_name_macro">
			<xsl:call-template name="convert_uppercase">
				<xsl:with-param name="text" select="concat('UIB_', $view_name, '_VIEW_H_')" />
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="view_control_context_name">
			<xsl:call-template name="get_view_control_context_name">
				<xsl:with-param name="view_name" select="$view_name" />
			</xsl:call-template>
		</xsl:variable>

		<!-- BEGIN : OUTPUT -->
		<xsl:value-of select="concat($newline, '#ifndef ', $view_name_macro, $newline)" />
		<xsl:value-of select="concat('#define ', $view_name_macro, $newline)" />
		<xsl:text disable-output-escaping="yes">
<![CDATA[
#include "g_inc_uib.h"
#include "uib_views.h"

/**
* view context definitions
*/
]]>
</xsl:text>
		<!-- <xsl:value-of select="$newline" /> -->
		<xsl:value-of select="concat('typedef struct _', $view_context_name, ' {')" />
		<xsl:text disable-output-escaping="yes">
<![CDATA[
	/* parent evas_object which was parameter of create function */
	Evas_Object *parent;
	/* root container UI Component of this view */
	Evas_Object *root_container;
	/* view class name */
	const char *view_name;
	/* indicator state of this view */
	int indicator_state;
	/* This is view type. 'true' is user view, otherwise a UI Builder's view. */
	bool is_user_view;
	/* control context to control this view */]]>
</xsl:text>
		<xsl:value-of select="concat( $tab, 'struct _', $view_control_context_name, ' *cc;', $newline, $newline)" />
		<xsl:value-of select="concat( $tab, '/* UI Components in this view */', $newline)" />

		<xsl:for-each select="descendant::*">
			<xsl:variable name="widget_name" select="@id" />
			<xsl:variable name="element" select="name()" />
			<xsl:choose>
				<xsl:when test="$element='event'" />
				<xsl:when test="$element='variation'" />
				<xsl:when test="contains($element,'item')">
					<xsl:value-of select="concat($tab, 'Elm_Object_Item *', $widget_name, ';', $newline)" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="concat($tab, 'Evas_Object *', $widget_name, ';', $newline)" />
					<xsl:if test="$profile='wearable-circle'">
						<xsl:value-of select="concat($tab, 'Evas_Object *circle_object_', $widget_name, ';', $newline)" />
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>

		<xsl:value-of select="concat( '} ', $view_context_name, ';', $newline)" />
		<xsl:value-of select="$newline" />

		<xsl:if test="@type='popup'">
			<xsl:for-each select="./*">
				<xsl:value-of select="concat( 'typedef ', $view_context_name, ' uib_', @id, '_context ;', $newline)" />
			</xsl:for-each>
		</xsl:if>

		<xsl:text disable-output-escaping="yes">
<![CDATA[
/**
* @brief	Create a new view then return view context of that view.
* 			You can delete view using evas_object_del(vc->evas_object) like other EFL evas objects.
*/]]></xsl:text>


		<xsl:value-of select="$newline" />
		<xsl:value-of select="concat( 'uib_view_context *uib_view_', $view_name, '_create(Evas_Object *parent, void *create_callback_param);', $newline)" />
		<xsl:value-of select="concat( 'uib_view_context *uib_view_', $view_name, '_destroy(Evas_Object *parent, void *create_callback_param);', $newline)" />
		<xsl:value-of select="$newline" />


		<!-- create mscreen view func -->
		<xsl:for-each select="/document/mscreen/configuration">
			<xsl:variable name="configuration_type" select="@type" />
			<xsl:variable name="configuration_id" select="@id" />
			<xsl:variable name="configuration_resolution" select="@device" />
			<xsl:variable name="configuration_orientation" select="@orientation" />
			<xsl:choose>
				<xsl:when test="$configuration_type='common'">
					<xsl:value-of select="concat('void uib_',$view_name,'_config_',$configuration_resolution,'_',$configuration_orientation,'();',$newline)" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:for-each select="/document/views/view[$current_view_position]//variation[$configuration_id = @config_ref]">
						<xsl:if test="position()='1'">
							<xsl:value-of select="concat('void uib_',$view_name,'_config_',$configuration_resolution,'_',$configuration_orientation,'();',$newline)" />
						</xsl:if>
					</xsl:for-each>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>
		<!-- Storyboard_START -->
		<xsl:for-each select="descendant::*">
			<xsl:variable name="element" select="name()" />
			<xsl:variable name="widget_name" select="@id" />
			<xsl:variable name="parent" select="local-name(parent::node())" />
			<xsl:if test="$element='event'">
				<xsl:if test="string-length(@onuib_view_create)=0">
					<xsl:if test="string-length(@connection_wrapper)!=0">
						<xsl:variable name="function">
							<xsl:value-of select="@function_name" />
						</xsl:variable>
						<xsl:choose>
							<xsl:when test="$parent='customcomponent'">
								<xsl:value-of select="concat('void ',$function,'(uib_',$view_name,'_view_context *vc, Evas_Object *obj, const char *emission, const char *source);',$newline)" />
								<xsl:value-of select="concat('void ',$function,'_post(void* param, uib_',$view_name,'_view_context *vc, Evas_Object *obj, const char *emission, const char *source);',$newline)" />
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="concat('void ',$function,'(uib_',$view_name,'_view_context *vc, Evas_Object *obj, void *event_info);',$newline)" />
								<xsl:value-of select="concat('void ',$function,'_post(void* param, uib_',$view_name,'_view_context *vc, Evas_Object *obj, void *event_info);',$newline)" />
							</xsl:otherwise>
						</xsl:choose>
					</xsl:if>
				</xsl:if>
			</xsl:if>
		</xsl:for-each>
		<!-- Storyboard_END -->

		<xsl:value-of select="concat('#endif /* ', $view_name_macro, ' */', $newline)" />
		<!-- END : OUTPUT -->

	</xsl:template>

	<xsl:template name="convert_into_EFL_structure_naming">
		<xsl:param name="text" />
		<xsl:choose>
			<xsl:when test="contains($text, '_')">
				<!-- <xsl:call-template name="convert_first_char_uppercase"> <xsl:with-param name="text" select="concat(substring-before($text,'_'), '_')" /> </xsl:call-template> -->
				<xsl:value-of select="concat(substring-before($text,'_'), '_')" />
				<xsl:call-template name="convert_into_EFL_structure_naming">
					<xsl:with-param name="text" select="substring-after($text,'_')" />
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<!-- <xsl:call-template name="convert_first_char_uppercase"> <xsl:with-param name="text" select="$text" /> </xsl:call-template> -->
				<xsl:value-of select="$text" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- VIEW::get_view_context_name -->
	<xsl:template name="get_view_context_name">
		<xsl:param name="view_name" />

		<xsl:text>uib_</xsl:text>
		<xsl:call-template name="convert_into_EFL_structure_naming">
			<xsl:with-param name="text" select="$view_name" />
		</xsl:call-template>
		<xsl:text>_view_context</xsl:text>
	</xsl:template>

	<!-- VIEW::get_view_control_context_name -->
	<xsl:template name="get_view_control_context_name">
		<xsl:param name="view_name" />

		<xsl:text>uib_</xsl:text>
		<xsl:call-template name="convert_into_EFL_structure_naming">
			<xsl:with-param name="text" select="$view_name" />
		</xsl:call-template>
		<xsl:text>_control_context</xsl:text>
	</xsl:template>

	<!-- ::convert_uppercase -->
	<xsl:template name="convert_uppercase">
		<xsl:param name="text" />
		<xsl:value-of select="translate($text,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ')" />
	</xsl:template>




	<xsl:template name="writing_code_for_current_view">
		<!-- Parameter -->
		<xsl:param name="view_name" />
		<xsl:param name="view_type" />

		<xsl:choose>
			<xsl:when test="$current_view_name=$view_name">
				<xsl:text>
/*******************************************************************************
* This file was generated by UI Builder.
* This file will be auto-generated each and everytime you save your project.
* Do not hand edit this file.
********************************************************************************/
				</xsl:text>


				<xsl:variable name="current_view_position" select="position()" />

				<xsl:call-template name="uib_view_header">
					<!-- <xsl:with-param name="view_name" select="$view_name" /> -->
					<xsl:with-param name="view_name" select="@id" />
					<xsl:with-param name="view_type" select="name(.)" />
					<xsl:with-param name="current_view_position" select="$current_view_position" />
				</xsl:call-template>
			</xsl:when>
		</xsl:choose>
	</xsl:template>




	<xsl:template match="view">
		<xsl:call-template name="writing_code_for_current_view">
			<xsl:with-param name="view_name" select="@id" />
			<xsl:with-param name="view_type" select="name(.)" />
		</xsl:call-template>
	</xsl:template>
</xsl:stylesheet>
