/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.efluibuilder.codegenerator;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPathExpressionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.efluibuilder.codegenerator.CodeGeneratorUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DataBindingCodeGenerator {
    private final File targetDirectory;
    private final String isRMSupportVersion;
    private final String profile;
    private final Document tizenLayoutDocument;
    private final Document databindingDocument;
    private NodeList viewList;
    private NodeList datamodelList;
    private NodeList datasourceList;
    private static final String UI_DATABINDING_VIEWX_BINDINGS = "res/databinding/db_view_bindings_";
    private static final String UI_DATABINDING_DATAMODELX = "res/databinding/db_datamodel_";
    private static final String UI_DATABINDING_DATASOURCEX = "res/databinding/db_datasource_";
    private static Logger logger = LoggerFactory.getLogger(DataBindingCodeGenerator.class);

    public DataBindingCodeGenerator(File file, Document document, Document document2, String string, String string2) {
        this.targetDirectory = file;
        this.tizenLayoutDocument = document;
        this.databindingDocument = document2;
        this.isRMSupportVersion = string;
        this.profile = string2;
        try {
            this.viewList = CodeGeneratorUtil.getNodes(document, "/document/views/view");
            this.datamodelList = CodeGeneratorUtil.getNodes(document2, "/dataBinding/dataModel");
            this.datasourceList = CodeGeneratorUtil.getNodes(document2, "/dataBinding/dataSource");
        }
        catch (XPathExpressionException xPathExpressionException) {
            this.viewList = null;
            this.datamodelList = null;
            this.datasourceList = null;
        }
    }

    public void generate() throws TransformerException, IOException {
        CODE_MODULE[] cODE_MODULEArray = CODE_MODULE.values();
        int n = cODE_MODULEArray.length;
        int n2 = 0;
        while (n2 < n) {
            CODE_MODULE cODE_MODULE = cODE_MODULEArray[n2];
            if (!cODE_MODULE.getGeneratedCodePath().isEmpty()) {
                this.generateDataBindingCode(cODE_MODULE.getXSLpath(), cODE_MODULE.getGeneratedCodePath(), cODE_MODULE.getDocumentType());
            }
            ++n2;
        }
        this.generateDataBindingForNodes(UI_DATABINDING_DATAMODELX, "datamodels/uib_", "_datamodel", this.datamodelList, "modelName", "datamodel_id", DOCUMENT_TYPE.DATABINDING_DOCUMENT);
        this.generateDataBindingForNodes(UI_DATABINDING_DATASOURCEX, "datasources/uib_", "_datasource", this.datasourceList, "dataSource", "datasource_id", DOCUMENT_TYPE.DATABINDING_DOCUMENT);
        this.generateDataBindingForNodes(UI_DATABINDING_VIEWX_BINDINGS, "viewbindings/uib_", "_bindings", this.viewList, "id", "current_view_name", DOCUMENT_TYPE.LAYOUT_DOCUMENT);
    }

    private void generateDataBindingForNodes(String string, String string2, String string3, NodeList nodeList, String string4, String string5, DOCUMENT_TYPE dOCUMENT_TYPE) throws TransformerException, IOException {
        String string6 = null;
        String string7 = null;
        Document document = null;
        document = dOCUMENT_TYPE == DOCUMENT_TYPE.DATABINDING_DOCUMENT ? this.databindingDocument : this.tizenLayoutDocument;
        CODE_TYPE[] cODE_TYPEArray = CODE_TYPE.values();
        int n = cODE_TYPEArray.length;
        int n2 = 0;
        while (n2 < n) {
            CODE_TYPE cODE_TYPE = cODE_TYPEArray[n2];
            if (cODE_TYPE == CODE_TYPE.HEADER) {
                string6 = string.concat("header.xsl");
                String[] stringArray = string2.split("/");
                string7 = stringArray[stringArray.length - 1];
            } else {
                string6 = string.concat("source.xsl");
                string7 = string2;
            }
            if (nodeList != null) {
                int n3 = 0;
                while (n3 < nodeList.getLength()) {
                    InputStream inputStream = CodeGeneratorUtil.openStream(string6);
                    StreamSource streamSource = new StreamSource(inputStream);
                    Node node = nodeList.item(n3);
                    String string8 = CodeGeneratorUtil.getNodeId(node, string4);
                    Writer writer = this.getDestinationWriterForDataBinding(String.valueOf(string7) + string8 + string3, cODE_TYPE);
                    CodeGeneratorUtil.generateCode(document, writer, streamSource, string5, string8, this.isRMSupportVersion, this.profile);
                    inputStream.close();
                    ++n3;
                }
            }
            ++n2;
        }
    }

    private void generateDataBindingCode(String string, String string2, DOCUMENT_TYPE dOCUMENT_TYPE) throws TransformerException, IOException {
        String string3 = null;
        String string4 = null;
        Document document = null;
        document = dOCUMENT_TYPE == DOCUMENT_TYPE.DATABINDING_DOCUMENT ? this.databindingDocument : this.tizenLayoutDocument;
        CODE_TYPE[] cODE_TYPEArray = CODE_TYPE.values();
        int n = cODE_TYPEArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object;
            CODE_TYPE cODE_TYPE = cODE_TYPEArray[n2];
            if (cODE_TYPE == CODE_TYPE.HEADER) {
                string3 = string.concat("header.xsl");
                object = string2.split("/");
                string4 = object[((String[])object).length - 1];
            } else {
                string3 = string.concat("source.xsl");
                string4 = string2;
            }
            object = CodeGeneratorUtil.openStream(string3);
            StreamSource streamSource = new StreamSource((InputStream)object);
            Writer writer = this.getDestinationWriterForDataBinding(string4, cODE_TYPE);
            CodeGeneratorUtil.generateCode(document, writer, streamSource, "", "", this.isRMSupportVersion, this.profile);
            ((InputStream)object).close();
            ++n2;
        }
    }

    private Writer getDestinationWriterForDataBinding(String string, CODE_TYPE cODE_TYPE) throws IOException {
        String string2 = null;
        string2 = cODE_TYPE == CODE_TYPE.HEADER ? "src/managed/inc/databinding/" + string + ".h" : "src/managed/src/databinding/" + string + ".c";
        File file = new File(this.targetDirectory, string2);
        FileWriter fileWriter = new FileWriter(file);
        return fileWriter;
    }

    private static enum CODE_MODULE {
        DATABINDING_MANAGER("res/databinding/db_manager_", "uib_db_manager", DOCUMENT_TYPE.LAYOUT_DOCUMENT),
        DATABINDING_VIEWX_BINDINGS("res/databinding/db_view_bindings_", "uib_views_binding", DOCUMENT_TYPE.LAYOUT_DOCUMENT),
        DATABINDING_DATAMODELX("res/databinding/db_datamodel_", "", DOCUMENT_TYPE.DATABINDING_DOCUMENT),
        DATABINDING_DATASOURCEX("res/databinding/db_datasource_", "", DOCUMENT_TYPE.DATABINDING_DOCUMENT),
        DATABINDING_DATAMODELS("res/databinding/db_datamodels_", "uib_datamodels", DOCUMENT_TYPE.DATABINDING_DOCUMENT),
        DATABINDING_VIEWS_BINDING("res/databinding/db_views_binding_", "uib_views_binding", DOCUMENT_TYPE.LAYOUT_DOCUMENT),
        DATABINDING_DATASOURCES("res/databinding/db_datasources_", "uib_datasources", DOCUMENT_TYPE.DATABINDING_DOCUMENT),
        DATABINDING_DS_HANDLER_CONTACTS("res/databinding/db_ds_handler_contacts_", "datasources/uib_datasource_handler_contacts", DOCUMENT_TYPE.DATABINDING_DOCUMENT),
        DATABINDING_DS_HANDLER_STATIC("res/databinding/db_ds_handler_static_", "datasources/uib_datasource_handler_static", DOCUMENT_TYPE.DATABINDING_DOCUMENT),
        DATABINDING_DS_HANDLER_CALLHISTORY("res/databinding/db_ds_handler_call_history_", "datasources/uib_datasource_handler_call_history", DOCUMENT_TYPE.DATABINDING_DOCUMENT),
        DATABINDING_DS_HANDLER_REMOTE("res/databinding/db_ds_handler_remote_", "datasources/uib_datasource_handler_remote", DOCUMENT_TYPE.DATABINDING_DOCUMENT),
        DATABINDING_COMMON("res/databinding/db_common_", "uib_databinding_common", DOCUMENT_TYPE.DATABINDING_DOCUMENT),
        DATABINDING_LIST_WIDGET_HANDLER("res/databinding/db_widget_handler_list_", "widgets/uib_widget_handler_list", DOCUMENT_TYPE.LAYOUT_DOCUMENT),
        DATABINDING_LISTITEM_WIDGET_HANDLER("res/databinding/db_widget_handler_listitem_", "widgets/uib_widget_handler_listitem", DOCUMENT_TYPE.LAYOUT_DOCUMENT),
        DATABINDING_LABEL_WIDGET_HANDLER("res/databinding/db_widget_handler_label_", "widgets/uib_widget_handler_label", DOCUMENT_TYPE.LAYOUT_DOCUMENT),
        DATABINDING_BUTTON_WIDGET_HANDLER("res/databinding/db_widget_handler_button_", "widgets/uib_widget_handler_button", DOCUMENT_TYPE.LAYOUT_DOCUMENT),
        DATABINDING_CHECKBOX_WIDGET_HANDLER("res/databinding/db_widget_handler_checkbox_", "widgets/uib_widget_handler_checkbox", DOCUMENT_TYPE.LAYOUT_DOCUMENT),
        DATABINDING_RADIO_WIDGET_HANDLER("res/databinding/db_widget_handler_radio_", "widgets/uib_widget_handler_radio", DOCUMENT_TYPE.LAYOUT_DOCUMENT),
        DATABINDING_FLIPSELECTOR_WIDGET_HANDLER("res/databinding/db_widget_handler_flipselector_", "widgets/uib_widget_handler_flipselector", DOCUMENT_TYPE.LAYOUT_DOCUMENT),
        DATABINDING_FLIPSELECTORITEM_WIDGET_HANDLER("res/databinding/db_widget_handler_flipselectoritem_", "widgets/uib_widget_handler_flipselectoritem", DOCUMENT_TYPE.LAYOUT_DOCUMENT),
        DATABINDING_HOVERSEL_WIDGET_HANDLER("res/databinding/db_widget_handler_hoversel_", "widgets/uib_widget_handler_hoversel", DOCUMENT_TYPE.LAYOUT_DOCUMENT),
        DATABINDING_HOVERSELITEM_WIDGET_HANDLER("res/databinding/db_widget_handler_hoverselitem_", "widgets/uib_widget_handler_hoverselitem", DOCUMENT_TYPE.LAYOUT_DOCUMENT);

        private String XSLpath;
        private String generatedCodePath;
        private DOCUMENT_TYPE documentType;

        public String getXSLpath() {
            return this.XSLpath;
        }

        public String getGeneratedCodePath() {
            return this.generatedCodePath;
        }

        public DOCUMENT_TYPE getDocumentType() {
            return this.documentType;
        }

        private CODE_MODULE(String string2, String string3, DOCUMENT_TYPE dOCUMENT_TYPE) {
            this.XSLpath = string2;
            this.generatedCodePath = string3;
            this.documentType = dOCUMENT_TYPE;
        }
    }

    private static enum CODE_TYPE {
        HEADER,
        SOURCE;

    }

    private static enum DOCUMENT_TYPE {
        LAYOUT_DOCUMENT,
        DATABINDING_DOCUMENT;

    }
}

