<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:variable name="newline">
		<xsl:text>
</xsl:text>
	</xsl:variable>
	<xsl:variable name="tab">
		<xsl:text disable-output-escaping="yes">	</xsl:text>
	</xsl:variable>

	<xsl:template match="/">
		<xsl:variable name="data_bind_count" select="count(//*[@data_bind != ''])" />
		<xsl:variable name="databinding_done">
			<xsl:choose>
				<xsl:when test="$data_bind_count>0">
					<xsl:value-of select="'yes'" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="'no'" />
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:if test="$databinding_done='yes'">
			<xsl:apply-templates select="//views" />
		</xsl:if>
	</xsl:template>

	<xsl:template match="views">

		<xsl:text disable-output-escaping="yes">
<![CDATA[/*******************************************************************************
* This file was generated by UI Builder.
* This file will be auto-generated each and everytime you save your project.
* Do not hand edit this file.
********************************************************************************/

#include "uib_db_manager.h"
#include "uib_datasources.h"
#include "uib_datamodels.h"
]]>
</xsl:text>


		<xsl:value-of select="$newline" />
		<xsl:value-of
			select="concat('static uib_databinding_manager_st g_uib_databinding_manager;',$newline)" />
		<xsl:value-of
			select="concat('static uib_binding_info** view_bindings = NULL;',$newline)" />
		<xsl:value-of select="concat('static int binding_count;',$newline)"></xsl:value-of>
		<xsl:value-of
			select="concat('static uib_view_context* currentViewContext = NULL;',$newline)" />


		<xsl:value-of select="$newline" />

		<xsl:value-of
			select="concat('static void extract_binding_info_from_view_context(const uib_view_context* vc) {',$newline,$tab )" />
		<xsl:for-each select="//view">
			<xsl:variable name="viewId" select="@id" />
			<xsl:variable name="view_data_bind_count" select="count(.//*[@data_bind != ''])" />
			<xsl:if test="$view_data_bind_count>0"><!-- Consider this view only if it has some widget 
					with data binding -->
				<xsl:value-of
					select="concat('if(!strcmp(vc->view_name, &quot;',$viewId,'&quot;)) {',$newline,
				$tab,$tab,'set_',$viewId,'_view_context((uib_',$viewId,'_view_context*)vc);',$newline,
				$tab,$tab,'view_bindings = get_',$viewId,'_binding_info();',$newline,
				$tab,$tab,'binding_count = get_',$viewId,'_binding_count();',$newline,
				$tab,'} else ')" /> <!-- $tab,$tab,$viewId,'Context = (uib_',$viewId,'_view_context*) vc;',$newline, -->
			</xsl:if>
		</xsl:for-each>

		<xsl:value-of select="concat('{',$newline,$tab,'}',$newline )"></xsl:value-of>
		<xsl:value-of select="concat('}',$newline)"></xsl:value-of>
		<xsl:text disable-output-escaping="yes">
<![CDATA[
static void get_widget_handler(uib_binding_info *binding_info,
		widget_handler_st **widget_handler) {
		dlog_print(DLOG_DEBUG, LOG_TAG, "%s - for %d", __func__, binding_info->widgetType);
	switch (binding_info->widgetType) {
]]>
</xsl:text>
			<xsl:if test="count(.//hoverselitem[@data_bind != ''])>0">
				<xsl:value-of
					select="concat($tab,'case uib_hoverselitem:',$newline,
					$tab,$tab,'*widget_handler = hoverselitem_widget_handler_get_instance();',$newline,
					$tab,$tab,'break;',$newline)" />
			</xsl:if>
			<xsl:if test="count(.//hoversel[@data_bind != ''])>0">
				<xsl:value-of
					select="concat($tab,'case uib_hoversel:',$newline,
					$tab,$tab,'*widget_handler = hoversel_widget_handler_get_instance();',$newline,
					$tab,$tab,'break;',$newline)" />
			</xsl:if>
			<xsl:if test="count(.//list[@data_bind != ''])>0">
				<xsl:value-of
					select="concat($tab,'case uib_list:',$newline,
					$tab,$tab,'*widget_handler = list_widget_handler_get_instance();',$newline,
					$tab,$tab,'break;',$newline)" />
			</xsl:if>
			<xsl:if test="count(.//listitem[@data_bind != ''])>0">
				<xsl:value-of
					select="concat($tab,'case uib_listitem:',$newline,
					$tab,$tab,'*widget_handler = listitem_widget_handler_get_instance();',$newline,
					$tab,$tab,'break;',$newline)" />
			</xsl:if>
			<xsl:if test="count(.//button[@data_bind != ''])>0">
				<xsl:value-of
					select="concat($tab,'case uib_button:',$newline,
					$tab,$tab,'*widget_handler = button_widget_handler_get_instance();',$newline,
					$tab,$tab,'break;',$newline)" />
			</xsl:if>
			<xsl:if test="count(.//check[@data_bind != ''])>0">
				<xsl:value-of
					select="concat($tab,'case uib_checkbox:',$newline,
					$tab,$tab,'*widget_handler = checkbox_widget_handler_get_instance();',$newline,
					$tab,$tab,'break;',$newline)" />
			</xsl:if>
			<xsl:if test="count(.//label[@data_bind != ''])>0">
				<xsl:value-of
					select="concat($tab,'case uib_label:',$newline,
					$tab,$tab,'*widget_handler = label_widget_handler_get_instance();',$newline,
					$tab,$tab,'break;',$newline)" />
			</xsl:if>
			<xsl:if test="count(.//radio[@data_bind != ''])>0">
				<xsl:value-of
					select="concat($tab,'case uib_radio:',$newline,
					$tab,$tab,'*widget_handler = radio_widget_handler_get_instance();',$newline,
					$tab,$tab,'break;',$newline)" />
			</xsl:if>
			<xsl:if test="count(.//flipselector[@data_bind != ''])>0">
				<xsl:value-of
					select="concat($tab,'case uib_flipselector:',$newline,
					$tab,$tab,'*widget_handler = flipselector_widget_handler_get_instance();',$newline,
					$tab,$tab,'break;',$newline)" />
			</xsl:if>
			<xsl:if test="count(.//flipselectoritem[@data_bind != ''])>0">
				<xsl:value-of
					select="concat($tab,'case uib_flipselectoritem:',$newline,
					$tab,$tab,'*widget_handler = flipselectoritem_widget_handler_get_instance();',$newline,
					$tab,$tab,'break;',$newline)" />
			</xsl:if>
			<xsl:if test="count(.//genlist[@data_bind != ''])>0">
				<xsl:value-of
					select="concat($tab,'case uib_genlist:',$newline,
					$tab,$tab,'//*widget_handler = genlist_widget_handler_get_instance();',$newline,
					$tab,$tab,'break;',$newline)" />
			</xsl:if>
<xsl:text disable-output-escaping="yes">
<![CDATA[	default:
		break;
	}
}

/**
 * Iterates through all bindings for current view, and performs binding
 */
void perform_databinding(uib_view_context* vc) {
	dlog_print(DLOG_DEBUG, LOG_TAG, "%s - ", __func__);

	currentViewContext = vc;
	//Extract bindingInfo from this view context
	extract_binding_info_from_view_context(vc);

	for (int i = 0; i < binding_count; ++i) {
		if (view_bindings[i] != NULL) {

			if (view_bindings[i]->dataModelContext) {
				widget_handler_st *widget_handler = NULL;

				Databinding_callback binding_cb = NULL;

				get_widget_handler(view_bindings[i], &widget_handler);
				if (widget_handler != NULL) {
					binding_cb = widget_handler->binding_cb;
					if (binding_cb != NULL) {
						binding_cb(view_bindings[i]->widget,
								view_bindings[i]->binding_element_path,
								view_bindings[i]->binding_type,
								view_bindings[i]->dataModelContext->root_element,
								view_bindings[i]->dataModelContext->datasource->ds_content_type);
					}
				}
			}
		}
	}
}


static void refresh_databinding(){
	dlog_print(DLOG_DEBUG,LOG_TAG,"%s - ",__func__);
	perform_databinding(currentViewContext);
}

static void register_refresh_databinding_callback_to_bound_datamodels() {
	uib_datamodels_get_instance()->register_attached_datasource_update_cb(
			&refresh_databinding);
}

static void cleanup_databinding() {
	dlog_print(DLOG_DEBUG,LOG_TAG,"%s - ",__func__);
	uib_databindings_get_instance()->free_all_databindings();
	uib_datamodels_get_instance()->free_all_datamodels();
	uib_datasource_manager_get_instance()->free_all_datasources();
}

uib_databinding_manager_st* uib_databinding_manager_get_instance() {
	if (!g_uib_databinding_manager._is_init) {
		g_uib_databinding_manager._is_init = true;
		register_refresh_databinding_callback_to_bound_datamodels();
		g_uib_databinding_manager.free_all_databinding_resources =
				&cleanup_databinding;
		g_uib_databinding_manager.perform_databinding = &perform_databinding;
	}
	return &g_uib_databinding_manager;
}
]]>
</xsl:text>
	</xsl:template>
</xsl:stylesheet>