<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:exslt="http://exslt.org/common">

	<xsl:template match="calendar">
		<xsl:param name="parent" />
		<xsl:param name="view_configuration_id" />
		<xsl:param name="level" select="count(./ancestor::*)-count(//view/ancestor::*)" />
		<xsl:param name="indentation">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level" />
			</xsl:call-template>
		</xsl:param>
		<xsl:param name="indentation1">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level+1" />
			</xsl:call-template>
		</xsl:param>

		<xsl:value-of select="concat($indentation, 'if (!vc->', @id, ') {', $newline)" />
		<xsl:value-of select="concat($indentation1,'vc->', @id, ' = elm_calendar_add(vc->', $parent, ');', $newline)" />
		<xsl:value-of select="concat($indentation,'}', $newline)" />

		<xsl:value-of select="concat($indentation, 'if (vc->', @id, ') {', $newline)" />

		<xsl:call-template name="size_hint_align_set">
			<xsl:with-param name="align_h" select="@align_h" />
			<xsl:with-param name="align_v" select="@align_v" />
			<xsl:with-param name="indentation" select="$indentation1" />
			<xsl:with-param name="id" select="@id" />
		</xsl:call-template>

		<xsl:call-template name="size_hint_weight_set">
			<xsl:with-param name="weight_h" select="@weight_h" />
			<xsl:with-param name="weight_v" select="@weight_v" />
			<xsl:with-param name="indentation" select="$indentation1" />
			<xsl:with-param name="id" select="@id" />
		</xsl:call-template>

		<xsl:choose>
			<xsl:when test="string-length(@min_year) = 0 and string-length(@max_year) = 0 " />
			<xsl:otherwise>
				<xsl:value-of select="concat($indentation1, 'elm_calendar_min_max_year_set(vc->', @id, ', ', @min_year, ', ', @max_year, ');', $newline)" />
			</xsl:otherwise>
		</xsl:choose>

		<xsl:if test="string-length(@select_mode) != 0">
			<xsl:variable name="rconv_key" select="concat('calendar:select_mode', ':', @select_mode)" />
			<xsl:variable name="rconv_value" select="exslt:node-set($value_map)//entry[@key=$rconv_key]" />
			<xsl:choose>
				<xsl:when test="string-length($rconv_value) != 0">
					<xsl:value-of select="concat($indentation1, 'elm_calendar_select_mode_set(vc->', @id, ', (Elm_Calendar_Select_Mode)' ,$rconv_value,');', $newline)" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="concat($indentation1, 'elm_calendar_select_mode_set(vc->', @id, ', ' ,@select_mode,');', $newline)" />
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>

		<xsl:if test="string-length(@interval) != 0">
			<xsl:value-of select="concat($indentation1, 'elm_calendar_interval_set(vc->', @id, ', ', @interval, ');', $newline)" />
		</xsl:if>

		<xsl:apply-templates select="*">
			<xsl:with-param name="parent" select="@id" />
		</xsl:apply-templates>

		<xsl:if test="@disable = 'true'">
			<xsl:value-of select="concat($indentation1, 'elm_object_disabled_set(vc->', @id, ', EINA_TRUE);', $newline)" />
		</xsl:if>

		<xsl:apply-templates mode="visible" select="current()">
			<xsl:with-param name="parent" select="@id" />
			<xsl:with-param name="view_configuration_id" select="$view_configuration_id" />
		</xsl:apply-templates>

		<xsl:value-of select="concat($indentation,'}', $newline)" />
	</xsl:template>
</xsl:stylesheet>
