<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:exslt="http://exslt.org/common">
	<xsl:template name="customcomponentresizemode">
		<xsl:param name="resize_mode" />
		<xsl:param name="indentation" />
		<xsl:param name="id" />
		<xsl:if test="string-length($resize_mode) = 0">
			<xsl:value-of select="concat($indentation, 'evas_object_size_hint_aspect_set( vc->', $id, ', EVAS_ASPECT_CONTROL_BOTH, 1, 1);', $newline)" />
		</xsl:if>
		<xsl:if test="@resize_mode = 'both'">
			<xsl:value-of select="concat($indentation, 'evas_object_size_hint_aspect_set(vc->', $id, ', EVAS_ASPECT_CONTROL_BOTH, 1, 1);', $newline)" />
		</xsl:if>
		<xsl:if test="@resize_mode = 'horizontal'">
			<xsl:value-of select="concat($indentation, 'evas_object_size_hint_aspect_set(vc->', $id, ', EVAS_ASPECT_CONTROL_HORIZONTAL, 1, 1);', $newline)" />

		</xsl:if>
		<xsl:if test="@resize_mode = 'vertical'">
			<xsl:value-of select="concat($indentation, 'evas_object_size_hint_aspect_set(vc->', $id, ', EVAS_ASPECT_CONTROL_VERTICAL, 1, 1);', $newline)" />
		</xsl:if>
		<xsl:if test="@resize_mode = 'none'">
			<xsl:value-of select="concat($indentation, 'evas_object_size_hint_aspect_set(vc->', $id, ', EVAS_ASPECT_CONTROL_NONE, 1, 1);', $newline)" />
		</xsl:if>
	</xsl:template>

	<xsl:template name="customcomponentcolor">
		<xsl:param name="colors" />
		<xsl:param name="indentation" />
		<xsl:param name="id" />
		<xsl:if test="string-length($colors) != 0">
			<xsl:variable name="colorpick" select="normalize-space(substring-before($colors, ';'))" />
			<xsl:if test="string-length($colorpick)!= 0">
				<xsl:variable name="colorclass" select="normalize-space(substring-before($colorpick, ':'))" />
				<xsl:variable name="colorname" select="normalize-space(substring-after($colorpick, ':'))" />
				<xsl:variable name="colorclassname" select="normalize-space(substring-before($colorname, '.'))" />
				<xsl:variable name="colorclassvalue" select="normalize-space(substring-after($colorname, '.'))" />
				<xsl:value-of select="concat($indentation, 'int ', $id, '_',$colorclassname,'_hexValue = strtol(&quot;', $colorclassvalue, '&quot;+1, NULL, 16);', $newline)" />
				<xsl:value-of disable-output-escaping="yes"
					select="concat($indentation, 'int ', $id, '_',$colorclassname,'_r = (', $id, '_',$colorclassname,'_hexValue', '&amp;', '0xFF0000)', '&gt;&gt;', '16;', $newline)" />
				<xsl:value-of disable-output-escaping="yes"
					select="concat($indentation, 'int ', $id, '_',$colorclassname,'_g = (', $id, '_',$colorclassname,'_hexValue', '&amp;', '0xFF00)', '&gt;&gt;', '8;', $newline)" />
				<xsl:value-of disable-output-escaping="yes"
					select="concat($indentation, 'int ', $id, '_',$colorclassname,'_b = (', $id, '_',$colorclassname,'_hexValue', '&amp;', '0xFF);', $newline)" />
				<xsl:value-of
					select="concat($indentation, 'edje_object_color_class_set(vc->', $id, ',', '&quot;', $colorclassname, '&quot;', ', ', $id, '_',$colorclassname,'_r, ', $id, '_',$colorclassname,'_g, ', $id, '_',$colorclassname,'_b, 255,', $id, '_',$colorclassname,'_r, ', $id, '_',$colorclassname,'_g, ', $id, '_',$colorclassname,'_b, 255,', $id, '_',$colorclassname,'_r, ', $id, '_',$colorclassname,'_g, ', $id, '_',$colorclassname,'_b, 255);', $newline)" />
			</xsl:if>
			<xsl:for-each select=".">
				<xsl:call-template name="customcomponentcolor">
					<xsl:with-param name="colors" select="normalize-space(substring-after($colors, ';'))" />
					<xsl:with-param name="indentation" select="$indentation" />
					<xsl:with-param name="id" select="$id" />

				</xsl:call-template>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>

	<xsl:template name="customcomponenttext">
		<xsl:param name="texts" />
		<xsl:param name="indentation" />
		<xsl:param name="id" />
		<xsl:if test="string-length($texts) != 0">
			<xsl:variable name="textpick" select="normalize-space(substring-before($texts, ';'))" />
			<xsl:if test="string-length($textpick)!= 0">
				<xsl:variable name="textclass" select="normalize-space(substring-before($textpick, ':'))" />
				<xsl:variable name="textname" select="normalize-space(substring-after($textpick, ':'))" />
				<xsl:variable name="textclassname" select="normalize-space(substring-before($textname, '.'))" />
				<xsl:variable name="textclassvalue" select="normalize-space(substring-after($textname, '.'))" />
				<xsl:choose>
					<xsl:when test="string-length($textclassvalue)!= 0">
						<xsl:value-of
							select="concat($indentation, 'edje_object_part_text_set(vc->', $id, ',', '&quot;', $textclassname, '&quot;', ', _UIB_LOCALE(&quot;',$textclassvalue , '&quot;));', $newline)" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of
							select="concat($indentation, 'edje_object_part_text_set(vc->', $id, ',', '&quot;', $textclassname, '&quot;', ', _UIB_LOCALE(&quot;&quot;));', $newline)" />
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<xsl:for-each select=".">
				<xsl:call-template name="customcomponenttext">
					<xsl:with-param name="texts" select="normalize-space(substring-after($texts, ';'))" />
					<xsl:with-param name="indentation" select="$indentation" />
					<xsl:with-param name="id" select="$id" />

				</xsl:call-template>
			</xsl:for-each>

		</xsl:if>
	</xsl:template>
	<xsl:template name="customcomponentstate">
		<xsl:param name="states" />
		<xsl:param name="indentation" />
		<xsl:param name="id" />
		<xsl:if test="string-length($states) != 0">
			<xsl:variable name="statepick" select="normalize-space(substring-before($states, ';'))" />
			<xsl:if test="string-length($statepick)!= 0">
				<xsl:variable name="stateclass" select="normalize-space(substring-before($statepick, ':'))" />
				<xsl:variable name="statename" select="normalize-space(substring-after($statepick, ':'))" />
				<xsl:variable name="stateclassname" select="normalize-space(substring-before($statename, '.'))" />
				<xsl:variable name="stateclassvalue" select="normalize-space(substring-after($statename, '.'))" />
				<xsl:variable name="stateclasssignal" select="normalize-space(substring-before($stateclassvalue, '.'))" />
				<xsl:variable name="stateclasssource" select="normalize-space(substring-after($stateclassvalue, '.'))" />
				<xsl:choose>
					<xsl:when test="string-length($stateclasssource)!= 0">
						<xsl:value-of
							select="concat($indentation, 'edje_object_signal_emit(vc->', $id, ',&quot;' ,  $stateclasssignal, '&quot;, &quot;',$stateclasssource , '&quot;);', $newline)" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="concat($indentation, 'edje_object_signal_emit(vc->', $id, ',&quot;' ,  $stateclasssignal, '&quot;, &quot;&quot;);', $newline)" />
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<xsl:for-each select=".">
				<xsl:call-template name="customcomponentstate">
					<xsl:with-param name="states" select="normalize-space(substring-after($states, ';'))" />
					<xsl:with-param name="indentation" select="$indentation" />
					<xsl:with-param name="id" select="$id" />
				</xsl:call-template>
			</xsl:for-each>

		</xsl:if>
	</xsl:template>
	<xsl:template match="customcomponent">
		<xsl:param name="parent" />
		<xsl:param name="view_configuration_id" />
		<xsl:param name="is_version_rm_support" />
		<xsl:param name="level" select="count(./ancestor::*)-count(//view/ancestor::*)" />
		<xsl:param name="indentation">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level" />
			</xsl:call-template>
		</xsl:param>
		<xsl:param name="indentation1">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level+1" />
			</xsl:call-template>
		</xsl:param>
		<xsl:param name="indentation2">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level+2" />
			</xsl:call-template>
		</xsl:param>

		<xsl:choose>
			<xsl:when test="name(parent::node())='view'">
				<xsl:value-of select="concat($indentation, 'if (!vc->', @id, ') {', $newline)" />
				<xsl:value-of select="concat($indentation1, 'vc->', @id, '= edje_object_add(parent);', $newline)" />
				<xsl:value-of select="concat($indentation1, 'vc->root_container = vc->', @id, ';', $newline)" />
				<xsl:value-of select="concat($indentation,'}', $newline)" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="concat($indentation, 'if (!vc->', @id, ') {', $newline)" />
				<xsl:value-of select="concat($indentation1, 'vc->', @id, '= edje_object_add(vc->', $parent, ');', $newline)" />
				<xsl:value-of select="concat($indentation,'}', $newline)" />
			</xsl:otherwise>
		</xsl:choose>

		<xsl:value-of select="$indentation" />
		<xsl:value-of select="concat('if(vc->', @id, ') {')" />
		<xsl:value-of select="$newline" />
		<xsl:choose>
			<xsl:when test="string-length(@name) != 0">
				<xsl:variable name="escapedSrc">
					<xsl:call-template name="escapeStr">
						<xsl:with-param name="str" select="@name" />
					</xsl:call-template>
				</xsl:variable>
				<!-- <xsl:variable name="file_path"> <xsl:choose> <xsl:when test="contains($escapedSrc, '.edc')"> <xsl:value-of select="substring-before($escapedSrc, '.edc')" 
					/> <xsl:text>.edj</xsl:text> </xsl:when> <xsl:otherwise> <xsl:value-of select="$escapedSrc" /> </xsl:otherwise> </xsl:choose> </xsl:variable> -->
				<!-- <xsl:value-of select="concat($indentation1, 'char ', @id, '_resource_path[PATH_MAX] = {0, };', $newline)"/> -->
				<xsl:value-of select="concat($indentation1, 'char *resource_path = NULL;', $newline)" />
				<xsl:choose>
					<xsl:when test="$is_version_rm_support='true'">
						<xsl:value-of
							select="concat($indentation1, 'uib_util_rm_get_resource_path(APP_RESOURCE_TYPE_IMAGE, &quot;custom-components/', $escapedSrc, '.edj&quot;, &amp;resource_path);', $newline)" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of
							select="concat($indentation1, 'uib_util_rm_get_resource_path(-1, &quot;custom-components/', $escapedSrc, '.edj&quot;, &amp;resource_path);', $newline)" />
					</xsl:otherwise>
				</xsl:choose>
				<xsl:value-of select="concat($indentation1, 'edje_object_file_set(vc->', @id, ', resource_path', ', &quot;', @group, '&quot;);')" />
				<xsl:value-of select="$newline" />
				<xsl:value-of select="concat($indentation1, 'if(resource_path) {', $newline)" />
				<xsl:value-of select="concat($indentation2, 'free(resource_path);', $newline)" />
				<xsl:value-of select="concat($indentation1, '}', $newline)" />

				<!-- <xsl:value-of select="concat($indentation1 , 'app_get_resource(&quot;', $file_path, '&quot; , ', @id, '_resource_path, (int)PATH_MAX);', $newline)" /> <xsl:value-of 
					select="concat($indentation1 , 'elm_layout_file_set(vc->', @id, ', ', @id, '_resource_path' , ', &quot;', @group, '&quot;);')" /> -->
				<xsl:value-of select="$newline" />
			</xsl:when>
			<xsl:otherwise>
			</xsl:otherwise>
		</xsl:choose>

		<xsl:call-template name="customcomponentresizemode">
			<xsl:with-param name="resize_mode" select="@resize_mode" />
			<xsl:with-param name="indentation" select="$indentation1" />
			<xsl:with-param name="id" select="@id" />
		</xsl:call-template>

		<xsl:call-template name="customcomponentcolor">
			<xsl:with-param name="colors" select="@colors" />
			<xsl:with-param name="indentation" select="$indentation1" />
			<xsl:with-param name="id" select="@id" />
		</xsl:call-template>

		<xsl:call-template name="customcomponentstate">
			<xsl:with-param name="states" select="@states" />
			<xsl:with-param name="indentation" select="$indentation1" />
			<xsl:with-param name="id" select="@id" />
		</xsl:call-template>

		<xsl:call-template name="customcomponenttext">
			<xsl:with-param name="texts" select="@texts" />
			<xsl:with-param name="indentation" select="$indentation1" />
			<xsl:with-param name="id" select="@id" />
		</xsl:call-template>

		<xsl:call-template name="size_hint_align_set">
			<xsl:with-param name="align_h" select="@align_h" />
			<xsl:with-param name="align_v" select="@align_v" />
			<xsl:with-param name="indentation" select="$indentation1" />
			<xsl:with-param name="id" select="@id" />
		</xsl:call-template>
		<xsl:value-of select="$newline" />

		<xsl:call-template name="size_hint_weight_set">
			<xsl:with-param name="weight_h" select="@weight_h" />
			<xsl:with-param name="weight_v" select="@weight_v" />
			<xsl:with-param name="indentation" select="$indentation1" />
			<xsl:with-param name="id" select="@id" />
		</xsl:call-template>

		<xsl:apply-templates mode="visible" select="current()">
			<xsl:with-param name="parent" select="@id" />
			<xsl:with-param name="view_configuration_id" select="$view_configuration_id" />
		</xsl:apply-templates>
		<xsl:value-of select="concat($indentation,'}', $newline)" />
	</xsl:template>
</xsl:stylesheet>