<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:template match="circleslider">
		<xsl:param name="parent" />
		<xsl:param name="view_configuration_id" />
		<xsl:param name="level" select="count(./ancestor::*)-count(//view/ancestor::*)" />
		<xsl:param name="indentation">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level" />
			</xsl:call-template>
		</xsl:param>
		<xsl:param name="indentation1">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level+1" />
			</xsl:call-template>
		</xsl:param>
		<xsl:value-of select="concat($indentation, 'if (!vc->', @id, ') {', $newline)" />
		<xsl:value-of
			select="concat($indentation1, 'vc->', @id, ' = eext_circle_object_slider_add(vc->',$parent,', uib_views_get_instance()->get_window_obj()->circle_surface);', $newline)" />
		<xsl:value-of select="concat($indentation,'}', $newline)" />
		<xsl:value-of select="concat($indentation, 'if(vc->', @id, ') {', $newline)" />
		<xsl:value-of select="concat($indentation1, 'eext_rotary_object_event_activated_set(vc->', @id, ', EINA_TRUE);', $newline)" />
		<xsl:if test="string-length(@unit_format) != 0">
			<xsl:value-of select="concat($indentation1, 'elm_slider_unit_format_set(vc->', @id, ',', '&quot;', @unit_format, '&quot;', ');', $newline)" />
		</xsl:if>
		<xsl:if test="string-length(@indicator_format) != 0">
			<xsl:value-of select="concat($indentation1, 'elm_slider_indicator_format_set(vc->', @id, ',', '&quot;', @indicator_format, '&quot;', ');', $newline)" />
		</xsl:if>
		<xsl:if test="string-length(@span_size) != 0">
			<xsl:value-of select="concat($indentation1, 'elm_slider_span_size_set(vc->', @id, ',', @span_size, ');', $newline)" />
		</xsl:if>
		<xsl:if test="@direction = 'vertical'">
			<xsl:value-of select="concat($indentation1, 'elm_slider_horizontal_set(vc->', @id, ', EINA_FALSE);', $newline)" />
		</xsl:if>

		<xsl:call-template name="style">
			<xsl:with-param name="style" select="@style" />
			<xsl:with-param name="indentation" select="$indentation1" />
			<xsl:with-param name="id" select="@id" />
		</xsl:call-template>

		<xsl:if test="string-length(@min) != 0 and string-length(@max) != 0">
			<xsl:value-of select="concat($indentation1, 'eext_circle_object_value_min_max_set(vc->', @id, ',', @min, ',', @max, ');', $newline)" />
		</xsl:if>
		<xsl:if test="string-length(@value) != 0">
			<xsl:value-of select="concat($indentation1, 'eext_circle_object_value_set(vc->', @id, ',', @value, ');', $newline)" />
		</xsl:if>

		<xsl:if test="@inverted = 'true'">
			<xsl:value-of select="concat($indentation1, 'elm_slider_inverted_set(vc->', @id, ', EINA_TRUE);', $newline)" />
		</xsl:if>

		<xsl:if test="string-length(@step) != 0">
			<xsl:value-of select="concat($indentation1, 'eext_circle_object_slider_step_set(vc->', @id, ',', @step, ');', $newline)" />
		</xsl:if>

		<xsl:if test="@show-indicator = 'true'">
			<xsl:value-of select="concat($indentation1, 'elm_slider_indicator_show_set(vc->', @id, ', EINA_TRUE);', $newline)" />
		</xsl:if>



		<xsl:call-template name="size_hint_align_set">
			<xsl:with-param name="align_h" select="@align_h" />
			<xsl:with-param name="align_v" select="@align_v" />
			<xsl:with-param name="indentation" select="$indentation1" />
			<xsl:with-param name="id" select="@id" />
		</xsl:call-template>
		<xsl:value-of select="$newline" />

		<xsl:call-template name="size_hint_weight_set">
			<xsl:with-param name="weight_h" select="@weight_h" />
			<xsl:with-param name="weight_v" select="@weight_v" />
			<xsl:with-param name="indentation" select="$indentation1" />
			<xsl:with-param name="id" select="@id" />
		</xsl:call-template>
		<xsl:value-of select="$newline" />

		<xsl:if test="@disable = 'true'">
			<xsl:value-of select="concat($indentation1, 'elm_object_disabled_set(vc->', @id, ', EINA_TRUE);', $newline)" />
		</xsl:if>
		<xsl:apply-templates mode="visible" select="current()">
			<xsl:with-param name="parent" select="@id" />
			<xsl:with-param name="view_configuration_id" select="$view_configuration_id" />
		</xsl:apply-templates>

		<xsl:value-of select="concat($indentation,'}', $newline)" />
	</xsl:template>
</xsl:stylesheet>
