<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:variable name="newline">
		<xsl:text>
</xsl:text>
	</xsl:variable>
	<xsl:variable name="tab">
		<xsl:text disable-output-escaping="yes">	</xsl:text>
	</xsl:variable>


	<xsl:template match="/">
		<xsl:variable name="data_bind_count" select="count(//*[@data_bind != ''])" />
		<xsl:variable name="databinding_done">
			<xsl:choose>
				<xsl:when test="$data_bind_count>0">
					<xsl:value-of select="'yes'"></xsl:value-of>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="'no'"></xsl:value-of>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:if test="$databinding_done='yes'">
			<xsl:apply-templates select="//views" />
		</xsl:if>
	</xsl:template>

	<xsl:template match="views">
		<xsl:text disable-output-escaping="yes">
<![CDATA[/*******************************************************************************
* This file was generated by UI Builder.
* This file will be auto-generated each and everytime you save your project.
* Do not hand edit this file.
********************************************************************************/
#include "uib_views_binding.h"
]]>
</xsl:text>
		<xsl:for-each select="/document/views/view">
			<xsl:variable name="view_data_bind_count" select="count(.//*[@data_bind!=''])" />
			<xsl:if test="$view_data_bind_count>0">
				<xsl:variable name="view_id" select="@id" />
				<xsl:value-of
					select="concat('#include &quot;uib_',$view_id,'_bindings.h&quot;',$newline)" />
			</xsl:if>
		</xsl:for-each>

		<xsl:text disable-output-escaping="yes">
<![CDATA[static uib_databindings_st g_uib_databindings;

static char* str_lower(const char* const str) {
	int i = 0;
	char* strLower = (char*) malloc((strlen(str) + 1) * sizeof(char));
	while (str[i] != '\0') {
		strLower[i] = tolower(str[i]);
		++i;
	}
	strLower[i]='\0';
	return strLower;
}

widget_binding_type get_binding_type(const char * str_binding_type) {
	widget_binding_type binding_type =text;
	char * formatted_binding_type = str_lower(str_binding_type);
	if (!strcmp(formatted_binding_type, "foreach")) {
		binding_type= foreach;
	}
	free(formatted_binding_type);
	return binding_type;
}

void cleanup_databindings() {
]]>
</xsl:text>
		<xsl:for-each select="/document/views/view">
			<xsl:variable name="view_data_bind_count" select="count(.//*[@data_bind!=''])" />
			<xsl:if test="$view_data_bind_count>0">
				<xsl:variable name="view_id" select="@id" />
				<xsl:value-of
					select="concat($tab,'cleanup_',$view_id,'_binding();',$newline)" />
			</xsl:if>
		</xsl:for-each>
		<xsl:text disable-output-escaping="yes">
<![CDATA[}

uib_databindings_st* uib_databindings_get_instance() {
	if (!g_uib_databindings._is_init) {
		g_uib_databindings._is_init = true;
		g_uib_databindings.free_all_databindings = &cleanup_databindings;
		g_uib_databindings.get_binding_type = &get_binding_type;
	}
	return &g_uib_databindings;
}
]]>
</xsl:text>
	</xsl:template>
</xsl:stylesheet>