<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:exslt="http://exslt.org/common">
	<xsl:template match="hoverselitem">
		<xsl:param name="parent" />
		<xsl:param name="is_version_rm_support" />
		<xsl:param name="level"
			select="count(./ancestor::*)-count(//view/ancestor::*)" />
		<xsl:param name="indentation">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level" />
			</xsl:call-template>
		</xsl:param>
		<xsl:param name="indentation1">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level+1" />
			</xsl:call-template>
		</xsl:param>
		<xsl:variable name="callback">
			<xsl:apply-templates select="event" mode="item_event">
				<xsl:with-param name="parent" select="@id" />
				<xsl:with-param name="view" select="./ancestor::view/@id" />
				<!-- Storyboard_START -->
				<xsl:with-param name="target" select="event/@target" />
				<!-- Storyboard_END -->
			</xsl:apply-templates>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="string-length($callback) != 0">
						<xsl:value-of
							select="concat($indentation, 'vc->', @id, '= elm_hoversel_item_add(vc->', $parent, ', _UIB_LOCALE(&quot;', @text, '&quot;)',', NULL, ELM_ICON_NONE, (Evas_Smart_Cb)', $callback, ', NULL);', $newline)" />
			</xsl:when>
			<xsl:otherwise>
						<xsl:value-of
							select="concat($indentation, 'vc->', @id, '= elm_hoversel_item_add(vc->', $parent, ', _UIB_LOCALE(&quot;', @text, '&quot;)',', NULL, ELM_ICON_NONE, NULL, NULL);', $newline)" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
