/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.efluibuilder.utility;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.tizen.common.util.Assert;

public final class ImageUtil {
    public static Path createCirclePath(int n, int n2, int n3, int n4) {
        Path path = new Path(null);
        path.addArc((float)n, (float)n2, (float)n3, (float)n4, 0.0f, 360.0f);
        return path;
    }

    public static Point getBestSize(Point point, Point point2) {
        return ImageUtil.getBestSize(point.x, point.y, point2.x, point2.y);
    }

    public static Point getBestSize(int n, int n2, int n3, int n4) {
        double d = ImageUtil.getBestRatio(n, n2, n3, n4);
        int n5 = (int)((double)n / d);
        int n6 = (int)((double)n2 / d);
        return new Point(n5, n6);
    }

    public static double getBestRatio(int n, int n2, int n3, int n4) {
        double d = (double)n / (double)n3;
        double d2 = (double)n2 / (double)n4;
        double d3 = d > d2 ? d : d2;
        return d3;
    }

    public static Image resizeBestSize(Image image, int n, int n2) {
        Assert.notNull((Object)image);
        Point point = ImageUtil.getBestSize(image.getBounds().width, image.getBounds().height, n, n2);
        return ImageUtil.resize(image, point.x, point.y);
    }

    public static ImageData resize(ImageData imageData, int n, int n2, boolean bl) {
        Assert.notNull((Object)imageData);
        if (imageData.width == n && imageData.height == n2) {
            return imageData;
        }
        if (bl) {
            Image image = null;
            Image image2 = new Image((Device)Display.getCurrent(), imageData);
            ImageData imageData2 = null;
            image = ImageUtil.resize(image2, n, n2);
            imageData2 = image.getImageData();
            image.dispose();
            image2.dispose();
            return imageData2;
        }
        return imageData.scaledTo(n, n2);
    }

    public static boolean isResizeRequired(Image image, int n, int n2) {
        Rectangle rectangle = image.getBounds();
        return rectangle.width != n || rectangle.height != n2;
    }

    public static Image resize(Image image, int n, int n2) {
        Assert.notNull((Object)image);
        Image image2 = new Image((Device)Display.getDefault(), n, n2);
        GC gC = new GC((Drawable)image2);
        if (!SWT.getPlatform().equals("gtk")) {
            gC.setAdvanced(true);
        }
        if (gC.getAdvanced()) {
            gC.setAntialias(1);
            gC.setInterpolation(2);
        }
        gC.drawImage(image, 0, 0, image.getBounds().width, image.getBounds().height, 0, 0, n, n2);
        gC.dispose();
        return image2;
    }

    public static byte[] saveImage(Image image, int n) {
        Assert.notNull((Object)image);
        ImageLoader imageLoader = new ImageLoader();
        imageLoader.data = new ImageData[]{image.getImageData()};
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        imageLoader.save((OutputStream)byteArrayOutputStream, n);
        return byteArrayOutputStream.toByteArray();
    }

    public static Image addBorderImage(Image image, int n, int n2, Color color) {
        Image image2 = new Image((Device)Display.getDefault(), n, n2);
        GC gC = new GC((Drawable)image2);
        gC.drawImage(image, 0, 0, image.getBounds().width, image.getBounds().height, 0, 0, n, n2);
        gC.setForeground(color);
        gC.drawRectangle(0, 0, n - 1, n2 - 1);
        gC.dispose();
        return image2;
    }
}

