/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.efluibuilder.internal.connector;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.tizen.efluibuilder.internal.connector.Connector;
import org.tizen.efluibuilder.internal.connector.IService;
import org.tizen.efluibuilder.internal.connector.Service;
import org.tizen.efluibuilder.internal.connector.ServiceFactory;

public final class ConnectorFactory {
    private static ConnectorFactory instance = null;
    private Map<String, Connector> connectors = new HashMap<String, Connector>();
    private Map<String, Integer> references = new HashMap<String, Integer>();

    public static synchronized ConnectorFactory getDefault() {
        if (instance == null) {
            instance = new ConnectorFactory();
        }
        return instance;
    }

    private ConnectorFactory() {
    }

    private String createId(String string, String string2) {
        String string3 = String.valueOf(string) + "-" + string2;
        return string3;
    }

    private int getReference(String string) {
        return this.references.get(string);
    }

    private void addReference(String string) {
        if (!this.references.containsKey(string)) {
            this.references.put(string, 1);
            return;
        }
        int n = this.getReference(string);
        this.references.put(string, n + 1);
    }

    private void removeReference(String string) {
        int n = this.getReference(string);
        this.references.put(string, n - 1);
    }

    public Connector create(String string, String string2) throws IOException {
        String string3 = this.createId(string, string2);
        Connector connector = this.connectors.get(string3);
        if (connector != null && connector.isConnected()) {
            this.addReference(string3);
            return connector;
        }
        ServiceFactory serviceFactory = ServiceFactory.getDefault();
        IService iService = serviceFactory.create(string, string2);
        if (iService instanceof Service && ((Service)iService).isConnected) {
            if (connector == null) {
                connector = new Connector();
                connector.setId(string3);
                this.connectors.put(string3, connector);
            }
            connector.create(iService);
            this.addReference(string3);
        }
        return connector;
    }

    void destroyForcely(String string) {
        this.references.put(string, 0);
        Connector connector = this.connectors.get(string);
        connector.destroy();
        ServiceFactory serviceFactory = ServiceFactory.getDefault();
        serviceFactory.destroy(string);
    }

    public void destroy(String string, String string2) {
        String string3 = this.createId(string, string2);
        this.removeReference(string3);
        int n = this.getReference(string3);
        if (n != 0) {
            return;
        }
        Connector connector = this.connectors.get(string3);
        this.connectors.remove(string3);
        connector.destroy();
        ServiceFactory serviceFactory = ServiceFactory.getDefault();
        serviceFactory.destroy(string3);
    }
}

