/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.efluibuilder.core.configurator;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.tizen.efluibuilder.core.configuration.device.DeviceManager;
import org.tizen.efluibuilder.core.configurator.ConfiguratorException;
import org.tizen.efluibuilder.model.descriptors.DescriptorManager;
import org.tizen.efluibuilder.utility.ResourceUtil;
import org.xml.sax.SAXException;

public enum Configurator {
    MOBILE_2_3("mobile-2.3", "res/devices/mobile-2.3", "res/mobile-2.3", "res/xsd/mobile_2.3"),
    MOBILE_2_3_1("mobile-2.3.1", MOBILE_2_3),
    WEARABLE_2_3_1("wearable-2.3.1", "res/devices/wearable-2.3.1", "res/wearable-2.3.1", "res/xsd/wearable_2.3.1"),
    WEARABLE_CIRCLE_2_3_1("wearable-circle-2.3.1", "res/devices/wearable-circle-2.3.1", "res/wearable-circle-2.3.1", "res/xsd/wearable_circle_2.3.1"),
    WEARABLE_CIRCLE_2_3_2("wearable-circle-2.3.2", WEARABLE_CIRCLE_2_3_1),
    MOBILE_2_4("mobile-2.4", "res/devices/mobile-2.3", "res/mobile-2.4", "res/xsd/mobile_2.4"),
    MOBILE_3_0("mobile-3.0", "res/devices/mobile-2.3", "res/mobile-3.0", "res/xsd/mobile_3.0"),
    WEARABLE_CIRCLE_3_0("wearable-circle-3.0", "res/devices/wearable-circle-3.0", "res/wearable-circle-3.0", "res/xsd/wearable_circle_3.0"),
    TV_3_0("tv-3.0", "res/devices/tv-3.0", "res/tv-3.0", "res/xsd/tv_3.0"),
    MOBILE_4_0("mobile-4.0", "res/devices/mobile-2.3", "res/mobile-3.0", "res/xsd/mobile_3.0"),
    WEARABLE_CIRCLE_4_0("wearable-circle-4.0", WEARABLE_CIRCLE_3_0);

    private String platform;
    private String devicePath;
    private String descriptorPath;
    private String schemaPath;
    private static Map<String, DescriptorManager> descriptorMgr;
    private static Map<String, DeviceManager> deviceMgr;

    static {
        descriptorMgr = new HashMap<String, DescriptorManager>();
        deviceMgr = new HashMap<String, DeviceManager>();
    }

    private Configurator(String string2, String string3, String string4, String string5) {
        this.platform = string2;
        this.devicePath = string3;
        this.descriptorPath = string4;
        this.schemaPath = string5;
    }

    private Configurator(String string2, Configurator configurator) {
        this.platform = string2;
        this.devicePath = configurator.getDevicePath();
        this.descriptorPath = configurator.getDescriptorPath();
        this.schemaPath = configurator.getLayoutSchemaLocation();
    }

    public String getPlatform() {
        return this.platform;
    }

    public static Configurator of(String string) {
        Configurator[] configuratorArray = Configurator.values();
        int n = configuratorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Configurator configurator = configuratorArray[n2];
            if (configurator.getPlatform().equals(string)) {
                return configurator;
            }
            ++n2;
        }
        throw new IllegalArgumentException(String.valueOf(string) + " platform is not supported.");
    }

    public String getDescriptorPath() {
        return this.descriptorPath;
    }

    private DescriptorManager createDescriptorManager() {
        DescriptorManager descriptorManager = new DescriptorManager();
        try {
            descriptorManager.load(this.descriptorPath);
        }
        catch (IOException iOException) {
            throw new ConfiguratorException(iOException.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new ConfiguratorException(parserConfigurationException.getMessage());
        }
        catch (SAXException sAXException) {
            throw new ConfiguratorException(sAXException.getMessage());
        }
        return descriptorManager;
    }

    public synchronized DescriptorManager getDescriptorManager() {
        if (!descriptorMgr.containsKey(this.descriptorPath)) {
            descriptorMgr.put(this.descriptorPath, this.createDescriptorManager());
        }
        return descriptorMgr.get(this.descriptorPath);
    }

    public String getDevicePath() {
        return this.devicePath;
    }

    private DeviceManager createDeviceManager() {
        DeviceManager deviceManager = new DeviceManager();
        URI uRI = ResourceUtil.getURI((String)"org.tizen.efluibuilder.configurator", (String)this.devicePath);
        try {
            deviceManager.load(uRI);
        }
        catch (IOException iOException) {
            throw new ConfiguratorException(iOException.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new ConfiguratorException(parserConfigurationException.getMessage());
        }
        catch (SAXException sAXException) {
            throw new ConfiguratorException(sAXException.getMessage());
        }
        return deviceManager;
    }

    public synchronized DeviceManager getDeviceManager() {
        if (!deviceMgr.containsKey(this.devicePath)) {
            deviceMgr.put(this.devicePath, this.createDeviceManager());
        }
        return deviceMgr.get(this.devicePath);
    }

    public String getLayoutSchemaLocation() {
        return this.schemaPath;
    }
}

