/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.efluibuilder.internal.renderer.command;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tizen.common.util.Assert;
import org.tizen.efluibuilder.internal.renderer.Renderer;
import org.tizen.efluibuilder.internal.renderer.command.RendererCommand;
import org.tizen.efluibuilder.renderer.IArguments;
import org.tizen.efluibuilder.renderer.PlaceholderPosition;
import org.tizen.efluibuilder.renderer.event.ReplyEvent;

public final class GetPlaceholderPositionsCommand
extends RendererCommand {
    public GetPlaceholderPositionsCommand(Renderer renderer) {
        super(renderer);
        this.setId("CMD_GET_PLACEHOLDER_POSITIONS");
        this.setEventName("EVENT_GET_PLACEHOLDER_POSITIONS");
    }

    @Override
    public IArguments reply(ReplyEvent replyEvent) {
        String string = replyEvent.contents;
        Map<String, List<PlaceholderPosition>> map = this.parse(string);
        IArguments iArguments = super.reply();
        iArguments.addArg(0, map);
        iArguments.addArg(1, this.getRenderer());
        return iArguments;
    }

    private Map<String, List<PlaceholderPosition>> parse(String string) {
        JsonParser jsonParser = new JsonParser();
        JsonElement jsonElement = jsonParser.parse(string);
        if (jsonElement.isJsonNull()) {
            return null;
        }
        JsonArray jsonArray = jsonElement.getAsJsonArray();
        HashMap<String, List<PlaceholderPosition>> hashMap = new HashMap<String, List<PlaceholderPosition>>();
        int n = 0;
        while (n < jsonArray.size()) {
            JsonElement jsonElement2 = jsonArray.get(n);
            JsonObject jsonObject = jsonElement2.getAsJsonObject();
            JsonPrimitive jsonPrimitive = jsonObject.getAsJsonPrimitive("wid");
            Assert.notNull((Object)jsonPrimitive);
            String string2 = jsonPrimitive.getAsString();
            JsonArray jsonArray2 = jsonObject.getAsJsonArray("ph_list");
            ArrayList<PlaceholderPosition> arrayList = new ArrayList<PlaceholderPosition>();
            if (jsonArray2 != null) {
                for (JsonElement jsonElement3 : jsonArray2) {
                    JsonObject jsonObject2 = jsonElement3.getAsJsonObject();
                    JsonObject jsonObject3 = jsonObject2.getAsJsonObject("rectangle");
                    if (jsonObject3 == null) continue;
                    jsonPrimitive = jsonObject3.getAsJsonPrimitive("x");
                    Assert.notNull((Object)jsonPrimitive);
                    int n2 = jsonPrimitive.getAsInt();
                    jsonPrimitive = jsonObject3.getAsJsonPrimitive("y");
                    Assert.notNull((Object)jsonPrimitive);
                    int n3 = jsonPrimitive.getAsInt();
                    jsonPrimitive = jsonObject3.getAsJsonPrimitive("w");
                    Assert.notNull((Object)jsonPrimitive);
                    int n4 = jsonPrimitive.getAsInt();
                    jsonPrimitive = jsonObject3.getAsJsonPrimitive("h");
                    Assert.notNull((Object)jsonPrimitive);
                    int n5 = jsonPrimitive.getAsInt();
                    jsonPrimitive = jsonObject2.getAsJsonPrimitive("wid");
                    String string3 = "-1";
                    if (jsonPrimitive != null) {
                        string3 = jsonPrimitive.getAsString();
                    }
                    PlaceholderPosition placeholderPosition = new PlaceholderPosition();
                    placeholderPosition.wid = Integer.valueOf(string3);
                    placeholderPosition.x = n2;
                    placeholderPosition.y = n3;
                    placeholderPosition.width = n4;
                    placeholderPosition.height = n5;
                    arrayList.add(placeholderPosition);
                }
            }
            hashMap.put(string2, arrayList);
            ++n;
        }
        return hashMap;
    }
}

