/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.uibuilder.tizenfile;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TizenFileFormatter {
    private static final String ELEMENT_TIZEN_FILE = "tizenFile";
    private static final String ELEMENT_FILE_INFO = "fileInfo";
    private static final String ELEMENT_TYPE = "type";
    private static final String ELEMENT_VERSION = "version";
    private static final String ELEMENT_DESC = "desc";
    private boolean validate = false;
    private String type = null;
    private String version = null;
    private String desc = null;

    public TizenFileFormatter(String string, String string2, String string3) {
        this.type = string;
        this.version = string2;
        this.desc = string3;
    }

    public TizenFileFormatter(Element element) {
        this.validate = this.parse(element);
    }

    public Document generateFileFormat() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = null;
        documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element element = document.createElement(ELEMENT_TIZEN_FILE);
        Element element2 = document.createElement(ELEMENT_FILE_INFO);
        element.appendChild(element2);
        Element element3 = document.createElement(ELEMENT_TYPE);
        element3.setTextContent(this.type);
        element2.appendChild(element3);
        element3 = document.createElement(ELEMENT_VERSION);
        element3.setTextContent(this.version);
        element2.appendChild(element3);
        element3 = document.createElement(ELEMENT_DESC);
        element3.setTextContent(this.desc);
        element2.appendChild(element3);
        document.appendChild(element);
        return document;
    }

    private boolean parse(Element element) {
        if (!element.getNodeName().equals(ELEMENT_TIZEN_FILE)) {
            return false;
        }
        NodeList nodeList = element.getElementsByTagName(ELEMENT_FILE_INFO);
        if (nodeList.getLength() != 1) {
            return false;
        }
        NodeList nodeList2 = nodeList.item(0).getChildNodes();
        int n = 0;
        while (n < nodeList2.getLength()) {
            Node node = nodeList2.item(n);
            if (node instanceof Element) {
                Element element2 = (Element)node;
                if (element2.getNodeName().equals(ELEMENT_TYPE)) {
                    this.type = element2.getTextContent();
                } else if (element2.getNodeName().equals(ELEMENT_VERSION)) {
                    this.version = element2.getTextContent();
                } else if (element2.getNodeName().equals(ELEMENT_DESC)) {
                    this.desc = element2.getTextContent();
                }
            }
            ++n;
        }
        if (this.type == null || this.type.isEmpty()) {
            return false;
        }
        return this.version != null && !this.version.isEmpty();
    }

    public boolean isValidate() {
        return this.validate;
    }

    public String getType() {
        return this.type;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDesc() {
        return this.desc;
    }
}

