<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:template match="*" mode="button.content.set">
		<xsl:param name="parent" />
		<xsl:param name="level" select="count(./ancestor::*)-count(//view/ancestor::*)" />
		<xsl:param name="indentation">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level" />
			</xsl:call-template>
		</xsl:param>
		<xsl:param name="indentation1">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level+1" />
			</xsl:call-template>
		</xsl:param>
		<xsl:choose>
			<xsl:when test="name()='event'" />
			<xsl:when test="name()='icon'">
				<xsl:value-of select="concat($indentation, 'elm_object_part_content_set(vc->', $parent, ',', '&quot;', 'icon', '&quot;, ','vc->' ,@id, ');', $newline)" />
			</xsl:when>
			<xsl:otherwise>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="button">
		<xsl:param name="parent" />
		<xsl:param name="view_configuration_id" />
		<xsl:param name="level" select="count(./ancestor::*)-count(//view/ancestor::*)" />
		<xsl:param name="indentation">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level" />
			</xsl:call-template>
		</xsl:param>
		<xsl:param name="indentation1">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level+1" />
			</xsl:call-template>
		</xsl:param>
		<xsl:value-of select="concat($indentation, 'if (!vc->', @id, ') {', $newline)" />
		<xsl:value-of select="concat($indentation1,'vc->', @id, ' = elm_button_add(vc->', $parent, ');', $newline)" />
		<xsl:value-of select="concat($indentation,'}', $newline)" />
		<xsl:value-of select="concat($indentation, 'if (vc->', @id, ') {', $newline)" />

		<xsl:call-template name="size_hint_align_set">
			<xsl:with-param name="align_h" select="@align_h" />
			<xsl:with-param name="align_v" select="@align_v" />
			<xsl:with-param name="indentation" select="$indentation1" />
			<xsl:with-param name="id" select="@id" />
		</xsl:call-template>

		<xsl:call-template name="size_hint_weight_set">
			<xsl:with-param name="weight_h" select="@weight_h" />
			<xsl:with-param name="weight_v" select="@weight_v" />
			<xsl:with-param name="indentation" select="$indentation1" />
			<xsl:with-param name="id" select="@id" />
		</xsl:call-template>

		<xsl:if test="string-length(@text) != 0">
			<xsl:value-of select="concat($indentation1, 'elm_object_text_set(vc->', @id, ',_UIB_LOCALE(', '&quot;', @text, '&quot;', '));', $newline)" />
		</xsl:if>

		<xsl:call-template name="style">
			<xsl:with-param name="style" select="@style" />
			<xsl:with-param name="indentation" select="$indentation1" />
			<xsl:with-param name="id" select="@id" />
		</xsl:call-template>

		<xsl:call-template name="colors">
			<xsl:with-param name="colors" select="@colors" />
			<xsl:with-param name="indentation" select="$indentation1" />
			<xsl:with-param name="id" select="@id" />
			<xsl:with-param name="widgettype"/>
		</xsl:call-template>


		<xsl:apply-templates select="*">
			<xsl:with-param name="parent" select="@id" />
		</xsl:apply-templates>
		<xsl:apply-templates mode="button.content.set" select="*">
			<xsl:with-param name="parent" select="@id" />
		</xsl:apply-templates>
		<xsl:if test="@disable = 'true'">
			<xsl:value-of select="concat($indentation1, 'elm_object_disabled_set(vc->', @id, ', EINA_TRUE);', $newline)" />
		</xsl:if>
		<xsl:apply-templates mode="visible" select="current()">
			<xsl:with-param name="parent" select="@id" />
			<xsl:with-param name="view_configuration_id" select="$view_configuration_id" />
		</xsl:apply-templates>
		<xsl:value-of select="concat($indentation,'}', $newline)" />
	</xsl:template>


</xsl:stylesheet>
