<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:variable name="newline">
		<xsl:text>
</xsl:text>
	</xsl:variable>
	<xsl:variable name="tab">
		<xsl:text disable-output-escaping="yes">	</xsl:text>
	</xsl:variable>

	<xsl:template match="/">
		<!-- Apply following template only once if call_history type datasource is found -->
		<xsl:if test="//dataBinding/dataSource[@modelType='call_history']">
			<xsl:apply-templates select="//dataBinding" />
		</xsl:if>
	</xsl:template>

	<xsl:template match="dataBinding">

		<xsl:text disable-output-escaping="yes">
<![CDATA[/*******************************************************************************
 * This file was generated by UI Builder.
 * This file will be auto-generated each and everytime you save your project.
 * Do not hand edit this file.
 ********************************************************************************/

#include "uib_datasource_handler_call_history.h"
#include <contacts_types.h>
#include <contacts_views.h>
#include <contacts_errors.h>
#include <contacts_record.h>
#include <contacts_list.h>
#include <contacts_filter.h>
#include <contacts_query.h>
#include <contacts_db.h>
#include <libxml2/libxml/tree.h>

#define MAX_NUM_LENGTH 12

static xmlDocPtr* callHistoryDatasourceRootNode = NULL;
static uib_datasource_interface g_uib_call_history_datasource;
static bool isRefreshCallbackRegistered = false;
static bool is_callhistory_update_databinding_cb_registered = false;

static void (*refresh_databinding_cb)();
static void populate_call_log_entries(xmlNodePtr);
static xmlDocPtr prepare_datasource_XML_tree();
static void refresh_call_history_datasource(const char * const, void*);
static void initialize_call_history_datasource();
static xmlNodePtr getRemotePartyDetails(xmlNodePtr, int);
static void convertToDateFormat(int, char *);
static void getCallLogType(contacts_phone_log_type_e, char**, char**);
static void getFeatureDetails(xmlNodePtr, int);

static void cleanup_datasource() {
	data_contacts_common_disconnect();
	if (isRefreshCallbackRegistered) {
		isRefreshCallbackRegistered = false;
		//Un-register callback functions to be invoked when a record changes.
		contacts_db_remove_changed_cb(_contacts_phone_log._uri,
				refresh_call_history_datasource, NULL);
		contacts_db_remove_changed_cb(_contacts_person_phone_log._uri,
				refresh_call_history_datasource, NULL);
	}
	if (callHistoryDatasourceRootNode != NULL
			&& callHistoryDatasourceRootNode[0] != NULL) {
		xmlFreeDoc(callHistoryDatasourceRootNode[0]);
		callHistoryDatasourceRootNode = NULL;
	}
	is_callhistory_update_databinding_cb_registered = false;
}

static bool populate_call_history_records() {
	if (callHistoryDatasourceRootNode == NULL) {
		callHistoryDatasourceRootNode = (xmlDocPtr*) malloc(sizeof(xmlDocPtr));
		if (!data_contacts_common_connect())
			return false;
	}
	callHistoryDatasourceRootNode[0] = prepare_datasource_XML_tree();
	return true;
}

/*
 * {
 *
 *  "callhistory":{
 *       "length":2,
 *       "entries":[
 *           {
 *				"uid":"123",
 *				"type":"TEL",
 *				"features":[
 *				],
 *				"remoteParties":[
 *					{
 *						"remoteParty":"",
 *						"personId":"3"
 *					}
 *				],
 *				"startTime":"22/03/2001",
 *				"duration":100,
 *				"direction":"DIALED"
 *			}
 *		]
 *	}
 * }
 *
 * 	<?xml version="1.0" encoding="UTF-8" ?>
 *	<callhistory>
 *	<length>2</length>
 *	<entries>
 *		<uid>123</uid>
 *		<type>TEL</type>
 *		<remoteParties>
 *			<remoteParty></remoteParty>
 *			<personId>3</personId>
 *		</remoteParties>
 *		<startTime>22/03/2001</startTime>
 *		<duration>100</duration>
 *		<direction>DIALED</direction>
 *	</entries>
 *	</callhistory>
 *
 */

static xmlDocPtr prepare_datasource_XML_tree() {

	int call_log_count = 0;
	int error_code;

	//Begin xml document
	xmlDocPtr datasource_xmlDoc = xmlNewDoc(BAD_CAST "1.0");

	error_code = contacts_db_get_count(_contacts_phone_log._uri,
			&call_log_count);
	if (error_code != CONTACTS_ERROR_NONE) {
		dlog_print(DLOG_ERROR, LOG_TAG, "contacts_db_get_count() failed: %d",
				error_code);

	} else {
		//Start CallHistory root node
		xmlNodePtr callhistory_root_node = xmlNewNode(NULL,
		BAD_CAST "callhistory");
		xmlDocSetRootElement(datasource_xmlDoc, callhistory_root_node);

		//Accomodate 32 bit int highest value
		char* call_log_count_str = (char*) malloc(
		MAX_NUM_LENGTH * sizeof(char));
		snprintf(call_log_count_str, MAX_NUM_LENGTH, "%d", call_log_count);
		xmlNewChild(callhistory_root_node, NULL, (const xmlChar*) "length",
				(xmlChar*) call_log_count_str);
		free(call_log_count_str);

		xmlNodePtr entriesNode = xmlNewChild(callhistory_root_node, NULL,
				(const xmlChar*) "entries", NULL);

		populate_call_log_entries(entriesNode);
	}

	//Verify generated xml
	//get_xml_data_from_node(datasource_xmlDoc);

	return datasource_xmlDoc;
}

static void getCallLogType(contacts_phone_log_type_e log_type,
		char** call_log_type_str, char** direction) {

	switch (log_type) {
	case 0/*CONTACTS_PLOG_TYPE_NONE*/:
		*call_log_type_str = "";
		break;
	case 1/*CONTACTS_PLOG_TYPE_VOICE_INCOMING*/:
		*call_log_type_str = "Incoming call";
		*direction = "INCOMING";
		break;
	case 2/*CONTACTS_PLOG_TYPE_VOICE_OUTGOING*/:
		*call_log_type_str = "Outgoing call";
		*direction = "DIALED";
		break;
	case 3/*CONTACTS_PLOG_TYPE_VIDEO_INCOMING*/:
		*call_log_type_str = "Incoming video call";
		*direction = "INCOMING";
		break;
	case 4/*CONTACTS_PLOG_TYPE_VIDEO_OUTGOING*/:
		*call_log_type_str = "Outgoing video call";
		*direction = "DIALED";
		break;
	case 5/*CONTACTS_PLOG_TYPE_VOICE_INCOMING_UNSEEN*/:
		*call_log_type_str = "Not confirmed missed call";
		*direction = "INCOMING";
		break;
	case 6/*CONTACTS_PLOG_TYPE_VOICE_INCOMING_SEEN*/:
		*call_log_type_str = "Confirmed missed call";
		*direction = "INCOMING";
		break;
	case 7/*CONTACTS_PLOG_TYPE_VIDEO_INCOMING_UNSEEN*/:
		*call_log_type_str = "Not confirmed missed video call";
		*direction = "INCOMING";
		break;
	case 8/*CONTACTS_PLOG_TYPE_VIDEO_INCOMING_SEEN*/:
		*call_log_type_str = "Confirmed missed video call";
		*direction = "INCOMING";
		break;
	case 9/*CONTACTS_PLOG_TYPE_VOICE_REJECT*/:
		*call_log_type_str = "Rejected call";
		*direction = "INCOMING";
		break;
	case 10/*CONTACTS_PLOG_TYPE_VIDEO_REJECT*/:
		*call_log_type_str = "Rejected video call";
		*direction = "INCOMING";
		break;
	case 11/*CONTACTS_PLOG_TYPE_VOICE_BLOCKED*/:
		*call_log_type_str = "Blocked call";
		*direction = "INCOMING";
		break;
	case 12/*CONTACTS_PLOG_TYPE_VIDEO_BLOCKED*/:
		*call_log_type_str = "Blocked video call";
		*direction = "INCOMING";
		break;
	case 101/*CONTACTS_PLOG_TYPE_MMS_INCOMING*/:
		*call_log_type_str = "Incoming MMS";
		*direction = "INCOMING";
		break;
	case 102/*CONTACTS_PLOG_TYPE_MMS_OUTGOING*/:
		*call_log_type_str = "Outgoing MMS";
		*direction = "DIALED";
		break;
	case 103/*CONTACTS_PLOG_TYPE_SMS_INCOMING*/:
		*call_log_type_str = "Incoming SMS";
		*direction = "INCOMING";
		break;
	case 104/*CONTACTS_PLOG_TYPE_SMS_OUTGOING*/:
		*call_log_type_str = "Outgoing SMS";
		*direction = "DIALED";
		break;
	case 105/*CONTACTS_PLOG_TYPE_SMS_BLOCKED*/:
		*call_log_type_str = "Blocked SMS";
		*direction = "INCOMING";
		break;
	case 106/*CONTACTS_PLOG_TYPE_MMS_BLOCKED*/:
		*call_log_type_str = "Blocked MMS";
		*direction = "INCOMING";
		break;
	case 201/*CONTACTS_PLOG_TYPE_EMAIL_RECEIVED*/:
		*call_log_type_str = "Received email";
		*direction = "INCOMING";
		break;
	case 202/*CONTACTS_PLOG_TYPE_EMAIL_SENT*/:
		*call_log_type_str = "Sent email";
		*direction = "DIALED";
		break;
	default:
		*call_log_type_str = "";
		*direction = "";
		break;
	}
}
/*
 *{
 *	"uid":"123",
 *	"type":"TEL",
 *	"features":[
 *	],
 *	"remoteParties":[
 *		{
 *			"remoteParty":"",
 *			"personId":"3"
 *		}
 *	],
 *	"startTime":"22/03/2001",
 *	"duration":100,
 *	"direction":"DIALED"
 *}

 *	<uid>123</uid>
 *	<type>TEL</type>
 *	<remoteParties>
 *		<remoteParty></remoteParty>
 *		<personId>3</personId>
 *	</remoteParties>
 *	<startTime>22/03/2001</startTime>
 *	<duration>100</duration>
 *	<direction>DIALED</direction>
 */
static void populate_call_log_entries(xmlNodePtr entriesXMLNode) {
	contacts_list_h call_history_list = NULL;
	contacts_record_h call_log_record = NULL;

	int error_code;
	error_code = contacts_list_create(&call_history_list);
	if (error_code != CONTACTS_ERROR_NONE) {
		dlog_print(DLOG_ERROR, LOG_TAG, "contacts_list_create() failed: %d",
				error_code);
		return;
	}

	//first get call history list
	error_code = contacts_db_get_all_records(_contacts_phone_log._uri, 0, 0,
			&call_history_list);
	if (error_code != CONTACTS_ERROR_NONE) {
		dlog_print(DLOG_ERROR, LOG_TAG,
				"contacts_db_get_all_records() failed: %d", error_code);
		return;
	}
	char* startTime = (char*) malloc(100 * sizeof(char));
	int uid;
	contacts_phone_log_type_e log_type;
	char* type;
	int unixTimestamp;
	int duration;
	char* direction;
	while (contacts_list_get_current_record_p(call_history_list,
			&call_log_record) == CONTACTS_ERROR_NONE) {
		if (call_log_record != NULL) {
			contacts_record_get_int(call_log_record,
					_contacts_phone_log.log_time, &unixTimestamp);
			convertToDateFormat(unixTimestamp, startTime);

			contacts_record_get_int(call_log_record,
					_contacts_phone_log.log_type, &log_type);
			getCallLogType(log_type, &type, &direction);

			contacts_record_get_int(call_log_record,
					_contacts_phone_log.extra_data1, &duration);

			contacts_record_get_int(call_log_record, _contacts_phone_log.id,
					&uid);

			//Accomodate 32 bit int highest value
			char* uid_str = (char*) malloc(MAX_NUM_LENGTH * sizeof(char));
			snprintf(uid_str, MAX_NUM_LENGTH, "%d", uid);
			xmlNewChild(entriesXMLNode, NULL, (const xmlChar*) "uid",
					(xmlChar*) uid_str);
			free(uid_str);

			xmlNewChild(entriesXMLNode, NULL, (const xmlChar*) "type",
					(xmlChar*) type);

			xmlNewChild(entriesXMLNode, NULL, (const xmlChar*) "startTime",
					(xmlChar*) startTime);

			//Accomodate 32 bit int highest value
			char* duration_str = (char*) malloc(MAX_NUM_LENGTH * sizeof(char));
			snprintf(duration_str, MAX_NUM_LENGTH, "%d", duration);
			xmlNewChild(entriesXMLNode, NULL, (const xmlChar*) "uid",
					(xmlChar*) duration_str);
			free(duration_str);

			xmlNewChild(entriesXMLNode, NULL, (const xmlChar*) "direction",
					(xmlChar*) direction);

			xmlNodePtr remotePartiesNode = xmlNewChild(entriesXMLNode, NULL,
					(const xmlChar*) "remoteParties", NULL);
			getRemotePartyDetails(remotePartiesNode, uid);

			//TODO Look for features data
			xmlNodePtr featuresNode = xmlNewChild(entriesXMLNode, NULL,
					(const xmlChar*) "features", NULL);
			getFeatureDetails(featuresNode, uid);

		}
		error_code = contacts_list_next(call_history_list);
		if (error_code != CONTACTS_ERROR_NONE)
			break;
	}
	free(startTime);
	contacts_list_destroy(call_history_list, true);
}

/*
 *  {
 *		"remoteParty":"",
 *		"personId":"3"
 *	}
 *
 *	<remoteParty>buzz</remoteParty>
 *	<personId>3</personId>
 */
static xmlNodePtr getRemotePartyDetails(xmlNodePtr remotePartiesXMLNode,
		int callLogId) {
	contacts_record_h call_log_record = NULL;

	int personId;
	char * remoteParty = NULL;
	int error_code;

	//query for all contacts with this address_book_id
	contacts_filter_h filter = NULL;
	contacts_list_h call_history_list = NULL;
	contacts_query_h query = NULL;

	error_code = contacts_list_create(&call_history_list);
	if (error_code != CONTACTS_ERROR_NONE) {
		dlog_print(DLOG_ERROR, LOG_TAG, "contacts_list_create() failed: %d",
				error_code);
		return remotePartiesXMLNode;
	}

	contacts_filter_create(_contacts_person_phone_log._uri, &filter);
	contacts_filter_add_int(filter, _contacts_person_phone_log.log_id,
			CONTACTS_MATCH_EQUAL, callLogId);

	contacts_query_create(_contacts_person_phone_log._uri, &query);
	contacts_query_set_filter(query, filter);

	contacts_db_get_records_with_query(query, 0, 0, &call_history_list);

	do {
		contacts_list_get_current_record_p(call_history_list, &call_log_record);
		if (call_log_record != NULL) {
			contacts_record_get_str(call_log_record,
					_contacts_person_phone_log.display_name, &remoteParty);
			contacts_record_get_int(call_log_record,
					_contacts_person_phone_log.person_id, &personId);

			xmlNewChild(remotePartiesXMLNode, NULL,
					(const xmlChar*) "remoteParty", (xmlChar*) remoteParty);

			//Accomodate 32 bit int highest value
			char* personId_str = (char*) malloc(MAX_NUM_LENGTH * sizeof(char));
			snprintf(personId_str, MAX_NUM_LENGTH, "%d", personId);
			xmlNewChild(remotePartiesXMLNode, NULL, (const xmlChar*) "personId",
					(xmlChar*) personId_str);
			free(personId_str);
		}
	} while (CONTACTS_ERROR_NONE == contacts_list_next(call_history_list));

	contacts_query_destroy(query);
	contacts_filter_destroy(filter);
	contacts_list_destroy(call_history_list, true);

	return remotePartiesXMLNode;
}

static void getFeatureDetails(xmlNodePtr jsonBuilder, int callLogId) {

}

static void convertToDateFormat(int unixTimestamp, char* startTime) {

	struct tm ts;
	// Format time "ddd dd/mm/yyyy hh:mm:ss"
	ts = *localtime(&unixTimestamp);
	strftime(startTime, 100, "%a %d/%m/%Y %H:%M:%S", &ts);
}

static void** get_datasource_root_element() {
	if (callHistoryDatasourceRootNode == NULL) {
		initialize_call_history_datasource();
	}
	return callHistoryDatasourceRootNode;
}

static void initialize_call_history_datasource() {
	populate_call_history_records();

	if (!isRefreshCallbackRegistered) {
		isRefreshCallbackRegistered = true;
		//Register callback functions to be invoked when a record changes.
		contacts_db_add_changed_cb(_contacts_phone_log._uri,
				refresh_call_history_datasource, _contacts_phone_log._uri);
		contacts_db_add_changed_cb(_contacts_person_phone_log._uri,
				refresh_call_history_datasource,
				_contacts_person_phone_log._uri);
	}
}

static void refresh_call_history_datasource(const char * const view_uri,
		void* user_data) {
	xmlDocPtr oldContactsRootNode = callHistoryDatasourceRootNode[0];
	initialize_call_history_datasource();
	if ((refresh_databinding_cb != NULL)
			&& (is_callhistory_update_databinding_cb_registered)) {
		(*refresh_databinding_cb)();
	}
	xmlFreeDoc(oldContactsRootNode);
}

static void register_datasource_update_callback(void (*func_ptr)()) {
	if (!is_callhistory_update_databinding_cb_registered) {
		refresh_databinding_cb = func_ptr;
		is_callhistory_update_databinding_cb_registered = true;
	}
}

uib_datasource_interface* uib_call_history_datasource_get_instance() {
	if (!g_uib_call_history_datasource._is_init) {
		g_uib_call_history_datasource._is_init = true;
		g_uib_call_history_datasource.ds_type = call_history_API;
		g_uib_call_history_datasource.get_datasource_root_element =
				&get_datasource_root_element;
		g_uib_call_history_datasource.register_datasource_update_callback =
				&register_datasource_update_callback;
		g_uib_call_history_datasource.cleanup_datasource = &cleanup_datasource;
	}
	return &g_uib_call_history_datasource;
}
]]>
</xsl:text>

	</xsl:template>
</xsl:stylesheet>
