<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:variable name="newline">
		<xsl:text>
</xsl:text>
	</xsl:variable>
	<xsl:variable name="tab">
		<xsl:text disable-output-escaping="yes">	</xsl:text>
	</xsl:variable>

	<xsl:template match="/">
		<!-- Apply following template only once if contacts type datasource is found -->
		<xsl:variable name="contacts_datasource_count"
			select="count(//dataBinding//dataSource[@modelType='contacts'])" />
		<xsl:if test="$contacts_datasource_count>0">
			<xsl:apply-templates select="//dataBinding" />
		</xsl:if>
	</xsl:template>

	<xsl:template match="dataBinding">

		<xsl:text disable-output-escaping="yes">
<![CDATA[/*******************************************************************************
 * This file was generated by UI Builder.
 * This file will be auto-generated each and everytime you save your project.
 * Do not hand edit this file.
 ********************************************************************************/

#include "uib_datasource_handler_contacts.h"
#include "contacts_types.h"
#include "contacts_db.h"
#include "contacts_filter.h"
#include "contacts_list.h"
#include "contacts_query.h"
#include "contacts_record.h"
#include "contacts_errors.h"
#include "contacts_views.h"
#include "contacts_service.h"
#include <json-glib/json-glib.h>
#include <json-glib/json-builder.h>
#include <json-glib/json-generator.h>

#define MAX_NUM_LENGTH 12

static uib_datasource_interface g_uib_contacts_datasource;
static xmlDocPtr* contactsRootNode = NULL;
static bool is_contacts_update_databinding_cb_registered = false;
static bool isRefreshCallbackRegistered;

static void (*refresh_databinding_cb)();
static xmlDocPtr prepare_datasource_xml_tree();
static void prepare_adressbook_filtered_contacts_list(xmlNodePtr, int);
static void get_name_object_details(xmlNodePtr, contacts_record_h*);
static void get_phone_numbers_details(xmlNodePtr, contacts_record_h*);
static void get_addresses_details(xmlNodePtr, contacts_record_h*);
static void get_anniversaries_details(xmlNodePtr, contacts_record_h*);
static void get_emails_details(xmlNodePtr, contacts_record_h*);
static void get_organizations_details(xmlNodePtr, contacts_record_h*);
static void get_urls_details(xmlNodePtr, contacts_record_h*);
static void refresh_contacts_datasource(const char*, void*);

static bool populate_contact_records() {
	if (contactsRootNode == NULL) {
		contactsRootNode = (xmlDocPtr*) malloc(sizeof(xmlDocPtr));
		if (!data_contacts_common_connect())
			return false;
	}
	contactsRootNode[0] = prepare_datasource_xml_tree();
	return true;
}

static void initialize_contacts_datasource() {
	populate_contact_records();

	if (!isRefreshCallbackRegistered) {
		isRefreshCallbackRegistered = true;
		//Register callback functions to be invoked when a record changes.
		contacts_db_add_changed_cb(_contacts_address_book._uri,
				refresh_contacts_datasource, NULL);
		contacts_db_add_changed_cb(_contacts_contact._uri,
				refresh_contacts_datasource, NULL);
		contacts_db_add_changed_cb(_contacts_contact_number._uri,
				refresh_contacts_datasource, NULL);
		contacts_db_add_changed_cb(_contacts_contact_email._uri,
				refresh_contacts_datasource, NULL);
		contacts_db_add_changed_cb(_contacts_address._uri,
				refresh_contacts_datasource, NULL);
		contacts_db_add_changed_cb(_contacts_url._uri,
				refresh_contacts_datasource, NULL);
		contacts_db_add_changed_cb(_contacts_company._uri,
				refresh_contacts_datasource, NULL);
	}
}

static xmlDocPtr prepare_datasource_xml_tree() {
	contacts_list_h addressbook_list = NULL;
	contacts_record_h address_record = NULL;

	//first get address books
	int ret = contacts_db_get_all_records(_contacts_address_book._uri, 0, 0,
			&addressbook_list);

	//Begin xml document
	xmlDocPtr datasource_xmlDoc = xmlNewDoc(BAD_CAST "1.0");

	//Start AddressBooks root node
	xmlNodePtr addressbooks_root_node = xmlNewNode(NULL,
	BAD_CAST "addressbooks");
	xmlDocSetRootElement(datasource_xmlDoc, addressbooks_root_node);

	//Iterate list of addressBooks
	do {
		contacts_list_get_current_record_p(addressbook_list, &address_record);
		if (NULL == address_record)
			break;
		char *name = NULL;
		bool readOnly = false;
		int id;
		int mode;

		contacts_record_get_int(address_record, _contacts_address_book.mode,
				&mode);
		readOnly = (mode == CONTACTS_ADDRESS_BOOK_MODE_READONLY);
		contacts_record_get_int(address_record,
				_contacts_address_book.account_id, &id);
		contacts_record_get_str(address_record, _contacts_address_book.name,
				&name);

		//Set id name & mode property of addressbooks property

		//Accomodate 32 bit int highest value
		char* addressbookId_str = (char*) malloc(MAX_NUM_LENGTH * sizeof(char));
		snprintf(addressbookId_str, MAX_NUM_LENGTH, "%d", id);
		xmlNewChild(addressbooks_root_node, NULL, (const xmlChar*) "id",
				(xmlChar*) addressbookId_str);
		free(addressbookId_str);

		xmlNewChild(addressbooks_root_node, NULL, (const xmlChar*) "name",
				(xmlChar*) name);

		char* isReadOnlyStr = "false";
		if (readOnly) {
			isReadOnlyStr = "true";
		}
		xmlNewChild(addressbooks_root_node, NULL, (const xmlChar*) "readOnly",
				(xmlChar*) isReadOnlyStr);

		prepare_adressbook_filtered_contacts_list(addressbooks_root_node, id);

	} while (CONTACTS_ERROR_NONE == contacts_list_next(addressbook_list));

	ret = contacts_list_destroy(addressbook_list, true);
	if (ret != 0) {
		dlog_print(DLOG_ERROR, LOG_TAG, "Failed to delete addressbook_list %d",
				&ret);
	}
	return datasource_xmlDoc;
}

static void prepare_adressbook_filtered_contacts_list(
		xmlNodePtr parent_addressbooks_root_node, int addressBookId) {

	//query for all contacts with this address_book_id
	contacts_filter_h filter = NULL;
	contacts_list_h contacts_list = NULL;
	contacts_query_h query = NULL;

	contacts_filter_create(_contacts_contact._uri, &filter);
	contacts_filter_add_int(filter, _contacts_contact.address_book_id,
			CONTACTS_MATCH_EQUAL, addressBookId);

	contacts_query_create(_contacts_contact._uri, &query);
	contacts_query_set_filter(query, filter);

	contacts_db_get_records_with_query(query, 0, 0, &contacts_list);
	contacts_record_h contacts_record = NULL;

	int id;
	do {
		contacts_list_get_current_record_p(contacts_list, &contacts_record);
		if (contacts_record != NULL) {
			contacts_record_get_int(contacts_record, _contacts_contact.id, &id);

			//Add contacts array element to addressbooks
			xmlNodePtr contacts_node = xmlNewChild(
					parent_addressbooks_root_node, NULL,
					(const xmlChar*) "contacts", NULL);

			//Start populating contact elements

			//Accomodate 32 bit int highest value
			char* contact_id_str = (char*) malloc(
			MAX_NUM_LENGTH * sizeof(char));
			snprintf(contact_id_str, MAX_NUM_LENGTH, "%d", id);
			xmlNewChild(contacts_node, NULL, (const xmlChar*) "id",
					(xmlChar*) contact_id_str);
			free(contact_id_str);

			//Get name object details
			get_name_object_details(contacts_node, &contacts_record);

			//Get phoneNumbers details
			get_phone_numbers_details(contacts_node, &contacts_record);

			//Get addresses details
			get_addresses_details(contacts_node, &contacts_record);

			//Get anniversaries details
			get_anniversaries_details(contacts_node, &contacts_record);

			//Get emails details
			get_emails_details(contacts_node, &contacts_record);

			//Get organizations details
			get_organizations_details(contacts_node, &contacts_record);

			//Get Urls details
			get_urls_details(contacts_node, &contacts_record);

		}

	} while (CONTACTS_ERROR_NONE == contacts_list_next(contacts_list));

	int ret = contacts_list_destroy(contacts_list, true);
	if (ret != 0) {
		dlog_print(DLOG_ERROR, LOG_TAG, "Failed to delete contacts_list %d",
				&ret);
	}
	contacts_query_destroy(query);
	contacts_filter_destroy(filter);

}

static void get_name_object_details(xmlNodePtr parent_contact_node,
		contacts_record_h* contacts_record) {
	char * displayName = NULL;
	char * phoneticName = NULL;
	char * firstName, *lastname, *middleName, *phoneticFirstName,
			*phoneticLastName, *phoneticMiddleName, *prefix, *suffix;
	char * nickName = NULL;

	contacts_list_h nickname_list = NULL;

	int ret = contacts_list_create(&nickname_list);
	if (ret != 0) {
		dlog_print(DLOG_ERROR, LOG_TAG, "Failed to create nickname_list %d",
				&ret);
		return;
	}

	contacts_record_h name_record = NULL;

	contacts_record_h nickname_record = NULL;

	if (contacts_record_get_child_record_at_p((*contacts_record),
			_contacts_contact.name, 0, &name_record) != 0) {
		return;
	}

	contacts_record_clone_child_record_list((*contacts_record),
			_contacts_contact.nickname, &nickname_list);

	contacts_record_get_str(*contacts_record, _contacts_contact.display_name,
			&displayName);
	contacts_record_get_str(name_record, _contacts_name.first, &firstName);
	contacts_record_get_str(name_record, _contacts_name.last, &lastname);
	contacts_record_get_str(name_record, _contacts_name.addition, &middleName);
	contacts_record_get_str(name_record, _contacts_name.suffix, &suffix);
	contacts_record_get_str(name_record, _contacts_name.prefix, &prefix);
	contacts_record_get_str(name_record, _contacts_name.phonetic_first,
			&phoneticFirstName);
	contacts_record_get_str(name_record, _contacts_name.phonetic_middle,
			&phoneticMiddleName);
	contacts_record_get_str(name_record, _contacts_name.phonetic_last,
			&phoneticLastName);

	if (phoneticFirstName != NULL && phoneticMiddleName != NULL
			&& phoneticLastName != NULL) {
		phoneticName = (char*) malloc(
				(strlen(phoneticFirstName) + strlen(phoneticMiddleName)
						+ strlen(phoneticLastName) + 10) * sizeof(char));
		strcpy(phoneticName, (const char*) phoneticFirstName);
		strcat(phoneticName, (const char*) phoneticMiddleName);
		strcat(phoneticName, (const char*) phoneticLastName);
	}

	//Begin contact.name object
	xmlNodePtr name_node = xmlNewChild(parent_contact_node, NULL,
			(const xmlChar*) "name", NULL);

	xmlNewChild(name_node, NULL, (const xmlChar*) "displayName",
			(xmlChar*) displayName);

	xmlNewChild(name_node, NULL, (const xmlChar*) "firstName",
			(xmlChar*) firstName);

	xmlNewChild(name_node, NULL, (const xmlChar*) "lastname",
			(xmlChar*) lastname);

	xmlNewChild(name_node, NULL, (const xmlChar*) "middleName",
			(xmlChar*) middleName);

	xmlNewChild(name_node, NULL, (const xmlChar*) "phoneticFirstName",
			(xmlChar*) phoneticFirstName);

	xmlNewChild(name_node, NULL, (const xmlChar*) "phoneticLastName",
			(xmlChar*) phoneticLastName);

	xmlNewChild(name_node, NULL, (const xmlChar*) "phoneticMiddleName",
			(xmlChar*) phoneticMiddleName);

	xmlNewChild(name_node, NULL, (const xmlChar*) "phoneticName",
			(xmlChar*) phoneticName);

	xmlNewChild(name_node, NULL, (const xmlChar*) "prefix", (xmlChar*) prefix);

	xmlNewChild(name_node, NULL, (const xmlChar*) "suffix", (xmlChar*) suffix);

	do {

		if (!contacts_list_get_current_record_p(nickname_list,
				&nickname_record)) {
			contacts_record_get_str(nickname_record, _contacts_nickname.name,
					&nickName);
			xmlNewChild(name_node, NULL, (const xmlChar*) "nickNames",
					(xmlChar*) nickName);
		}
	} while (CONTACTS_ERROR_NONE == contacts_list_next(nickname_list));

	contacts_list_destroy(nickname_list, true);

}

/**
 * phoneNumbers:[
 * 					isDefault:"Boolean",
 * 					label:"",
 * 					number:"",
 * 					types:[]
 * 				]
 */
static void get_phone_numbers_details(xmlNodePtr parent_contact_node,
		contacts_record_h* contacts_record) {

	contacts_list_h phoneNumber_list = NULL;
	int ret = contacts_list_create(&phoneNumber_list);
	if (ret != 0) {
		dlog_print(DLOG_ERROR, LOG_TAG, "Failed to create phoneNumber_list %d",
				&ret);
		return;
	}

	contacts_record_h phoneNumber_record = NULL;

	int count;
	contacts_record_get_child_record_count((*contacts_record),
			_contacts_contact.number, &count);

	contacts_record_clone_child_record_list((*contacts_record),
			_contacts_contact.number, &phoneNumber_list);

	do {

		if (!contacts_list_get_current_record_p(phoneNumber_list,
				&phoneNumber_record)) {
			bool isDefault;
			char* label = NULL;
			char* number = NULL;
			int type;

			contacts_record_get_bool(phoneNumber_record,
					_contacts_contact_number.is_default, &isDefault);

			contacts_record_get_str(phoneNumber_record,
					_contacts_contact_number.label, &label);

			contacts_record_get_str(phoneNumber_record,
					_contacts_contact_number.number, &number);

			xmlNodePtr phoneNumbers_node = xmlNewChild(parent_contact_node,
			NULL, (const xmlChar*) "phoneNumbers", NULL);

			char * isDefaultStr = "false";
			if (isDefault) {
				isDefaultStr = "true";
			}
			xmlNewChild(phoneNumbers_node, NULL,
					(const xmlChar*) "phoneNumbers", (xmlChar*) isDefaultStr);

			xmlNewChild(phoneNumbers_node, NULL,
					(const xmlChar*) "phoneNumbers", (xmlChar*) label);

			xmlNewChild(phoneNumbers_node, NULL,
					(const xmlChar*) "phoneNumbers", (xmlChar*) number);

			contacts_record_get_int(phoneNumber_record,
					_contacts_contact_number.type, &type);
			for (int i = 0; i < 31; ++i) {
				if ((type & 1 << i)) {
					//Accomodate 32 bit int highest value
					char* typeStr = (char*) malloc(
					MAX_NUM_LENGTH * sizeof(char));
					snprintf(typeStr, MAX_NUM_LENGTH, "%d", 1 << i);
					xmlNewChild(phoneNumbers_node, NULL,
							(const xmlChar*) "types", (xmlChar*) typeStr);
					free(typeStr);
				}
				if (type == 0) {
					xmlNewChild(phoneNumbers_node, NULL,
							(const xmlChar*) "types", (xmlChar*) "0");
					break;
				}
			}
		}

	} while (CONTACTS_ERROR_NONE == contacts_list_next(phoneNumber_list));

	contacts_list_destroy(phoneNumber_list, true);
}

/**
 * 				addresses:[
 * 				    additionalInformation:"String",
 * 					city:"String",
 * 					country:"String",
 * 					isDefault:"Boolean",
 * 					label:"String",
 * 					postalCode:"String",
 * 					region:"String",
 * 					streetAddress:"String",
 * 					types:[
 * 					]
 * 				]
 */
//TODO: Check correct record to map to
static void get_addresses_details(xmlNodePtr parent_contacts_node,
		contacts_record_h* contacts_record) {
	int address_num;

	contacts_record_get_child_record_count(*contacts_record,
			_contacts_contact.address, &address_num);
	contacts_record_h address_record = NULL;

	for (int i = 0; i < address_num; i++) {

		char * additionalInformation = NULL, *city = NULL, *country = NULL,
				*label = NULL, *postalCode = NULL, *region = NULL,
				*streetAddress =
				NULL;
		bool isDefault = false;
		int type;

		contacts_record_get_child_record_at_p(*contacts_record,
				_contacts_contact.address, i, &address_record);
		if (address_record != NULL) {
			contacts_record_get_bool(address_record,
					_contacts_contact_number.is_default, &isDefault);

			contacts_record_get_str(address_record, _contacts_address.label,
					&label);

			contacts_record_get_str(address_record, _contacts_address.country,
					&country);

			contacts_record_get_str(address_record, _contacts_address.country,
					&country);

			contacts_record_get_str(address_record, _contacts_address.street,
					&streetAddress);

			contacts_record_get_str(address_record, _contacts_address.region,
					&region);

			contacts_record_get_str(address_record,
					_contacts_address.postal_code, &postalCode);

			contacts_record_get_str(address_record, _contacts_address.extended,
					&additionalInformation);

			//TODO: For now locality is mapped to city. Look for accurate field to map to.
			contacts_record_get_str(address_record, _contacts_address.locality,
					&city);

			contacts_record_get_int(address_record, _contacts_address.type,
					&type);

			xmlNodePtr addresses_node = xmlNewChild(parent_contacts_node, NULL,
					(const xmlChar*) "addresses", NULL);

			contacts_record_get_child_record_at_p(*contacts_record,
					_contacts_contact.address, i, &address_record);

			xmlNewChild(addresses_node, NULL, (const xmlChar*) "addresses",
					(xmlChar*) additionalInformation);

			xmlNewChild(addresses_node, NULL, (const xmlChar*) "city",
					(xmlChar*) city);

			xmlNewChild(addresses_node, NULL, (const xmlChar*) "country",
					(xmlChar*) country);

			char * isDefaultStr = "false";
			if (isDefault) {
				isDefaultStr = "true";
			}
			xmlNewChild(addresses_node, NULL, (const xmlChar *) "isDefault",
					(xmlChar*) isDefaultStr);

			xmlNewChild(addresses_node, NULL, (const xmlChar*) "label",
					(xmlChar*) label);

			xmlNewChild(addresses_node, NULL, (const xmlChar*) "postalCode",
					(xmlChar*) postalCode);

			xmlNewChild(addresses_node, NULL, (const xmlChar*) "region",
					(xmlChar*) region);

			xmlNewChild(addresses_node, NULL, (const xmlChar*) "streetAddress",
					(xmlChar*) streetAddress);

			contacts_record_get_int(address_record, _contacts_address.type,
					&type);
			//Only bits from 0 to 6 is used by contacts_address_type_e
			for (int i = 0; i < 7; ++i) {

				if ((type & 1 << i)) {
					char* typesStr = (char*) malloc(
					MAX_NUM_LENGTH * sizeof(char));
					snprintf(typesStr, MAX_NUM_LENGTH, "%d", 1 << i);
					xmlNewChild(addresses_node, NULL, (const xmlChar*) "types",
							(xmlChar*) typesStr);
					free(typesStr);
				}
				if (type == 0) {
					xmlNewChild(addresses_node, NULL, (const xmlChar*) "types",
							(xmlChar*) "0");
					break;
				}
			}
		}
	}

}

/**
 * 				anniversaries:[
 *					date:"String",
 *					label:"String"
 * 				]
 */
static void get_anniversaries_details(xmlNodePtr parent_contacts_node,
		contacts_record_h* contacts_record) {
	int anniversary_num;

	contacts_record_get_child_record_count(*contacts_record,
			_contacts_contact.event, &anniversary_num);
	contacts_record_h anniversary_record = NULL;

	for (int i = 0; i < anniversary_num; i++) {
		//TODO: Handle calendar type for date conversion as well
		char * label = NULL;
		int date;

		contacts_record_get_child_record_at_p(*contacts_record,
				_contacts_contact.event, i, &anniversary_record);
		if (anniversary_record != NULL) {
			contacts_record_get_int(anniversary_record, _contacts_event.date,
					&date);

			contacts_record_get_str(anniversary_record, _contacts_event.label,
					&label);

			xmlNodePtr anniversaries_node = xmlNewChild(parent_contacts_node,
			NULL, (const xmlChar*) "anniversaries", NULL);

			contacts_record_get_child_record_at_p(*contacts_record,
					_contacts_contact.event, i, &anniversary_record);

			char* dateStr = (char*) malloc(
			MAX_NUM_LENGTH * sizeof(char));
			snprintf(dateStr, MAX_NUM_LENGTH, "%d", date);
			xmlNewChild(anniversaries_node, NULL, (const xmlChar*) "date",
					(xmlChar*) dateStr);
			free(dateStr);

			xmlNewChild(anniversaries_node, NULL, (const xmlChar*) "label",
					(xmlChar*) label);
		}
	}
}

/**
 *				emails:[
 * 					email:"String",
 * 					isDefault:"Boolean",
 * 					label:"String",
 * 					types:[]
 * 				],
 */
static void get_emails_details(xmlNodePtr parent_contacts_node,
		contacts_record_h* contacts_record) {
	int emails_num;

	contacts_record_get_child_record_count(*contacts_record,
			_contacts_contact.email, &emails_num);
	contacts_record_h email_record = NULL;

	for (int i = 0; i < emails_num; i++) {

		char * email = NULL, *label = NULL;
		bool isDefault = false;

		int type;

		contacts_record_get_child_record_at_p(*contacts_record,
				_contacts_contact.email, i, &email_record);
		if (email_record != NULL) {
			contacts_record_get_str(email_record, _contacts_contact_email.label,
					&label);
			contacts_record_get_str(email_record, _contacts_contact_email.email,
					&email);

			xmlNodePtr email_node = xmlNewChild(parent_contacts_node, NULL,
					(const xmlChar*) "emails", NULL);

			char * isDefaultStr = "false";
			if (isDefault) {
				isDefaultStr = "true";
			}
			xmlNewChild(email_node, NULL, (const xmlChar*) "isDefault",
					(xmlChar*) isDefaultStr);

			xmlNewChild(email_node, NULL, (const xmlChar*) "email",
					(xmlChar*) email);

			xmlNewChild(email_node, NULL, (const xmlChar*) "label",
					(xmlChar*) label);

			contacts_record_get_int(email_record, _contacts_email.type, &type);
			//Only bits from 0 to 4 is used by contacts_email_type_e
			for (int i = 0; i < 4; ++i) {

				if ((type & 1 << i)) {
					char* typesStr = (char*) malloc(
					MAX_NUM_LENGTH * sizeof(char));
					snprintf(typesStr, MAX_NUM_LENGTH, "%d", 1 << i);
					xmlNewChild(email_node, NULL, (const xmlChar*) "types",
							(xmlChar*) typesStr);
					free(typesStr);
				}
				if (type == 0) {
					xmlNewChild(email_node, NULL, (const xmlChar*) "types",
							(xmlChar*) "0");
					break;
				}
			}
		}
	}
}

static void get_organizations_details(xmlNodePtr parent_contact_node,
		contacts_record_h* contacts_record) {
	int orgs_num;

	contacts_record_get_child_record_count(*contacts_record,
			_contacts_contact.company, &orgs_num);
	contacts_record_h org_record = NULL;

	for (int i = 0; i < orgs_num; i++) {

		char * description = NULL, *assistant = NULL, *label = NULL,
				*department =
				NULL, *location = NULL, *logoURI = NULL, *name = NULL,
				*phoneticName = NULL, *role = NULL, *title = NULL;

		int type;

		contacts_record_get_child_record_at_p(*contacts_record,
				_contacts_contact.company, i, &org_record);
		if (org_record != NULL) {

			contacts_record_get_str(org_record, _contacts_company.label,
					&label);

			contacts_record_get_str(org_record,
					_contacts_company.assistant_name, &assistant);

			contacts_record_get_str(org_record, _contacts_company.department,
					&department);

			contacts_record_get_str(org_record, _contacts_company.description,
					&description);

			contacts_record_get_str(org_record, _contacts_company.location,
					&location);

			contacts_record_get_str(org_record, _contacts_company.logo,
					&logoURI);

			contacts_record_get_str(org_record, _contacts_company.name, &name);

			contacts_record_get_str(org_record, _contacts_company.phonetic_name,
					&phoneticName);

			contacts_record_get_str(org_record, _contacts_company.role, &role);

			contacts_record_get_str(org_record, _contacts_company.job_title,
					&title);

			contacts_record_get_int(org_record, _contacts_company.type, &type);

			xmlNodePtr organization_node = xmlNewChild(parent_contact_node,
			NULL, (const xmlChar*) "organizations", NULL);


			contacts_record_get_child_record_at_p(*contacts_record,
					_contacts_contact.url, i, &org_record);

			xmlNewChild(organization_node, NULL, (const xmlChar*) "name",
					(xmlChar*) name);

			xmlNewChild(organization_node, NULL, (const xmlChar*) "logoURI",
					(xmlChar*) logoURI);

			xmlNewChild(organization_node, NULL, (const xmlChar*) "description",
					(xmlChar*) description);

			xmlNewChild(organization_node, NULL, (const xmlChar*) "assistant",
					(xmlChar*) assistant);

			xmlNewChild(organization_node, NULL, (const xmlChar*) "department",
					(xmlChar*) department);

			xmlNewChild(organization_node, NULL, (const xmlChar*) "location",
					(xmlChar*) location);

			xmlNewChild(organization_node, NULL,
					(const xmlChar*) "phoneticName", (xmlChar*) phoneticName);

			xmlNewChild(organization_node, NULL, (const xmlChar*) "role",
					(xmlChar*) role);

			xmlNewChild(organization_node, NULL, (const xmlChar*) "title",
					(xmlChar*) title);

			char* typeStr = (char*) malloc(
			MAX_NUM_LENGTH * sizeof(char));
			snprintf(typeStr, MAX_NUM_LENGTH, "%d", type);
			xmlNewChild(organization_node, NULL, (const xmlChar*) "type",
					(xmlChar*) typeStr);
			free(typeStr);

			xmlNewChild(organization_node, NULL, (const xmlChar*) "label",
					(xmlChar*) label);
		}
	}
}

/**
 *				urls:[
 * 					label:"",
 * 					type:"",
 * 					url:""
 * 				]
 */
static void get_urls_details(xmlNodePtr parent_contact_node,
		contacts_record_h* contacts_record) {
	int urls_num;

	contacts_record_get_child_record_count(*contacts_record,
			_contacts_contact.url, &urls_num);
	contacts_record_h url_record = NULL;

	for (int i = 0; i < urls_num; i++) {

		char * url = NULL, *label = NULL;

		int type;

		contacts_record_get_str(url_record, _contacts_url.label, &label);

		contacts_record_get_str(url_record, _contacts_url.url, &url);

		contacts_record_get_int(url_record, _contacts_url.type, &type);
		contacts_record_get_child_record_at_p(*contacts_record,
				_contacts_contact.url, i, &url_record);
		if (url_record != NULL) {

			xmlNodePtr url_node = xmlNewChild(parent_contact_node, NULL,
					(const xmlChar*) "urls",
					NULL);

			xmlNewChild(url_node, NULL, (const xmlChar*) "url", (xmlChar*) url);

			char* typeStr = (char*) malloc(
			MAX_NUM_LENGTH * sizeof(char));
			snprintf(typeStr, MAX_NUM_LENGTH, "%d", type);
			xmlNewChild(url_node, NULL, (const xmlChar*) "type",
					(xmlChar*) typeStr);
			free(typeStr);

			xmlNewChild(url_node, NULL, (const xmlChar*) "label",
					(xmlChar*) label);
		}
	}
}

static void cleanup_datasource() {
	data_contacts_common_disconnect();
	if (isRefreshCallbackRegistered) {
		isRefreshCallbackRegistered = false;
		//Un-register callback functions to be invoked when a record changes.
		contacts_db_remove_changed_cb(_contacts_address_book._uri,
				refresh_contacts_datasource, NULL);
		contacts_db_remove_changed_cb(_contacts_contact._uri,
				refresh_contacts_datasource, NULL);
		contacts_db_remove_changed_cb(_contacts_contact_number._uri,
				refresh_contacts_datasource, NULL);
		contacts_db_remove_changed_cb(_contacts_contact_email._uri,
				refresh_contacts_datasource, NULL);
		contacts_db_remove_changed_cb(_contacts_address._uri,
				refresh_contacts_datasource, NULL);
		contacts_db_remove_changed_cb(_contacts_url._uri,
				refresh_contacts_datasource, NULL);
		contacts_db_remove_changed_cb(_contacts_company._uri,
				refresh_contacts_datasource, NULL);
	}
	if (contactsRootNode != NULL && contactsRootNode[0] != NULL) {
		xmlFreeDoc(contactsRootNode[0]);
		contactsRootNode = NULL;
	}
	is_contacts_update_databinding_cb_registered = false;
}

static void register_refresh_callback(void (*func_ptr)()) {
	if (!is_contacts_update_databinding_cb_registered) {
		refresh_databinding_cb = func_ptr;
		is_contacts_update_databinding_cb_registered = true;
	}
}

static void** get_datasource_root_element() {
	if (contactsRootNode == NULL) {
		initialize_contacts_datasource();
	}
	return contactsRootNode;
}

static void refresh_contacts_datasource(const char* view_uri, void* user_data) {
	xmlDocPtr oldContactsRootNode = contactsRootNode[0];
	initialize_contacts_datasource();
	if ((refresh_databinding_cb != NULL)
			&& (is_contacts_update_databinding_cb_registered)) {
		(*refresh_databinding_cb)();
	}
	xmlFreeDoc(oldContactsRootNode);
}

uib_datasource_interface* uib_contacts_datasource_get_instance() {
	if (!g_uib_contacts_datasource._is_init) {
		g_uib_contacts_datasource._is_init = true;
		g_uib_contacts_datasource.ds_type = contacts_API;
		g_uib_contacts_datasource.get_datasource_root_element =
				&get_datasource_root_element;
		g_uib_contacts_datasource.register_datasource_update_callback =
				&register_refresh_callback;
		g_uib_contacts_datasource.cleanup_datasource = &cleanup_datasource;
	}
	return &g_uib_contacts_datasource;
}
]]>
</xsl:text>

	</xsl:template>
</xsl:stylesheet>
