<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:variable name="newline">
		<xsl:text>
</xsl:text>
	</xsl:variable>
	<xsl:variable name="tab">
		<xsl:text disable-output-escaping="yes">	</xsl:text>
	</xsl:variable>

	<xsl:template match="/">
		<xsl:variable name="datasource_count"
			select="count(//dataBinding//dataSource[@modelType != 'Empty'])" />
		<xsl:if test="$datasource_count>0">
			<xsl:apply-templates select="//dataBinding" />
		</xsl:if>
	</xsl:template>

	<xsl:template match="dataBinding">

		<xsl:text disable-output-escaping="yes">
<![CDATA[/*******************************************************************************
* This file was generated by UI Builder.
* This file will be auto-generated each and everytime you save your project.
* Do not hand edit this file.
********************************************************************************/

#include "uib_datasources.h"
]]></xsl:text>
		<!-- Include other datasources header #include "uib_ds0_datasource.h" -->
		<xsl:for-each
			select="//dataBinding/dataSource[@modelType != 'Empty']">
			<xsl:variable name="datasource_id" select="@dataSource" />
			<xsl:value-of
				select="concat('#include &quot;uib_',$datasource_id,'_datasource.h&quot;',$newline)" />
		</xsl:for-each>
		<!-- Include datasources headers #include "uib_datasource_contacts.h" -->
		<xsl:if test="//dataSource[@modelType='contacts']">
			<xsl:value-of
				select="concat('#include &quot;uib_datasource_handler_contacts.h&quot;',$newline )"></xsl:value-of>
		</xsl:if>
		<xsl:if test="//dataSource[@modelType='static']">
			<xsl:value-of
				select="concat('#include &quot;uib_datasource_handler_static.h&quot;',$newline )"></xsl:value-of>
		</xsl:if>
		<xsl:if test="//dataSource[@modelType='call_history']">
			<xsl:value-of
				select="concat('#include &quot;uib_datasource_handler_call_history.h&quot;',$newline )"></xsl:value-of>
		</xsl:if>
		<xsl:if test="//dataSource[@modelType='remote']">
			<xsl:value-of
				select="concat('#include &quot;uib_datasource_handler_remote.h&quot;',$newline )"></xsl:value-of>
		</xsl:if>
		<xsl:text>
<![CDATA[static uib_datasource_manager_st g_uib_datasource_manager;

static uib_datasource_interface* get_datasource_interface_for_datasource_type(enum UIB_DATASOURCE_TYPE);

static uib_datasource_instance* get_datasource_instance(const char* datasource_name) {
uib_datasource_instance* datasource_handle = NULL;
]]>
</xsl:text>

		<xsl:for-each
			select="//dataBinding/dataSource[@modelType != 'Empty']">
			<xsl:variable name="datasource_id" select="@dataSource" />
			<xsl:value-of
				select="concat($tab,'if(!strcmp(datasource_name, &quot;',$datasource_id,'&quot;)){',$newline,
				$tab,$tab,'datasource_handle = get_',$datasource_id,'_dataSource_handle();',$newline,$tab,'}else')" />
		</xsl:for-each>
		<xsl:value-of select="concat('{',$newline,$tab,'}',$newline )"></xsl:value-of>
		<xsl:value-of select="concat($newline,$tab,'return datasource_handle;' )"></xsl:value-of>
		<xsl:value-of select="concat($newline,'}',$newline)" />


		<!-- void cleanup_datasource_interfaces() -->
		<xsl:call-template name="cleanup_datasource_interfaces"/>

		<!-- void register_datasource_update_cb(void 
			(*ds_update_cb)()) -->
			<xsl:text><![CDATA[
static void register_datasource_update_cb(void (*callback)()) {
	uib_datasource_interface* datasource_interface = NULL;
	enum UIB_DATASOURCE_TYPE ds_type = static_source;
	for (; ds_type < end_datasource_type_marker; ++ds_type) {
		datasource_interface = get_datasource_interface_for_datasource_type(
				ds_type);
		if (datasource_interface != NULL)
			datasource_interface->register_datasource_update_callback(callback);
	}
}
]]>
</xsl:text>
		<!-- static void** fetch_root_data_element_from_datasource_interface() -->
		<xsl:call-template name="get_datasource_interface_for_datasource_type" />

		<!-- void cleanup_datasources() -->
		<xsl:call-template name="cleanup_datasources" />

		<xsl:text>
<![CDATA[
uib_datasource_manager_st* uib_datasource_manager_get_instance() {
	if (!g_uib_datasource_manager._is_init) {
		g_uib_datasource_manager._is_init = true;
		g_uib_datasource_manager.free_all_datasources = &cleanup_datasources;
		g_uib_datasource_manager.get_datasource_instance = &get_datasource_instance;
		g_uib_datasource_manager.register_datasource_update_cb =
				&register_datasource_update_cb;
		g_uib_datasource_manager.get_datasource_interface_for_datasource_type =
				&get_datasource_interface_for_datasource_type;
	}
	return &g_uib_datasource_manager;
}
]]>
</xsl:text>
	</xsl:template>

	<xsl:template name="register_datasource_update_cb">
		<xsl:value-of
			select="concat('static void register_datasource_update_cb(uib_datasource_instance* datasource, void (*func_ptr)()) {',$newline,
			$tab,'uib_datasource_interface* datasource_interface = NULL;',$newline)" />
		<xsl:if test="//dataBinding/dataSource[@modelType='static']">
			<xsl:value-of
				select="concat($tab,'if (datasource->datasource_interface->ds_type == static_source) {',$newline,
			$tab,$tab,'datasource_interface = uib_static_datasource_get_instance();',$newline,
			$tab,'} else ')" />
		</xsl:if>
		<xsl:if test="//dataBinding/dataSource[@modelType='contacts']">
			<xsl:value-of
				select="concat($tab,'if (datasource->datasource_interface->ds_type == contacts_API) {',$newline,
			$tab,$tab,'datasource_interface = uib_contacts_datasource_get_instance();',$newline,
			$tab,'} else ')" />
		</xsl:if>
		<xsl:if test="//dataBinding/dataSource[@modelType='call_history']">
			<xsl:value-of
				select="concat($tab,'if (datasource->datasource_interface->ds_type == call_history_API) {',$newline,
			$tab,$tab,'datasource_interface = uib_call_history_datasource_get_instance();',$newline,
			$tab,'} else ')" />
		</xsl:if>
		<xsl:if test="//dataBinding/dataSource[@modelType='remote']">
			<xsl:value-of
				select="concat($tab,'if (datasource->datasource_interface->ds_type == remote_API) {',$newline,
			$tab,$tab,'datasource_interface = uib_remote_datasource_get_instance();',$newline,
			$tab,'} else ')" />
		</xsl:if>
		<xsl:value-of select="concat( '{', $newline, $tab, '}',$newline)" />
		<xsl:value-of
			select="concat('if(datasource_interface != NULL)',$newline,
			$tab,$tab,'datasource_interface->register_datasource_update_callback(func_ptr);',$newline)" />
		<xsl:value-of select="concat('}',$newline)" />
	</xsl:template>

	<xsl:template name="get_datasource_interface_for_datasource_type">
		<xsl:value-of
			select="concat('static uib_datasource_interface* get_datasource_interface_for_datasource_type(enum UIB_DATASOURCE_TYPE ds_type) {',$newline,
			$tab,'uib_datasource_interface* datasource_interface = NULL;',$newline)" />
		<xsl:if test="//dataBinding/dataSource[@modelType='static']">
			<xsl:value-of
				select="concat($tab,'if (ds_type == static_source) {',$newline,
			$tab,$tab,'datasource_interface = uib_static_datasource_get_instance();',$newline,
			$tab,'} else ')" />
		</xsl:if>
		<xsl:if test="//dataBinding/dataSource[@modelType='contacts']">
			<xsl:value-of
				select="concat($tab,'if (ds_type == contacts_API) {',$newline,
			$tab,$tab,'datasource_interface = uib_contacts_datasource_get_instance();',$newline,
			$tab,'} else ')" />
		</xsl:if>
		<xsl:if test="//dataBinding/dataSource[@modelType='call_history']">
			<xsl:value-of
				select="concat($tab,'if (ds_type == call_history_API) {',$newline,
			$tab,$tab,'datasource_interface = uib_call_history_datasource_get_instance();',$newline,
			$tab,'} else ')" />
		</xsl:if>
		<xsl:if test="//dataBinding/dataSource[@modelType='remote']">
			<xsl:value-of
				select="concat($tab,'if (ds_type == remote_API) {',$newline,
			$tab,$tab,'datasource_interface = uib_remote_datasource_get_instance();',$newline,
			$tab,'} else ')" />
		</xsl:if>
		<xsl:value-of select="concat( '{', $newline, $tab, '}',$newline)" />
		<xsl:value-of
			select="concat($tab,'return datasource_interface;',$newline)" />
		<xsl:value-of select="concat('}',$newline)" />
	</xsl:template>

	<xsl:template name="cleanup_datasources">
		<xsl:value-of
			select="concat($newline,'static void cleanup_datasources() {',$newline)" />
		<xsl:for-each
			select="//dataBinding/dataSource[@modelType != 'Empty']">
			<xsl:variable name="datasource_id" select="@dataSource" />
			<xsl:value-of
				select="concat($tab,'cleanup_',$datasource_id,'_datasource();',$newline)" />
		</xsl:for-each>
		<xsl:value-of
			select="concat($tab,'cleanup_datasource_interfaces();',$newline)" />
		<xsl:value-of select="concat('}',$newline)" />
	</xsl:template>
	
	<xsl:template name="cleanup_datasource_interfaces">
	<xsl:value-of
			select="concat($newline,'static void cleanup_datasource_interfaces(){',$newline)" />
		<xsl:if test="//dataBinding/dataSource[@modelType='contacts']">
			<xsl:value-of
				select="concat($tab,'uib_contacts_datasource_get_instance()->cleanup_datasource();',$newline )"></xsl:value-of>
		</xsl:if>
		<xsl:if test="//dataBinding/dataSource[@modelType='static']">
			<xsl:value-of select="concat($tab,'uib_static_datasource_get_instance()->cleanup_datasource();',$newline )"></xsl:value-of>
		</xsl:if>
		<xsl:if test="//dataBinding/dataSource[@modelType='call_history']">
			<xsl:value-of select="concat($tab,'uib_call_history_datasource_get_instance()->cleanup_datasource();',$newline )"></xsl:value-of>
		</xsl:if>
		<xsl:if test="//dataBinding/dataSource[@modelType='remote']">
			<xsl:value-of select="concat($tab,'uib_remote_datasource_get_instance()->cleanup_datasource();',$newline )"></xsl:value-of>
		</xsl:if>
		<xsl:value-of select="concat($newline,'}',$newline)" />
	</xsl:template>
</xsl:stylesheet>
