<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:variable name="newline">
		<xsl:text>
</xsl:text>
	</xsl:variable>
	<xsl:variable name="tab">
		<xsl:text disable-output-escaping="yes">	</xsl:text>
	</xsl:variable>

	<xsl:template match="/">
		<!-- Apply following template only once if static type datasource is found -->
		<xsl:variable name="static_datasource_count"
			select="count(//dataBinding//dataSource[@modelType='static'])" />
		<xsl:if test="$static_datasource_count>0">
			<xsl:apply-templates select="//dataBinding" />
		</xsl:if>
	</xsl:template>

	<xsl:template match="dataBinding">

		<xsl:text disable-output-escaping="yes">
<![CDATA[/*******************************************************************************
* This file was generated by UI Builder.
* This file will be auto-generated each and everytime you save your project.
* Do not hand edit this file.
********************************************************************************/

#ifndef MANAGED_INC_DATABINDING_UIB_DATASOURCE_STATIC_H_
#define MANAGED_INC_DATABINDING_UIB_DATASOURCE_STATIC_H_

#include "uib_datasources.h"

uib_datasource_interface* uib_static_datasource_get_instance();

#endif
]]>
</xsl:text>

	</xsl:template>
</xsl:stylesheet>
