/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.efluibuilder.projectmigrator.ui.wizards.pages;

import java.util.ArrayList;
import org.apache.commons.lang3.StringEscapeUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.ui.color.TizenColors;
import org.tizen.common.ui.font.TizenFonts;
import org.tizen.common.util.DialogUtil;
import org.tizen.efluibuilder.projectmigrator.codewriter.ASTManager;
import org.tizen.efluibuilder.projectmigrator.codewriter.CodeWriterConstants;
import org.tizen.efluibuilder.projectmigrator.codewriter.CodeWriterException;
import org.tizen.efluibuilder.projectmigrator.codewriter.visitor.FuncCallParamGetVisitor;
import org.tizen.efluibuilder.projectmigrator.ui.message.Messages;
import org.tizen.efluibuilder.projectmigrator.ui.wizards.ProjectMigratorWizard;
import org.tizen.efluibuilder.projectmigrator.ui.wizards.pages.BaseWizardPage;
import org.tizen.efluibuilder.projectmigrator.util.FileUtil;
import org.tizen.efluibuilder.projectmigrator.util.StringUtil;
import org.tizen.efluibuilder.projectmigrator.util.UIUtil;
import org.tizen.efluibuilder.ui.resources.ColorResources;
import org.tizen.efluibuilder.ui.resources.ImageResources;
import org.tizen.efluibuilder.utility.PlatformUtil;

public class UserViewPage
extends BaseWizardPage {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private List list;
    private Text inputText;
    private Button btnAdd;
    private Label labelErrorMessage;
    private Label labelDelete;
    private Label labelStartUp;
    private ArrayList<String> currentUserViews = new ArrayList();
    private ArrayList<String> prevUserViews = new ArrayList();
    private ArrayList<String> deletedUserViews = new ArrayList();
    private static final int LIST_HEIGHT_SIZE = 207;
    private static final int INPUT_TEXT_MAX_LEN = 31;
    private static String UNICODENUM_STARTUP = "\u27aa";
    private static final String UNICODECH_STARTUPVIEW = " " + StringEscapeUtils.unescapeJava((String)UNICODENUM_STARTUP);
    private static String UNICODENUM_EXISTING_USERVIEW = "\u270e";
    private static final String UNICODECH_EXISTING_USERVIEW = String.valueOf(StringEscapeUtils.unescapeJava((String)UNICODENUM_EXISTING_USERVIEW)) + " ";
    private int curStartupViewIdx = -1;
    private boolean isWizardUserViewMode;
    private FocusListener listFocusListener = new FocusListener(){

        public void focusLost(FocusEvent focusEvent) {
        }

        public void focusGained(FocusEvent focusEvent) {
            if (UserViewPage.this.list.getSelectionIndex() > -1) {
                UserViewPage.this.setEnabledListControlButtons(true);
            } else {
                UserViewPage.this.setEnabledListControlButtons(false);
            }
        }
    };
    private SelectionListener listSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (UserViewPage.this.list.getSelectionIndex() > -1) {
                String[] stringArray = UserViewPage.this.list.getSelection();
                UserViewPage.this.labelDelete.setEnabled(true);
                if (stringArray.length == 1) {
                    UserViewPage.this.labelStartUp.setEnabled(true);
                } else {
                    UserViewPage.this.labelStartUp.setEnabled(false);
                }
            }
        }
    };
    private SelectionListener btnAddListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            String string = UserViewPage.this.inputText.getText().trim();
            UserViewPage.this.addUserViewListItem(string);
            super.widgetSelected(selectionEvent);
            UserViewPage.this.setPageComplete(true);
        }
    };
    private ModifyListener inputTextModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent modifyEvent) {
            String string = UserViewPage.this.inputText.getText().trim();
            if (UserViewPage.this.validateInputText(string)) {
                UserViewPage.this.btnAdd.setEnabled(true);
            } else {
                UserViewPage.this.btnAdd.setEnabled(false);
            }
            boolean bl = true;
            if (UserViewPage.this.isWizardUserViewMode) {
                bl = !UserViewPage.this.currentUserViews.equals(UserViewPage.this.prevUserViews) || UserViewPage.this.deletedUserViews.size() > 0;
            }
            UserViewPage.this.setPageComplete(!UserViewPage.this.btnAdd.isEnabled() && bl);
        }
    };
    private KeyAdapter inputTextKeyListener = new KeyAdapter(){

        public void keyReleased(KeyEvent keyEvent) {
            switch (keyEvent.keyCode) {
                case 13: {
                    String string = UserViewPage.this.inputText.getText().trim();
                    if (!UserViewPage.this.validateInputText(string)) break;
                    UserViewPage.this.btnAdd.setFocus();
                    UserViewPage.this.addUserViewListItem(string);
                }
            }
        }
    };
    private MouseAdapter deleteMouseListener = new MouseAdapter(){

        public void mouseDown(MouseEvent mouseEvent) {
            Image image = ImageResources.getImage((String)"res/icons/uibconverter/wizard_page_user_view/userviews_delete_sel.png");
            UserViewPage.this.labelDelete.setImage(image);
        }

        public void mouseUp(MouseEvent mouseEvent) {
            Image image = ImageResources.getImage((String)"res/icons/uibconverter/wizard_page_user_view/userviews_delete_nor.png");
            UserViewPage.this.labelDelete.setImage(image);
            UserViewPage.this.deleteSelected();
        }
    };
    private MouseTrackAdapter deleteMouseTrackListener = new MouseTrackAdapter(){

        public void mouseEnter(MouseEvent mouseEvent) {
            Image image = ImageResources.getImage((String)"res/icons/uibconverter/wizard_page_user_view/userviews_delete_over.png");
            UserViewPage.this.labelDelete.setImage(image);
        }

        public void mouseExit(MouseEvent mouseEvent) {
            Image image = ImageResources.getImage((String)"res/icons/uibconverter/wizard_page_user_view/userviews_delete_nor.png");
            UserViewPage.this.labelDelete.setImage(image);
        }
    };
    private MouseAdapter startUpMouseListener = new MouseAdapter(){

        public void mouseDown(MouseEvent mouseEvent) {
            Image image = ImageResources.getImage((String)"res/icons/uibconverter/wizard_page_user_view/userviews_setasstartup_sel.png");
            UserViewPage.this.labelStartUp.setImage(image);
        }

        public void mouseUp(MouseEvent mouseEvent) {
            Image image = ImageResources.getImage((String)"res/icons/uibconverter/wizard_page_user_view/userviews_setasstartup_nor.png");
            UserViewPage.this.labelStartUp.setImage(image);
            UserViewPage.this.startUpSelected();
        }
    };
    private MouseTrackAdapter startUpMouseTrackListener = new MouseTrackAdapter(){

        public void mouseEnter(MouseEvent mouseEvent) {
            Image image = ImageResources.getImage((String)"res/icons/uibconverter/wizard_page_user_view/userviews_setasstartup_over.png");
            UserViewPage.this.labelStartUp.setImage(image);
        }

        public void mouseExit(MouseEvent mouseEvent) {
            Image image = ImageResources.getImage((String)"res/icons/uibconverter/wizard_page_user_view/userviews_setasstartup_nor.png");
            UserViewPage.this.labelStartUp.setImage(image);
        }
    };

    public UserViewPage(String string) {
        super(string);
        this.setTitle(Messages.PAGE_NAVI_USER_VIEW);
        if (PlatformUtil.getOS().equals("linux")) {
            this.setDescription(Messages.PAGE_USERVIEW_DESC_SINGLE_LINE);
        } else {
            this.setDescription(Messages.PAGE_USERVIEW_DESC_MULTI_LINE);
        }
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        this.isWizardUserViewMode = ((ProjectMigratorWizard)this.getWizard()).getWizardMode().equals("MANAGEMENT_USER_VIEW");
        this.createBodyComposite(composite2);
        this.setControl((Control)composite2);
        this.setPageComplete(!this.isWizardUserViewMode);
        if (this.isWizardUserViewMode) {
            this.preloadUserViews();
        }
    }

    private void preloadUserViews() {
        try {
            IFile iFile = FileUtil.getFile(((ProjectMigratorWizard)this.getWizard()).getProject(), CodeWriterConstants.SRC_PATH, "app_main.c");
            FuncCallParamGetVisitor funcCallParamGetVisitor = new FuncCallParamGetVisitor(null, "uib_views_get_instance()->add_user_views", 0);
            ASTManager aSTManager = new ASTManager();
            aSTManager.visit(iFile, 6, funcCallParamGetVisitor);
            this.currentUserViews = (ArrayList)funcCallParamGetVisitor.getResults();
            if (this.currentUserViews.size() > 0) {
                this.prevUserViews = (ArrayList)this.currentUserViews.clone();
                funcCallParamGetVisitor = new FuncCallParamGetVisitor(null, "uib_views_get_instance()->set_startup_view_name", 0);
                aSTManager.visit(iFile, 6, funcCallParamGetVisitor);
                String string = "";
                ArrayList arrayList = (ArrayList)funcCallParamGetVisitor.getResults();
                if (arrayList.size() > 0 && !StringUtil.isNullorEmpty(string = (String)arrayList.get(0))) {
                    this.curStartupViewIdx = this.currentUserViews.indexOf(string);
                }
                int n = 0;
                for (String string2 : this.currentUserViews) {
                    string2 = String.valueOf(UNICODECH_EXISTING_USERVIEW) + string2;
                    if (n == this.curStartupViewIdx) {
                        string2 = String.valueOf(string2) + UNICODECH_STARTUPVIEW;
                    }
                    this.list.add(string2);
                    ++n;
                }
                this.list.setSelection(0);
            }
        }
        catch (CodeWriterException codeWriterException) {
            this.logger.error(codeWriterException.getMessage());
        }
    }

    private void setEnabledListControlButtons(boolean bl) {
        if (this.labelDelete != null) {
            this.labelDelete.setEnabled(bl);
        }
        if (this.labelStartUp != null) {
            this.labelStartUp.setEnabled(bl);
        }
    }

    private void addUserViewListItem(String string) {
        if (string.length() > 0) {
            this.currentUserViews.add(string);
            this.list.add(string);
            this.inputText.setText("");
            this.btnAdd.setEnabled(false);
            this.inputText.setFocus();
            this.setPageComplete(true);
        }
    }

    private void deleteSelected() {
        int n = this.list.getSelectionIndex();
        if (n > -1) {
            String string;
            String[] stringArray = this.list.getSelection();
            boolean bl = true;
            String[] stringArray2 = stringArray;
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                string = stringArray2[n3];
                if (string.startsWith(UNICODECH_EXISTING_USERVIEW)) {
                    bl = DialogUtil.openQuestionDialog((String)Messages.PAGE_NAVI_USER_VIEW, (String)Messages.PAGE_USERVIEW_MSG_DELETE_CONFIRM) == 64;
                    break;
                }
                ++n3;
            }
            if (bl) {
                if (this.list.isSelected(this.curStartupViewIdx)) {
                    this.curStartupViewIdx = -1;
                }
                this.setPageComplete(true);
                stringArray2 = stringArray;
                n2 = stringArray.length;
                n3 = 0;
                while (n3 < n2) {
                    string = stringArray2[n3];
                    this.list.remove(string);
                    string = string.replace(UNICODECH_EXISTING_USERVIEW, "").trim();
                    string = string.replace(UNICODECH_STARTUPVIEW, "").trim();
                    this.currentUserViews.remove(string);
                    if (this.isWizardUserViewMode && this.prevUserViews.remove(string)) {
                        this.deletedUserViews.add(string);
                    }
                    ++n3;
                }
                if (this.list.getItemCount() < 1) {
                    this.setEnabledListControlButtons(false);
                }
                this.refreshStartupViewIdx();
            }
            if (this.isWizardUserViewMode && this.prevUserViews.isEmpty() && this.currentUserViews.isEmpty()) {
                this.setPageComplete(false);
            }
        }
    }

    private void startUpSelected() {
        int n = this.list.getSelectionIndex();
        if (n > -1) {
            this.setPageComplete(true);
            if (this.isWizardUserViewMode) {
                this.setPageComplete(true);
            }
            String string = this.list.getItem(n);
            if (n == this.curStartupViewIdx) {
                String string2 = StringUtil.removeEndsWith(string, UNICODECH_STARTUPVIEW);
                this.list.setItem(n, string2 != null ? string2.trim() : "");
                this.curStartupViewIdx = -1;
            } else {
                if (this.curStartupViewIdx > -1) {
                    String string3 = StringUtil.removeEndsWith(this.list.getItem(this.curStartupViewIdx), UNICODECH_STARTUPVIEW);
                    this.list.setItem(this.curStartupViewIdx, string3 != null ? string3.trim() : "");
                }
                this.list.setItem(n, String.valueOf(string) + UNICODECH_STARTUPVIEW);
                this.curStartupViewIdx = n;
            }
            this.list.setSelection(n);
        }
    }

    private void setInputStatusMessage(String string) {
        if (StringUtil.isNullorEmpty(string)) {
            this.labelErrorMessage.setVisible(false);
            this.labelErrorMessage.setText("");
        } else {
            this.labelErrorMessage.setVisible(true);
            this.labelErrorMessage.setText(string);
        }
    }

    private boolean validateInputText(String string) {
        int n = string.length();
        String string2 = null;
        if (n < 1) {
            string2 = null;
        } else if (n >= 31) {
            string2 = Messages.PAGE_USERVIEW_MSG_NAME_LENGTH;
        } else if (this.currentUserViews.contains(string)) {
            string2 = Messages.PAGE_USERVIEW_MSG_SAME_NAME;
        } else if (!UIUtil.validateRegExp(string)) {
            string2 = Messages.PAGE_USERVIEW_MSG_NAME_REGX;
        } else {
            this.setInputStatusMessage(string2);
            return true;
        }
        this.setInputStatusMessage(string2);
        return false;
    }

    private void createBodyComposite(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new FormLayout());
        composite2.setLayoutData((Object)new GridData(768));
        int n = this.createStartupDescComposite(composite2, 0);
        n = this.createInputTextComposite(composite2, n);
        this.createUserViewListComposite(composite2, n);
    }

    private int createUserViewListComposite(Composite composite, int n) {
        Composite composite2 = new Composite(composite, 0);
        FormData formData = UIUtil.createFormData(new FormAttachment(0, 63), new FormAttachment(100, -63), new FormAttachment(0, n += 25));
        composite2.setLayoutData((Object)formData);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 9;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = UIUtil.createGridData(512, 1, 16384, -1);
        Label label = new Label(composite2, 0);
        label.setLayoutData((Object)gridData);
        label.setBackground(TizenColors.getTizenLightGrey());
        label.setText(Messages.PAGE_USERVIEW_MSG_USER_VIEWS);
        label.setFont(TizenFonts.getBoldFont());
        Composite composite3 = new Composite(composite2, 0);
        GridData gridData2 = UIUtil.createGridData(512, 1, 131072, -1);
        composite3.setLayoutData((Object)gridData2);
        GridLayout gridLayout2 = new GridLayout(2, false);
        gridLayout2.marginWidth = 0;
        gridLayout2.marginHeight = 0;
        gridLayout2.verticalSpacing = 0;
        gridLayout2.horizontalSpacing = 15;
        composite3.setLayout((Layout)gridLayout2);
        this.labelDelete = new Label(composite3, 0);
        GridData gridData3 = UIUtil.createGridData(768, 1, 131072, -1);
        this.labelDelete.setLayoutData((Object)gridData3);
        Image image = ImageResources.getImage((String)"res/icons/uibconverter/wizard_page_user_view/userviews_delete_nor.png");
        this.labelDelete.setImage(image);
        this.labelDelete.addMouseListener((MouseListener)this.deleteMouseListener);
        this.labelDelete.addMouseTrackListener((MouseTrackListener)this.deleteMouseTrackListener);
        this.labelDelete.setToolTipText(Messages.PAGE_USERVIEW_MSG_BTN_DEL);
        this.labelStartUp = new Label(composite3, 0);
        gridData3 = UIUtil.createGridData(768, 1, 131072, -1);
        this.labelStartUp.setLayoutData((Object)gridData3);
        image = ImageResources.getImage((String)"res/icons/uibconverter/wizard_page_user_view/userviews_setasstartup_nor.png");
        this.labelStartUp.setImage(image);
        this.labelStartUp.addMouseListener((MouseListener)this.startUpMouseListener);
        this.labelStartUp.addMouseTrackListener((MouseTrackListener)this.startUpMouseTrackListener);
        this.labelStartUp.setToolTipText(Messages.PAGE_USERVIEW_MSG_BTN_STARTUP);
        FormData formData2 = UIUtil.createFormData(new FormAttachment(0, 63), new FormAttachment(100, -63), new FormAttachment(0, n += 15));
        Composite composite4 = new Composite(composite, 0);
        GridLayout gridLayout3 = new GridLayout(1, false);
        gridLayout3.marginHeight = 15;
        gridLayout3.marginWidth = 0;
        gridLayout3.verticalSpacing = 0;
        gridData3 = new GridData(768);
        composite4.setLayout((Layout)gridLayout3);
        composite4.setLayoutData((Object)formData2);
        this.list = new List(composite4, 2562);
        gridData3 = new GridData(768);
        gridData3.heightHint = 207;
        this.list.setLayoutData((Object)gridData3);
        this.list.addSelectionListener(this.listSelectionListener);
        this.list.addFocusListener(this.listFocusListener);
        return n;
    }

    private int createStartupDescComposite(Composite composite, int n) {
        FormData formData = UIUtil.createFormData(new FormAttachment(0, 63), new FormAttachment(100, -63), new FormAttachment(0, n += 40));
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)formData);
        label.setFont(JFaceResources.getDialogFont());
        label.setText(Messages.PAGE_USERVIEW_MSG_STARTUP_DESC);
        return n += 13;
    }

    private int createInputTextComposite(Composite composite, int n) {
        Label label = new Label(composite, 0);
        FormData formData = UIUtil.createFormData(new FormAttachment(0, 63), new FormAttachment(100, -63), new FormAttachment(0, n += 25));
        label.setLayoutData((Object)formData);
        label.setBackground(TizenColors.getTizenLightGrey());
        label.setText(Messages.PAGE_USERVIEW_MSG_ADD_USER_VIEW);
        label.setFont(TizenFonts.getBoldFont());
        n += 13;
        Composite composite2 = new Composite(composite, 0);
        FormData formData2 = UIUtil.createFormData(new FormAttachment(0, 63), new FormAttachment(100, -63), new FormAttachment(0, n += 15));
        composite2.setLayoutData((Object)formData2);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 9;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 9;
        composite2.setLayout((Layout)gridLayout);
        this.inputText = new Text(composite2, 2048);
        this.inputText.setTextLimit(31);
        GridData gridData = new GridData(768);
        this.inputText.setLayoutData((Object)gridData);
        this.inputText.setMessage(Messages.PAGE_USERVIEW_MSG_INPUT);
        this.inputText.addModifyListener(this.inputTextModifyListener);
        this.inputText.addKeyListener((KeyListener)this.inputTextKeyListener);
        gridData = new GridData();
        gridData.widthHint = 100;
        this.btnAdd = UIUtil.createButtonWithGridLayout(composite2, Messages.PAGE_USERVIEW_MSG_BTN_ADD, gridData, 8, true, false, false);
        this.btnAdd.addSelectionListener(this.btnAddListener);
        n += 37;
        this.labelErrorMessage = new Label(composite, 0);
        FormData formData3 = UIUtil.createFormData(new FormAttachment(0, 73), new FormAttachment(100, -63), new FormAttachment(0, n += 9));
        this.labelErrorMessage.setLayoutData((Object)formData3);
        this.labelErrorMessage.setBackground(TizenColors.getTizenLightGrey());
        this.labelErrorMessage.setForeground(ColorResources.PROJECT_MIGRATER_USERVIEW_ERROR_COLOR);
        this.labelErrorMessage.setVisible(false);
        return n += 13;
    }

    public ArrayList<String> getUserViews() {
        return this.currentUserViews;
    }

    public ArrayList<String> getDeletedUserViews() {
        return this.deletedUserViews;
    }

    private void refreshStartupViewIdx() {
        int n = this.list.getItemCount();
        this.curStartupViewIdx = -1;
        int n2 = 0;
        while (n2 < n) {
            if (this.list.getItem(n2).endsWith(UNICODENUM_STARTUP)) {
                this.curStartupViewIdx = n2;
            }
            ++n2;
        }
    }

    public String getStartupViewName() {
        return this.curStartupViewIdx < 0 ? null : this.currentUserViews.get(this.curStartupViewIdx);
    }
}

