/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.efluibuilder.model.descriptors.io.file;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.Path;
import org.tizen.efluibuilder.model.descriptors.io.DescriptorFileData;
import org.tizen.uibuilder.tizenfile.TizenFileDataEntry;
import org.tizen.uibuilder.tizenfile.TizenFileDataHelper;
import org.tizen.uibuilder.tizenfile.TizenFileFormatter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DescriptorReader_ver_2 {
    private static final String ELEM_RENDERER = "renderer";
    private static final String ELEM_FRAMEWORK = "framework";
    private static final String ELEM_LIBRARY = "library";
    private static final String ELEM_EDITOR = "editor";
    private static final String ELEM_DOC = "doc";
    private static final String ELEM_PAGE = "page";
    private static final String ELEM_WIDGET = "widget";
    private static final String ELEM_CONTENT = "content";
    private static final String ELEM_NOCONTENT = "nocontent";
    private static final String ELEM_PARENT = "parent";
    private static final String ELEM_NOPARENT = "noparent";
    private static final String ELEM_RELATIONS = "relations";
    private static final String ELEM_PROPERTY = "property";
    private static final String ELEM_CHILDUICOMPONENTPROPERTY = "childUIComponentProperty";
    private static final String ELEM_CONDITION = "condition";
    private static final String ELEM_EVENT = "event";
    private static final String ELEM_XSL_FOR_OUTPUT = "xsl-for-output";
    private static final String ELEM_TYPES = "types";
    private static final String ELEM_TYPE = "type";
    private static final String ELEM_CONSTANT = "constant";
    private static final String ELEM_UNIT = "unit";
    private static final String ELEM_EVENTTYPES = "eventTypes";
    private static final String ELEM_EVENTTYPE = "eventType";
    private static final String ELEM_DEFAULTCODE = "defaultCode";
    private static final String ELEM_PARAM = "param";
    private static final String ELEM_UICOMPONENT_CATEGORIES = "UIComponentCategories";
    private static final String ELEM_UICOMPONENT_CATEGORY = "UIComponentCategory";
    private static final String ELEM_DEFAULT_STYLE_EDJS = "defaultStyleEDJs";
    private static final String ELEM_STYLE_EDJ = "styleEDJ";
    private static final String ELEM_STATE = "state";
    private static final String ELEM_VALUE = "value";
    private static final String ELEM_TEXT = "text";
    private static final String ELEM_COLOR = "color";
    private static final String ATTR_ID = "id";
    private static final String ATTR_DISPLAYNAME = "displayName";
    private static final String ATTR_SMALLICON = "smallIcon";
    private static final String ATTR_ICON_16 = "icon.16";
    private static final String ATTR_ICON = "icon";
    private static final String ATTR_CATEGORY = "category";
    private static final String ATTR_DESCRIPTION = "description";
    private static final String ATTR_LAYOUTTYPE = "layoutType";
    private static final String ATTR_LAYOUT_CAPACITY = "layoutCapacity";
    private static final String ATTR_PALETTE_VISIBLE = "paletteVisible";
    private static final String ATTR_HELPCATEGORY = "helpCategory";
    private static final String ATTR_HELPCONTENS = "helpContents";
    private static final String ATTR_FEEDBACKWIDTH = "feedbackWidth";
    private static final String ATTR_FEEDBACKHEIGHT = "feedbackHeight";
    private static final String ATTR_MINWIDTH = "minWidth";
    private static final String ATTR_MINHEIGHT = "minHeight";
    private static final String ATTR_BORDER_VISIBLE = "borderVisible";
    private static final String ATTR_FEEDBACKCONDITION = "feedbackCondition";
    private static final String ATTR_GUIDE_TEXT = "guideText";
    private static final String ATTR_SET_STYLE = "setStyle";
    private static final String ATTR_UI_SELECTOR = "uiSelector";
    private static final String ATTR_XPATH = "xpath";
    private static final String ATTR_CHILDXPATH = "childXpath";
    private static final String ATTR_SELFCHILDXPATH = "selfChildXpath";
    private static final String ATTR_CONTAINER_ID = "containerID";
    private static final String ATTR_ATTRXPATH = "attrXpath";
    private static final String ATTR_INLINE = "inline";
    private static final String ATTR_IDS = "ids";
    private static final String ATTR_EXCLUDE_IDS = "exclude-ids";
    private static final String ATTR_PARENT_IDS = "parent-ids";
    private static final String ATTR_EXCLUSIVE_GROUP = "exclusiveGroup";
    private static final String ATTR_MIN = "min";
    private static final String ATTR_MAX = "max";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_DEFAULT = "default";
    private static final String ATTR_INITVALUE = "initValue";
    private static final String ATTR_SELECTOR = "selector";
    private static final String ATTR_NOT_SUPPORTED = "notsupported";
    private static final String ATTR_VALUE = "value";
    private static final String ATTR_TARGET = "target";
    private static final String ATTR_TARGETVALUE = "targetValue";
    private static final String ATTR_TOOLTIP = "tooltip";
    private static final String ATTR_ERROR = "error";
    private static final String ATTR_EVENTTYPE = "eventType";
    private static final String ATTR_EVENTINFO = "eventInfo";
    private static final String ATTR_SRC = "src";
    private static final String ATTR_UNUSED_EDITORS = "unusedEditors";
    private static final String ATTR_REQUIRED = "required";
    private static final String ATTR_GROUP = "group";
    private static final String ATTR_RESIZEMODE = "resize_mode";
    private static final String ATTR_DISPLAYNAMES = "display_name";
    private static final String ATTR_DEFAULTVALUE = "default_value";
    private static final String ATTR_PARTNAME = "part_name";
    private static final String ATTR_CLASSNAME = "class_name";
    private static final String ATTR_SIGNAL = "signal";
    private static final String ATTR_SOURCE = "source";
    private static final String ATTR_CUSTOMCOMPONENTCATEGORY = "Custom UI components";
    private static final String ATTR_MINWIDTHS = "min_width";
    private static final String ATTR_MINHEIGHTS = "min_height";

    public static DescriptorFileData parse(String string, URL uRL) throws ParserConfigurationException, SAXException, IOException {
        DescriptorFileData descriptorFileData = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = null;
        Document document = null;
        documentBuilder = documentBuilderFactory.newDocumentBuilder();
        if (documentBuilder != null) {
            documentBuilder.setEntityResolver((new EntityResolver(){
                private String basePath = null;

                private EntityResolver init(String string) {
                    this.basePath = string;
                    return this;
                }

                @Override
                public InputSource resolveEntity(String string, String string2) {
                    Path path = new Path(this.basePath);
                    Path path2 = new Path(string2);
                    String[] stringArray = path2.segments();
                    if (DescriptorReader_ver_2.ELEM_WIDGET.equals(stringArray[stringArray.length - 2])) {
                        path = path.append(stringArray[stringArray.length - 2]);
                    }
                    path = path.append(stringArray[stringArray.length - 1]);
                    return new InputSource(DescriptorReader_ver_2.getDescriptorStream(path.toString()));
                }
            }).init(string));
            InputStream inputStream = uRL.openStream();
            document = documentBuilder.parse(inputStream);
            inputStream.close();
            if (document == null || document.getDocumentElement() == null) {
                return null;
            }
            Element element = document.getDocumentElement();
            TizenFileFormatter tizenFileFormatter = new TizenFileFormatter(element);
            if (!tizenFileFormatter.isValidate()) {
                return null;
            }
            if (!tizenFileFormatter.getType().equals("tizen-descriptor")) {
                return null;
            }
            if (!tizenFileFormatter.getVersion().equals("2")) {
                return null;
            }
            descriptorFileData = new DescriptorFileData();
            NodeList nodeList = element.getElementsByTagName("descriptors");
            int n = 0;
            while (n < nodeList.getLength()) {
                DescriptorReader_ver_2.parseRoot(descriptorFileData, (Element)nodeList.item(n), documentBuilder);
                ++n;
            }
        }
        return descriptorFileData;
    }

    public static DescriptorFileData customComponentParse(URL uRL) throws ParserConfigurationException, SAXException, IOException {
        DescriptorFileData descriptorFileData = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = null;
        Document document = null;
        documentBuilder = documentBuilderFactory.newDocumentBuilder();
        InputStream inputStream = uRL.openStream();
        document = documentBuilder.parse(inputStream);
        inputStream.close();
        if (documentBuilder == null || document == null || document.getDocumentElement() == null) {
            return null;
        }
        Element element = document.getDocumentElement();
        descriptorFileData = new DescriptorFileData();
        DescriptorReader_ver_2.parseCustomComponentRoot(descriptorFileData, element, documentBuilder);
        return descriptorFileData;
    }

    private static InputStream getDescriptorStream(String string) {
        return DescriptorReader_ver_2.class.getClassLoader().getResourceAsStream(string);
    }

    private static void parseRoot(DescriptorFileData descriptorFileData, Element element, DocumentBuilder documentBuilder) {
        if (element == null) {
            return;
        }
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node instanceof Element) {
                if (node.getNodeName().equals(ELEM_RENDERER)) {
                    DescriptorReader_ver_2.parseRenderer(descriptorFileData, ELEM_RENDERER, (Element)node);
                } else if (node.getNodeName().equals(ELEM_FRAMEWORK)) {
                    DescriptorReader_ver_2.parseFramework(descriptorFileData, ELEM_FRAMEWORK, (Element)node);
                } else if (node.getNodeName().equals(ELEM_DOC)) {
                    DescriptorReader_ver_2.parsePart(descriptorFileData, ELEM_DOC, (Element)node);
                } else if (node.getNodeName().equals(ELEM_PAGE)) {
                    DescriptorReader_ver_2.parsePart(descriptorFileData, ELEM_PAGE, (Element)node);
                } else if (node.getNodeName().equals(ELEM_WIDGET)) {
                    DescriptorReader_ver_2.parsePart(descriptorFileData, ELEM_WIDGET, (Element)node);
                } else if (node.getNodeName().equals(ELEM_TYPES)) {
                    DescriptorReader_ver_2.parseTypes(descriptorFileData, (Element)node);
                } else if (node.getNodeName().equals(ELEM_EVENTTYPES)) {
                    DescriptorReader_ver_2.parseEventTypes(descriptorFileData, (Element)node);
                } else if (node.getNodeName().equals(ELEM_UICOMPONENT_CATEGORIES)) {
                    DescriptorReader_ver_2.parseWidgetCategories(descriptorFileData, (Element)node);
                } else if (node.getNodeName().equals(ELEM_DEFAULT_STYLE_EDJS)) {
                    DescriptorReader_ver_2.parseDefaultStyleEdjs(descriptorFileData, (Element)node);
                }
            }
            ++n;
        }
    }

    private static void parseRenderer(DescriptorFileData descriptorFileData, String string, Element element) {
        if (element == null) {
            return;
        }
        String string2 = element.getAttribute(ATTR_ID);
        descriptorFileData.setRendererId(string2);
    }

    private static void parseFramework(DescriptorFileData descriptorFileData, String string, Element element) {
        if (element == null) {
            return;
        }
        String string2 = element.getAttribute(ATTR_NAME);
        descriptorFileData.setFrameworkName(string2);
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node instanceof Element) {
                if (node.getNodeName().equals(ELEM_LIBRARY)) {
                    DescriptorReader_ver_2.parseLibrary(descriptorFileData, string, (Element)node);
                } else if (node.getNodeName().equals(ELEM_EDITOR)) {
                    DescriptorReader_ver_2.parseEditor(descriptorFileData, ELEM_EDITOR, (Element)node);
                }
            }
            ++n;
        }
    }

    private static void parseLibrary(DescriptorFileData descriptorFileData, String string, Element element) {
        if (string.equals(ELEM_FRAMEWORK)) {
            descriptorFileData.addFrameworkLibrary(element.getAttribute(ATTR_SRC));
        } else if (string.equals(ELEM_EDITOR)) {
            descriptorFileData.addEditorLibrary(element.getAttribute(ATTR_SRC));
        }
    }

    private static void parseEditor(DescriptorFileData descriptorFileData, String string, Element element) {
        NodeList nodeList = element.getElementsByTagName(ELEM_LIBRARY);
        int n = 0;
        while (n < nodeList.getLength()) {
            Element element2 = (Element)nodeList.item(n);
            DescriptorReader_ver_2.parseLibrary(descriptorFileData, ELEM_EDITOR, element2);
            ++n;
        }
    }

    private static TizenFileDataEntry parsePart(DescriptorFileData descriptorFileData, String string, Element element) {
        TizenFileDataEntry tizenFileDataEntry;
        NodeList nodeList;
        Object object;
        TizenFileDataEntry tizenFileDataEntry2;
        String[] stringArray;
        String string2;
        if (element == null) {
            return null;
        }
        TizenFileDataEntry tizenFileDataEntry3 = TizenFileDataHelper.convert((String)string, (Element)element, (String[])new String[]{ATTR_ID, ATTR_DISPLAYNAME, ATTR_SMALLICON, ATTR_ICON_16, ATTR_DESCRIPTION, ATTR_LAYOUTTYPE, ATTR_LAYOUT_CAPACITY, ATTR_PALETTE_VISIBLE, ATTR_HELPCATEGORY, ATTR_HELPCONTENS, ATTR_FEEDBACKWIDTH, ATTR_FEEDBACKHEIGHT, ATTR_MINWIDTH, ATTR_MINHEIGHT, ATTR_BORDER_VISIBLE, ATTR_FEEDBACKCONDITION, ATTR_GUIDE_TEXT, ATTR_SET_STYLE, ATTR_UI_SELECTOR, ATTR_XPATH, ATTR_CHILDXPATH, ATTR_SELFCHILDXPATH, ATTR_CONTAINER_ID, ATTR_REQUIRED});
        if (string.equals(ELEM_WIDGET) && (string2 = element.getAttribute(ATTR_CATEGORY)) != null && !string2.isEmpty()) {
            stringArray = string2.split(",");
            tizenFileDataEntry3.addListProperty("categoryList", Arrays.asList(stringArray));
        }
        boolean bl = true;
        stringArray = element.getElementsByTagName(ELEM_RELATIONS);
        int n = 0;
        while (n < stringArray.getLength()) {
            tizenFileDataEntry2 = DescriptorReader_ver_2.parseRelations((Element)stringArray.item(n));
            if (tizenFileDataEntry2 != null) {
                object = tizenFileDataEntry3.getEntryProperty("relation");
                if (object != null) {
                    object.addListPropertyList(ELEM_PARENT, tizenFileDataEntry2.getListProperty(ELEM_PARENT));
                    object.addListPropertyList(ELEM_NOPARENT, tizenFileDataEntry2.getListProperty(ELEM_NOPARENT));
                    object.addListPropertyList(ELEM_CONTENT, tizenFileDataEntry2.getListProperty(ELEM_CONTENT));
                    object.addListPropertyList(ELEM_NOCONTENT, tizenFileDataEntry2.getListProperty(ELEM_NOCONTENT));
                } else {
                    tizenFileDataEntry3.addEntryProperty("relation", tizenFileDataEntry2);
                }
                bl = false;
            }
            ++n;
        }
        if (bl && (nodeList = element.getElementsByTagName(ELEM_CONTENT)).getLength() > 0) {
            tizenFileDataEntry2 = new TizenFileDataEntry();
            int n2 = 0;
            while (n2 < nodeList.getLength()) {
                tizenFileDataEntry = DescriptorReader_ver_2.parseContent((Element)nodeList.item(n2));
                if (tizenFileDataEntry != null) {
                    String string3 = tizenFileDataEntry.getStringProperty(ATTR_EXCLUDE_IDS);
                    String[] stringArray2 = string3.split(",");
                    List<String> list = Arrays.asList(stringArray2);
                    tizenFileDataEntry2.addListPropertyList(ELEM_NOCONTENT, list);
                    String string4 = tizenFileDataEntry.getStringProperty(ATTR_PARENT_IDS);
                    stringArray2 = string4.split(",");
                    list = Arrays.asList(stringArray2);
                    tizenFileDataEntry2.addListPropertyList(ELEM_PARENT, list);
                }
                ++n2;
            }
            tizenFileDataEntry3.addEntryProperty("relation", tizenFileDataEntry2);
        }
        NodeList nodeList2 = element.getChildNodes();
        int n3 = 0;
        while (n3 < nodeList2.getLength()) {
            object = nodeList2.item(n3);
            if (object instanceof Element) {
                if (object.getNodeName().equals(ELEM_CONDITION)) {
                    tizenFileDataEntry = DescriptorReader_ver_2.parsePartCondition((Element)object);
                    if (tizenFileDataEntry != null) {
                        tizenFileDataEntry3.addListPropertyItem("conditionList", (Object)tizenFileDataEntry);
                    }
                } else if (object.getNodeName().equals(ELEM_PROPERTY)) {
                    tizenFileDataEntry = DescriptorReader_ver_2.parseProperty((Element)object);
                    if (tizenFileDataEntry != null) {
                        tizenFileDataEntry3.addListPropertyItem("propertyList", (Object)tizenFileDataEntry);
                    }
                } else if (object.getNodeName().equals(ELEM_CHILDUICOMPONENTPROPERTY)) {
                    tizenFileDataEntry = DescriptorReader_ver_2.parseChildUIComponentProperty((Element)object);
                    if (tizenFileDataEntry != null) {
                        tizenFileDataEntry3.addListPropertyItem("childUIComponentPropertyList", (Object)tizenFileDataEntry);
                    }
                } else if (object.getNodeName().equals(ELEM_EVENT)) {
                    tizenFileDataEntry = DescriptorReader_ver_2.parseEvent((Element)object);
                    if (tizenFileDataEntry != null) {
                        tizenFileDataEntry3.addListPropertyItem("eventList", (Object)tizenFileDataEntry);
                    }
                } else {
                    object.getNodeName().equals(ELEM_XSL_FOR_OUTPUT);
                }
            }
            ++n3;
        }
        descriptorFileData.addPartDescriptor(tizenFileDataEntry3);
        return tizenFileDataEntry3;
    }

    private static TizenFileDataEntry parseRelations(Element element) {
        if (element == null) {
            return null;
        }
        TizenFileDataEntry tizenFileDataEntry = new TizenFileDataEntry();
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node instanceof Element) {
                List<String> list;
                String[] stringArray;
                String string;
                Element element2 = (Element)node;
                if (node.getNodeName().equals(ELEM_PARENT)) {
                    string = element2.getAttribute(ATTR_IDS);
                    stringArray = string.split(",");
                    list = Arrays.asList(stringArray);
                    tizenFileDataEntry.addListPropertyList(ELEM_PARENT, list);
                } else if (node.getNodeName().equals(ELEM_NOPARENT)) {
                    string = element2.getAttribute(ATTR_IDS);
                    stringArray = string.split(",");
                    list = Arrays.asList(stringArray);
                    tizenFileDataEntry.addListPropertyList(ELEM_NOPARENT, list);
                } else if (node.getNodeName().equals(ELEM_CONTENT)) {
                    string = DescriptorReader_ver_2.parseContent2(element2);
                    tizenFileDataEntry.addListPropertyItem(ELEM_CONTENT, (Object)string);
                } else if (node.getNodeName().equals(ELEM_NOCONTENT)) {
                    string = element2.getAttribute(ATTR_IDS);
                    stringArray = string.split(",");
                    list = Arrays.asList(stringArray);
                    tizenFileDataEntry.addListPropertyList(ELEM_NOCONTENT, list);
                }
            }
            ++n;
        }
        return tizenFileDataEntry;
    }

    private static TizenFileDataEntry parseContent(Element element) {
        if (element == null) {
            return null;
        }
        TizenFileDataEntry tizenFileDataEntry = TizenFileDataHelper.convert((String)"", (Element)element, (String[])new String[]{ATTR_EXCLUDE_IDS, ATTR_PARENT_IDS});
        return tizenFileDataEntry;
    }

    private static TizenFileDataEntry parseContent2(Element element) {
        if (element == null) {
            return null;
        }
        TizenFileDataEntry tizenFileDataEntry = TizenFileDataHelper.convert((String)"", (Element)element, (String[])new String[]{ATTR_IDS, "type", ATTR_MIN, ATTR_MAX, ATTR_EXCLUSIVE_GROUP});
        return tizenFileDataEntry;
    }

    private static TizenFileDataEntry parsePartCondition(Element element) {
        if (element == null) {
            return null;
        }
        TizenFileDataEntry tizenFileDataEntry = TizenFileDataHelper.convert((String)"", (Element)element, (String[])new String[]{ATTR_NAME, "value", ATTR_TARGET, ATTR_TARGETVALUE});
        return tizenFileDataEntry;
    }

    private static TizenFileDataEntry parseChildUIComponentProperty(Element element) {
        if (element == null) {
            return null;
        }
        TizenFileDataEntry tizenFileDataEntry = new TizenFileDataEntry();
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            TizenFileDataEntry tizenFileDataEntry2;
            Node node = nodeList.item(n);
            if (node instanceof Element && (tizenFileDataEntry2 = DescriptorReader_ver_2.parseProperty((Element)nodeList.item(n))) != null) {
                tizenFileDataEntry.addListPropertyItem("propertyList", (Object)tizenFileDataEntry2);
            }
            ++n;
        }
        return tizenFileDataEntry;
    }

    private static TizenFileDataEntry parseProperty(Element element) {
        TizenFileDataEntry tizenFileDataEntry;
        int n;
        NodeList nodeList;
        if (element == null) {
            return null;
        }
        String string = element.getAttribute(ATTR_NOT_SUPPORTED);
        if (string != null && string.equals("true")) {
            return null;
        }
        TizenFileDataEntry tizenFileDataEntry2 = TizenFileDataHelper.convert((String)"", (Element)element, (String[])new String[]{ATTR_NAME, "type", ATTR_DISPLAYNAME, ATTR_DEFAULT, ATTR_INITVALUE, ATTR_CATEGORY, ATTR_XPATH, ATTR_ATTRXPATH, ATTR_INLINE, ATTR_UNUSED_EDITORS});
        String string2 = element.getAttribute("type");
        String string3 = element.getAttribute(ATTR_DISPLAYNAME);
        String string4 = element.getAttribute(ATTR_TOOLTIP);
        string4 = string4.isEmpty() ? string3 : String.valueOf(string3) + " " + "-" + " " + string4;
        tizenFileDataEntry2.addProperty(ATTR_TOOLTIP, (Object)string4);
        if (ATTR_GROUP.equals(string2) || "group-text".equals(string2) || "group-position".equals(string2)) {
            nodeList = element.getElementsByTagName(ELEM_PROPERTY);
            n = 0;
            while (n < nodeList.getLength()) {
                tizenFileDataEntry = DescriptorReader_ver_2.parseChildProperty((Element)nodeList.item(n));
                if (tizenFileDataEntry != null) {
                    tizenFileDataEntry2.addListPropertyItem("propertyList", (Object)tizenFileDataEntry);
                }
                ++n;
            }
        }
        nodeList = element.getElementsByTagName(ELEM_CONDITION);
        n = 0;
        while (n < nodeList.getLength()) {
            tizenFileDataEntry = DescriptorReader_ver_2.parseCondition((Element)nodeList.item(n));
            if (tizenFileDataEntry != null) {
                tizenFileDataEntry2.addListPropertyItem("conditionList", (Object)tizenFileDataEntry);
            }
            ++n;
        }
        return tizenFileDataEntry2;
    }

    private static TizenFileDataEntry parseChildProperty(Element element) {
        if (element == null) {
            return null;
        }
        TizenFileDataEntry tizenFileDataEntry = TizenFileDataHelper.convert((String)"", (Element)element, (String[])new String[]{ATTR_NAME, "type", ATTR_DISPLAYNAME, ATTR_TOOLTIP, ATTR_DEFAULT, ATTR_INITVALUE, ATTR_CATEGORY, ATTR_XPATH, ATTR_ATTRXPATH, ATTR_SELECTOR});
        NodeList nodeList = element.getElementsByTagName(ELEM_CONDITION);
        int n = 0;
        while (n < nodeList.getLength()) {
            TizenFileDataEntry tizenFileDataEntry2 = DescriptorReader_ver_2.parseCondition((Element)nodeList.item(n));
            if (tizenFileDataEntry2 != null) {
                tizenFileDataEntry.addListPropertyItem("conditionList", (Object)tizenFileDataEntry2);
            }
            ++n;
        }
        return tizenFileDataEntry;
    }

    private static TizenFileDataEntry parseCondition(Element element) {
        if (element == null) {
            return null;
        }
        TizenFileDataEntry tizenFileDataEntry = TizenFileDataHelper.convert((String)"", (Element)element, (String[])new String[]{ATTR_NAME, "value", ATTR_TARGET, ATTR_TARGETVALUE, ATTR_ERROR});
        return tizenFileDataEntry;
    }

    private static TizenFileDataEntry parseEvent(Element element) {
        if (element == null) {
            return null;
        }
        TizenFileDataEntry tizenFileDataEntry = TizenFileDataHelper.convert((String)"", (Element)element, (String[])new String[]{ATTR_NAME, ATTR_DISPLAYNAME, "eventType", ATTR_EVENTINFO});
        return tizenFileDataEntry;
    }

    private static void parseTypes(DescriptorFileData descriptorFileData, Element element) {
        if (element == null) {
            return;
        }
        NodeList nodeList = element.getElementsByTagName("type");
        int n = 0;
        while (n < nodeList.getLength()) {
            TizenFileDataEntry tizenFileDataEntry = DescriptorReader_ver_2.parseType((Element)nodeList.item(n));
            descriptorFileData.addType(tizenFileDataEntry);
            ++n;
        }
    }

    private static TizenFileDataEntry parseType(Element element) {
        TizenFileDataEntry tizenFileDataEntry;
        if (element == null) {
            return null;
        }
        TizenFileDataEntry tizenFileDataEntry2 = TizenFileDataHelper.convert((String)"", (Element)element, (String[])new String[]{ATTR_ID});
        NodeList nodeList = element.getElementsByTagName(ELEM_CONSTANT);
        int n = 0;
        while (n < nodeList.getLength()) {
            tizenFileDataEntry = DescriptorReader_ver_2.parseConstant((Element)nodeList.item(n));
            tizenFileDataEntry2.addListPropertyItem("constantList", (Object)tizenFileDataEntry);
            ++n;
        }
        nodeList = element.getElementsByTagName(ELEM_UNIT);
        n = 0;
        while (n < nodeList.getLength()) {
            tizenFileDataEntry = DescriptorReader_ver_2.parseUnit((Element)nodeList.item(n));
            tizenFileDataEntry2.addListPropertyItem("unitList", (Object)tizenFileDataEntry);
            ++n;
        }
        return tizenFileDataEntry2;
    }

    private static TizenFileDataEntry parseConstant(Element element) {
        if (element == null) {
            return null;
        }
        TizenFileDataEntry tizenFileDataEntry = TizenFileDataHelper.convert((String)"", (Element)element, (String[])new String[]{"value", ATTR_DISPLAYNAME, ATTR_ICON, ATTR_REQUIRED});
        return tizenFileDataEntry;
    }

    private static TizenFileDataEntry parseUnit(Element element) {
        if (element == null) {
            return null;
        }
        TizenFileDataEntry tizenFileDataEntry = TizenFileDataHelper.convert((String)"", (Element)element, (String[])new String[]{"value", ATTR_DISPLAYNAME});
        return tizenFileDataEntry;
    }

    private static void parseEventTypes(DescriptorFileData descriptorFileData, Element element) {
        if (element == null) {
            return;
        }
        NodeList nodeList = element.getElementsByTagName("eventType");
        int n = 0;
        while (n < nodeList.getLength()) {
            TizenFileDataEntry tizenFileDataEntry = DescriptorReader_ver_2.parseEventType(descriptorFileData, (Element)nodeList.item(n));
            if (tizenFileDataEntry != null) {
                descriptorFileData.addEventType(tizenFileDataEntry);
            }
            ++n;
        }
    }

    private static TizenFileDataEntry parseEventType(DescriptorFileData descriptorFileData, Element element) {
        if (element == null) {
            return null;
        }
        TizenFileDataEntry tizenFileDataEntry = TizenFileDataHelper.convert((String)"", (Element)element, (String[])new String[]{ATTR_ID});
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node instanceof Element) {
                Element element2 = (Element)node;
                if (node.getNodeName().equals(ELEM_DEFAULTCODE)) {
                    tizenFileDataEntry.addStringProperty(ELEM_DEFAULTCODE, element2.getTextContent());
                } else if (node.getNodeName().equals(ELEM_PARAM)) {
                    tizenFileDataEntry.addListPropertyItem("paramList", (Object)DescriptorReader_ver_2.parseParameter(element2));
                }
            }
            ++n;
        }
        return tizenFileDataEntry;
    }

    private static void parseWidgetCategories(DescriptorFileData descriptorFileData, Element element) {
        if (element == null) {
            return;
        }
        NodeList nodeList = element.getElementsByTagName(ELEM_UICOMPONENT_CATEGORY);
        int n = 0;
        while (n < nodeList.getLength()) {
            TizenFileDataEntry tizenFileDataEntry = DescriptorReader_ver_2.parseWidgetCategory(descriptorFileData, (Element)nodeList.item(n));
            if (tizenFileDataEntry != null) {
                descriptorFileData.addUIComponentCategory(tizenFileDataEntry);
            }
            ++n;
        }
    }

    private static void parseDefaultStyleEdjs(DescriptorFileData descriptorFileData, Element element) {
        if (element == null) {
            return;
        }
        NodeList nodeList = element.getElementsByTagName(ELEM_STYLE_EDJ);
        int n = 0;
        while (n < nodeList.getLength()) {
            TizenFileDataEntry tizenFileDataEntry = DescriptorReader_ver_2.parseStyleEDJ(descriptorFileData, (Element)nodeList.item(n));
            if (tizenFileDataEntry != null) {
                descriptorFileData.addDefaultStyleEDJs(tizenFileDataEntry);
            }
            ++n;
        }
    }

    private static TizenFileDataEntry parseWidgetCategory(DescriptorFileData descriptorFileData, Element element) {
        if (element == null) {
            return null;
        }
        TizenFileDataEntry tizenFileDataEntry = TizenFileDataHelper.convert((String)"", (Element)element, (String[])new String[]{ATTR_NAME});
        return tizenFileDataEntry;
    }

    private static TizenFileDataEntry parseStyleEDJ(DescriptorFileData descriptorFileData, Element element) {
        if (element == null) {
            return null;
        }
        TizenFileDataEntry tizenFileDataEntry = TizenFileDataHelper.convert((String)"", (Element)element, (String[])new String[]{ATTR_NAME});
        return tizenFileDataEntry;
    }

    private static TizenFileDataEntry parseParameter(Element element) {
        if (element == null) {
            return null;
        }
        TizenFileDataEntry tizenFileDataEntry = TizenFileDataHelper.convert((String)"", (Element)element, (String[])new String[]{ATTR_NAME, "type"});
        return tizenFileDataEntry;
    }

    private static void parseCustomComponentRoot(DescriptorFileData descriptorFileData, Element element, DocumentBuilder documentBuilder) {
        if (element == null) {
            return;
        }
        DescriptorReader_ver_2.parseCustomComponentPart(descriptorFileData, ELEM_WIDGET, element);
    }

    private static TizenFileDataEntry parseCustomComponentPart(DescriptorFileData descriptorFileData, String string, Element element) {
        if (element == null) {
            return null;
        }
        TizenFileDataEntry tizenFileDataEntry = TizenFileDataHelper.convert((String)string, (Element)element, (String[])new String[]{ATTR_NAME, ATTR_DISPLAYNAMES, ATTR_DESCRIPTION, ATTR_MINWIDTHS, ATTR_MINHEIGHTS, ATTR_GROUP, ATTR_RESIZEMODE, ATTR_DEFAULTVALUE, ATTR_PARTNAME, ATTR_CLASSNAME, ATTR_SIGNAL, ATTR_SOURCE});
        String[] stringArray = new String[]{ATTR_CUSTOMCOMPONENTCATEGORY};
        tizenFileDataEntry.addListProperty("categoryList", Arrays.asList(stringArray));
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node instanceof Element) {
                TizenFileDataEntry tizenFileDataEntry2;
                if (node.getNodeName().equals(ELEM_CONDITION)) {
                    tizenFileDataEntry2 = DescriptorReader_ver_2.parseCustomComponentPartCondition((Element)node);
                    if (tizenFileDataEntry2 != null) {
                        tizenFileDataEntry.addListPropertyItem("conditionList", (Object)tizenFileDataEntry2);
                    }
                } else if (node.getNodeName().equals(ELEM_PROPERTY)) {
                    tizenFileDataEntry2 = DescriptorReader_ver_2.parseCustomComponentProperty((Element)node);
                    if (tizenFileDataEntry2 != null) {
                        tizenFileDataEntry.addListPropertyItem("propertyList", (Object)tizenFileDataEntry2);
                    }
                } else if (node.getNodeName().equals(ELEM_CHILDUICOMPONENTPROPERTY)) {
                    tizenFileDataEntry2 = DescriptorReader_ver_2.parseChildUIComponentProperty((Element)node);
                    if (tizenFileDataEntry2 != null) {
                        tizenFileDataEntry.addListPropertyItem("childUIComponentPropertyList", (Object)tizenFileDataEntry2);
                    }
                } else if (node.getNodeName().equals(ELEM_EVENT)) {
                    tizenFileDataEntry2 = DescriptorReader_ver_2.parseCustomComponentEvent((Element)node);
                    if (tizenFileDataEntry2 != null) {
                        tizenFileDataEntry.addListPropertyItem("eventList", (Object)tizenFileDataEntry2);
                    }
                } else if (node.getNodeName().equals("value")) {
                    tizenFileDataEntry2 = DescriptorReader_ver_2.parseCustomComponentPartCondition((Element)node);
                    if (tizenFileDataEntry2 != null) {
                        tizenFileDataEntry.addListPropertyItem("conditionList", (Object)tizenFileDataEntry2);
                    }
                } else if (node.getNodeName().equals(ELEM_STATE)) {
                    tizenFileDataEntry2 = DescriptorReader_ver_2.parseCustomComponentProperty((Element)node);
                    if (tizenFileDataEntry2 != null) {
                        tizenFileDataEntry.addListPropertyItem("propertyList", (Object)tizenFileDataEntry2);
                    }
                } else if (node.getNodeName().equals(ELEM_TEXT)) {
                    tizenFileDataEntry2 = DescriptorReader_ver_2.parseCustomComponentProperty((Element)node);
                    if (tizenFileDataEntry2 != null) {
                        tizenFileDataEntry.addListPropertyItem("propertyList", (Object)tizenFileDataEntry2);
                    }
                } else if (node.getNodeName().equals(ELEM_COLOR)) {
                    tizenFileDataEntry2 = DescriptorReader_ver_2.parseCustomComponentProperty((Element)node);
                    if (tizenFileDataEntry2 != null) {
                        tizenFileDataEntry.addListPropertyItem("propertyList", (Object)tizenFileDataEntry2);
                    }
                } else if (node.getNodeName().equals(ELEM_EVENTTYPES)) {
                    DescriptorReader_ver_2.parseEventTypes(descriptorFileData, (Element)node);
                }
            }
            ++n;
        }
        descriptorFileData.addPartDescriptor(tizenFileDataEntry);
        return tizenFileDataEntry;
    }

    private static TizenFileDataEntry parseCustomComponentPartCondition(Element element) {
        if (element == null) {
            return null;
        }
        TizenFileDataEntry tizenFileDataEntry = TizenFileDataHelper.convert((String)"", (Element)element, (String[])new String[]{ATTR_NAME, "value", ATTR_SIGNAL, ATTR_SOURCE});
        return tizenFileDataEntry;
    }

    private static TizenFileDataEntry parseCustomComponentProperty(Element element) {
        if (element == null) {
            return null;
        }
        String string = element.getAttribute(ATTR_NOT_SUPPORTED);
        if (string != null && string.equals("true")) {
            return null;
        }
        TizenFileDataEntry tizenFileDataEntry = TizenFileDataHelper.convert((String)"", (Element)element, (String[])new String[]{ATTR_NAME, ATTR_DISPLAYNAMES, ATTR_DEFAULTVALUE, ATTR_DESCRIPTION, ATTR_PARTNAME, ATTR_CLASSNAME});
        tizenFileDataEntry.addProperty("tagName", (Object)element.getTagName());
        String string2 = element.getAttribute(ATTR_DISPLAYNAMES);
        String string3 = element.getAttribute(ATTR_DEFAULTVALUE);
        tizenFileDataEntry.addProperty(ATTR_DEFAULT, (Object)string3);
        String string4 = element.getAttribute(ATTR_DESCRIPTION);
        String string5 = null;
        string5 = string4 != null ? string4 : String.valueOf(string2) + " " + "-" + " " + string4;
        tizenFileDataEntry.addProperty(ATTR_TOOLTIP, (Object)string5);
        NodeList nodeList = element.getElementsByTagName("value");
        int n = 0;
        while (n < nodeList.getLength()) {
            TizenFileDataEntry tizenFileDataEntry2 = DescriptorReader_ver_2.parseCustomComponentCondition((Element)nodeList.item(n));
            if (tizenFileDataEntry2 != null) {
                tizenFileDataEntry.addListPropertyItem("conditionList", (Object)tizenFileDataEntry2);
            }
            ++n;
        }
        return tizenFileDataEntry;
    }

    private static TizenFileDataEntry parseCustomComponentCondition(Element element) {
        if (element == null) {
            return null;
        }
        TizenFileDataEntry tizenFileDataEntry = TizenFileDataHelper.convert((String)"", (Element)element, (String[])new String[]{ATTR_NAME, ATTR_DISPLAYNAMES, ATTR_SIGNAL, ATTR_SOURCE});
        return tizenFileDataEntry;
    }

    private static TizenFileDataEntry parseCustomComponentEvent(Element element) {
        if (element == null) {
            return null;
        }
        TizenFileDataEntry tizenFileDataEntry = TizenFileDataHelper.convert((String)"", (Element)element, (String[])new String[]{ATTR_NAME, ATTR_DISPLAYNAMES, ATTR_DESCRIPTION, ATTR_SIGNAL, ATTR_SOURCE});
        return tizenFileDataEntry;
    }
}

