<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="text" encoding="utf-8"/>
 
    <xsl:template match="/*[node()]">
        <!-- <xsl:text>[</xsl:text> -->
        <xsl:apply-templates select="." mode="obj-content" />
        <!-- <xsl:text>]</xsl:text> -->
    </xsl:template>
 
    <xsl:template match="*" mode="obj-content">
    	<xsl:choose>
			<xsl:when test="name() = 'event'">
			</xsl:when>
			<xsl:otherwise>
		        <xsl:text>{</xsl:text>
		            <xsl:variable name="properties_cnt" select="@*"/>
		            <xsl:variable name="child_cnt" select="child::*"/>
		
		            <xsl:text>"widgetType" : "</xsl:text><xsl:value-of select="name()"/><xsl:text>",</xsl:text>
		            <xsl:text>"wid" : "</xsl:text><xsl:value-of select="@part-id"/><xsl:text>"</xsl:text>
		            <xsl:if test="$properties_cnt or $child_cnt">,</xsl:if>
		            
		            <xsl:if test="$properties_cnt">
		              <xsl:text>"properties" : {</xsl:text> 
		              <xsl:apply-templates select="@*" mode="attr" />
		              <xsl:text>}</xsl:text>
		              <xsl:variable name="node_cnt" select="'1'" />
		            </xsl:if>
		            <xsl:if test="$child_cnt">
		              <xsl:if test="$properties_cnt">,</xsl:if>            
		              <xsl:text>"children" : [</xsl:text>
		              <xsl:apply-templates select="./*" mode="obj-content" />
		              <xsl:text>]</xsl:text>
		            </xsl:if>
		        <xsl:text>}</xsl:text>
		        <xsl:if test="position() &lt; last()">, </xsl:if>
			</xsl:otherwise>
		</xsl:choose>        
    </xsl:template>
 
    <xsl:template match="@*" mode="attr">
        <xsl:text>"</xsl:text><xsl:value-of select="name()"/>" : "<xsl:value-of select="."/><xsl:text>"</xsl:text>
        <xsl:if test="position() &lt; last()">,</xsl:if>
    </xsl:template>
 
    <xsl:template match="node/@TEXT | text()" name="removeBreaks">
        <xsl:param name="pText" select="normalize-space(.)"/>
        <xsl:choose>
            <xsl:when test="not(contains($pText, '&#xA;'))"><xsl:copy-of select="$pText"/></xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="concat(substring-before($pText, '&#xD;&#xA;'), ' ')"/>
                <xsl:call-template name="removeBreaks">
                    <xsl:with-param name="pText" select="substring-after($pText, '&#xD;&#xA;')"/>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template> 
</xsl:stylesheet>
