<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:template match="indexitem">
		<xsl:param name="parent" />
		<xsl:param name="level" select="count(./ancestor::*)-count(//view/ancestor::*)" />
		<xsl:param name="indentation">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level" />
			</xsl:call-template>
		</xsl:param>
		<xsl:param name="indentation1">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level+1" />
			</xsl:call-template>
		</xsl:param>
		<xsl:variable name="callback">
			<xsl:apply-templates select="event" mode="item_event">
				<xsl:with-param name="parent" select="@id" />
				<xsl:with-param name="view" select="./ancestor::view/@id" />
				<!-- Storyboard_START -->
				<xsl:with-param name="target" select="event/@target" />
				<!-- Storyboard_END -->
			</xsl:apply-templates>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="string-length($callback) != 0">
				<xsl:choose>
					<xsl:when test="@label">
						<xsl:value-of
							select="concat($indentation, 'vc->', @id, ' = elm_index_item_append(vc->', $parent, ', _UIB_LOCALE(&quot;', @label, '&quot;), (Evas_Smart_Cb)', $callback, ', vc);', $newline)" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of
							select="concat($indentation, 'vc->', @id, ' = elm_index_item_append(vc->', $parent, ', _UIB_LOCALE(&quot;', @text, '&quot;), (Evas_Smart_Cb)', $callback, ', vc);', $newline)" />
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="@label">
						<xsl:value-of
							select="concat($indentation, 'vc->', @id, ' = elm_index_item_append(vc->', $parent, ', _UIB_LOCALE(&quot;', @label, '&quot;), NULL, NULL);', $newline)" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of
							select="concat($indentation, 'vc->', @id, ' = elm_index_item_append(vc->', $parent, ', _UIB_LOCALE(&quot;', @text, '&quot;), NULL, NULL);', $newline)" />
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:if test="string-length(@selected) != 0">
			<xsl:choose>
				<xsl:when test="@selected = 'true'">
					<xsl:value-of select="concat($indentation, 'elm_index_item_selected_set(vc->', @id, ', EINA_TRUE);', $newline)" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="concat($indentation, 'elm_index_item_selected_set(vc->', @id, ', EINA_FALSE);', $newline)" />
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="string-length(@disable) != 0">
			<xsl:choose>
				<xsl:when test="@disable = 'true'">
					<xsl:value-of select="concat($indentation, 'elm_object_item_disabled_set(vc->', @id, ', EINA_TRUE);', $newline)" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="concat($indentation, 'elm_object_item_disabled_set(vc->', @id, ', EINA_FALSE);', $newline)" />
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>

	</xsl:template>
</xsl:stylesheet>
