/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.efluibuilder.projectmigrator.codewriter;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IInclude;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.efluibuilder.projectmigrator.codewriter.CodeWriterException;
import org.tizen.efluibuilder.projectmigrator.codewriter.visitor.ReWriteVisitor;
import org.tizen.efluibuilder.projectmigrator.ui.message.Messages;

public final class ASTManager {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<String, ITranslationUnit> tus = new HashMap<String, ITranslationUnit>();
    private Map<String, Map<Integer, IASTTranslationUnit>> asts = new HashMap<String, Map<Integer, IASTTranslationUnit>>();

    public void visit(IFile iFile, int n, ASTVisitor aSTVisitor) throws CodeWriterException {
        if (iFile == null || aSTVisitor == null) {
            return;
        }
        IASTTranslationUnit iASTTranslationUnit = this.getAST(iFile, n);
        if (iASTTranslationUnit != null) {
            iASTTranslationUnit.accept(aSTVisitor);
        }
        if (aSTVisitor instanceof ReWriteVisitor) {
            this.reWrite(iFile, (ReWriteVisitor)aSTVisitor);
        }
    }

    public void appendInclude(IFile iFile, String string) throws CodeWriterException {
        if (iFile == null || string == null) {
            return;
        }
        ITranslationUnit iTranslationUnit = this.getTranslationUnit(iFile);
        if (iTranslationUnit != null) {
            try {
                IInclude iInclude;
                IInclude[] iIncludeArray;
                IInclude[] iIncludeArray2 = iIncludeArray = iTranslationUnit.getIncludes();
                int n = iIncludeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    iInclude = iIncludeArray2[n2];
                    if (string.equals(iInclude.getIncludeName())) {
                        return;
                    }
                    ++n2;
                }
                iInclude = null;
                if (iIncludeArray.length > 0) {
                    iInclude = iIncludeArray[0];
                }
                iTranslationUnit.createInclude(string, false, (ICElement)iInclude, null);
            }
            catch (CModelException cModelException) {
                this.logger.error(cModelException.getMessage());
                throw new CodeWriterException(Messages.CORE_EXCEPTION_MSG_INTERNAL);
            }
        }
    }

    public void flushAll() {
        this.asts.clear();
        this.tus.clear();
    }

    public void flush(IFile iFile) {
        if (iFile == null) {
            return;
        }
        this.flushASTT(iFile);
        this.flushTranslationUnit(iFile);
    }

    private void flushASTT(IFile iFile) {
        this.asts.remove(iFile.getLocation().toString());
    }

    private void flushTranslationUnit(IFile iFile) {
        this.tus.remove(iFile.getLocation().toString());
    }

    private void reWrite(IFile iFile, ReWriteVisitor reWriteVisitor) throws CodeWriterException {
        ASTRewrite aSTRewrite = reWriteVisitor.getReWrite();
        if (aSTRewrite != null) {
            try {
                Change change = aSTRewrite.rewriteAST();
                change.perform((IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {
                this.logger.error(coreException.getMessage());
                throw new CodeWriterException(Messages.CORE_EXCEPTION_MSG_INTERNAL);
            }
        }
        this.flush(iFile);
    }

    private IASTTranslationUnit getAST(IFile iFile, int n) throws CodeWriterException {
        if (iFile == null || !iFile.exists()) {
            return null;
        }
        IASTTranslationUnit iASTTranslationUnit = null;
        Map<Integer, IASTTranslationUnit> map = this.asts.get(iFile.getLocation().toString());
        if (map == null) {
            map = new HashMap<Integer, IASTTranslationUnit>();
            this.asts.put(iFile.getLocation().toString(), map);
        }
        if ((iASTTranslationUnit = map.get(n)) == null) {
            iASTTranslationUnit = this.createAST(iFile, n);
            map.put(n, iASTTranslationUnit);
        }
        return iASTTranslationUnit;
    }

    private ITranslationUnit getTranslationUnit(IFile iFile) {
        if (iFile == null || !iFile.exists()) {
            return null;
        }
        ITranslationUnit iTranslationUnit = this.tus.get(iFile.getLocation().toString());
        if (iTranslationUnit == null) {
            iTranslationUnit = (ITranslationUnit)CoreModel.getDefault().create(iFile);
            this.tus.put(iFile.getLocation().toString(), iTranslationUnit);
        }
        return iTranslationUnit;
    }

    private IASTTranslationUnit createAST(IFile iFile, int n) throws CodeWriterException {
        if (iFile == null || !iFile.exists()) {
            return null;
        }
        IASTTranslationUnit iASTTranslationUnit = null;
        ITranslationUnit iTranslationUnit = this.getTranslationUnit(iFile);
        if (iTranslationUnit == null) {
            this.logger.error("Fail to get translationUnit");
            throw new CodeWriterException(Messages.CORE_EXCEPTION_MSG_INTERNAL);
        }
        try {
            iASTTranslationUnit = iTranslationUnit.getAST(null, n);
        }
        catch (CoreException coreException) {
            this.logger.error(coreException.getMessage());
            throw new CodeWriterException(Messages.CORE_EXCEPTION_MSG_INTERNAL);
        }
        return iASTTranslationUnit;
    }
}

