/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.efluibuilder.codegenerator.view;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.TizenProjectDescription;
import org.tizen.common.util.ProjectUtil;
import org.tizen.efluibuilder.codegenerator.CodeGeneratorException;
import org.tizen.efluibuilder.codegenerator.CodeGeneratorUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class ViewCodeGenerator {
    private static Logger logger = LoggerFactory.getLogger(ViewCodeGenerator.class);
    private static Map<String, String> viewCodeMap = ViewCodeGenerator.initViewCodeMap();
    private IProject project = null;
    private File targetDirectory = null;
    private String profile = null;
    private String isRMSupportVersion = null;
    private String platformVersion = null;

    private static Map<String, String> initViewCodeMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = "res/";
        hashMap.put("src/managed/inc/uib_%id%_view.h", String.valueOf(string) + "inc/uib_view_header.xsl");
        hashMap.put("src/managed/src/view/uib_%id%_view.c", String.valueOf(string) + "src/uib_view_source.xsl");
        hashMap.put("src/managed/src/connection/uib_%id%_connection.c", String.valueOf(string) + "src/uib_connection_source.xsl");
        return Collections.unmodifiableMap(hashMap);
    }

    public ViewCodeGenerator(IProject iProject) throws CodeGeneratorException {
        this.project = iProject;
        try {
            this.profile = CodeGeneratorUtil.getProfile(iProject);
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw new CodeGeneratorException(xPathExpressionException.getMessage());
        }
        catch (SAXException sAXException) {
            throw new CodeGeneratorException(sAXException.getMessage());
        }
        catch (IOException iOException) {
            throw new CodeGeneratorException(iOException.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new CodeGeneratorException(parserConfigurationException.getMessage());
        }
        TizenProjectDescription tizenProjectDescription = ProjectUtil.getTizenProjectDescription((IProject)iProject);
        this.platformVersion = tizenProjectDescription.getVersion();
        this.isRMSupportVersion = String.valueOf(CodeGeneratorUtil.isVersionRMSupport(this.platformVersion));
        this.targetDirectory = new File(iProject.getLocation().toString());
    }

    public void generate(String string) throws CodeGeneratorException {
        IFile iFile = this.project.getFile("layout/layout.xml");
        File file = new File(iFile.getLocation().toString());
        try {
            Document document = CodeGeneratorUtil.loadXML(file);
            this.clean(string);
            this.createDirectories();
            Set<String> set = viewCodeMap.keySet();
            for (String string2 : set) {
                String string3 = viewCodeMap.get(string2);
                string2 = string2.replace("%id%", string);
                Writer writer = CodeGeneratorUtil.getDestinationWriter(this.targetDirectory, string2);
                InputStream inputStream = CodeGeneratorUtil.openStream(string3);
                StreamSource streamSource = new StreamSource(inputStream);
                this.generateCode(document, writer, streamSource, string);
                writer.close();
                inputStream.close();
                this.refresh(string2);
            }
        }
        catch (SAXException sAXException) {
            throw new CodeGeneratorException(sAXException.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new CodeGeneratorException(parserConfigurationException.getMessage());
        }
        catch (IOException iOException) {
            throw new CodeGeneratorException(iOException.getMessage());
        }
        catch (TransformerException transformerException) {
            throw new CodeGeneratorException(transformerException.getMessage());
        }
    }

    public void clean(String string) throws CodeGeneratorException {
        Set<String> set = viewCodeMap.keySet();
        for (String string2 : set) {
            File file = new File(this.targetDirectory, string2 = string2.replace("%id%", string));
            if (!file.exists()) continue;
            FileUtils.deleteQuietly((File)file);
            this.refresh(string2);
        }
    }

    private void createDirectories() {
        CodeGeneratorUtil.createDirectoy(this.targetDirectory, "src/managed/inc/");
        CodeGeneratorUtil.createDirectoy(this.targetDirectory, "src/managed/src/view/");
        CodeGeneratorUtil.createDirectoy(this.targetDirectory, "src/managed/src/connection/");
    }

    private void refresh(String string) throws CodeGeneratorException {
        IFile iFile = this.project.getFile(string);
        if (iFile != null) {
            try {
                iFile.refreshLocal(2, null);
            }
            catch (CoreException coreException) {
                throw new CodeGeneratorException(coreException.getMessage());
            }
        }
    }

    private void generateCode(Node node, Writer writer, StreamSource streamSource, String string) throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setURIResolver(new URIResolver(){

            @Override
            public Source resolve(String string, String string2) throws TransformerException {
                String string3 = "res/" + string;
                try {
                    InputStream inputStream = CodeGeneratorUtil.openStream(string3);
                    return new StreamSource(inputStream);
                }
                catch (IOException iOException) {
                    logger.error(iOException.getMessage());
                    return null;
                }
            }
        });
        Transformer transformer = transformerFactory.newTransformer(streamSource);
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("method", "text");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setParameter("current_view_name", string);
        if (this.isRMSupportVersion != null) {
            transformer.setParameter("is_version_rm_support", this.isRMSupportVersion);
        }
        if (this.profile != null) {
            transformer.setParameter("profile", this.profile);
        }
        DOMSource dOMSource = new DOMSource(node);
        StreamResult streamResult = new StreamResult(writer);
        transformer.transform(dOMSource, streamResult);
    }
}

