<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:template match="ctxpopupitem">
		<xsl:param name="parent" />
		<xsl:param name="level" select="count(./ancestor::*)-count(//view/ancestor::*)" />
		<xsl:param name="indentation">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level" />
			</xsl:call-template>
		</xsl:param>
		<xsl:param name="indentation1">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level+1" />
			</xsl:call-template>
		</xsl:param>

		<xsl:apply-templates select="*">
			<xsl:with-param name="indentation" select="$indentation" />
			<xsl:with-param name="parent" select="$parent" />
		</xsl:apply-templates>

		<xsl:variable name="callback">
			<xsl:apply-templates select="event" mode="item_event">
				<xsl:with-param name="parent" select="@id" />
				<xsl:with-param name="view" select="./ancestor::view/@id" />
				<!-- Storyboard_START -->
				<xsl:with-param name="target" select="event/@target" />
				<!-- Storyboard_END -->
			</xsl:apply-templates>
		</xsl:variable>
		<xsl:variable name="icon">
			<xsl:apply-templates select="icon" mode="listitem_icon">
				<xsl:with-param name="parent" select="@id" />
				<xsl:with-param name="view" select="./ancestor::view/@id" />
			</xsl:apply-templates>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="string-length($callback) != 0 and string-length($icon) != 0">
				<xsl:choose>
					<xsl:when test="@label">
						<xsl:value-of
							select="concat($indentation, 'vc->', @id, ' = elm_ctxpopup_item_append(vc->', $parent, ', _UIB_LOCALE( &quot;', @label, '&quot;), ', $icon , ', (Evas_Smart_Cb)', $callback, ', vc);', $newline)" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of
							select="concat($indentation, 'vc->', @id, ' = elm_ctxpopup_item_append(vc->', $parent, ', _UIB_LOCALE( &quot;', @text, '&quot;), ', $icon , ', (Evas_Smart_Cb)', $callback, ', vc);', $newline)" />
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="string-length($callback) = 0 and string-length($icon) != 0">
				<xsl:choose>
					<xsl:when test="@label">
						<xsl:value-of
							select="concat($indentation, 'vc->', @id, ' = elm_ctxpopup_item_append(vc->', $parent, ', _UIB_LOCALE( &quot;', @label, '&quot;), ', $icon , ', NULL, NULL);', $newline)" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of
							select="concat($indentation, 'vc->', @id, ' = elm_ctxpopup_item_append(vc->', $parent, ', _UIB_LOCALE( &quot;', @text, '&quot;), ', $icon , ', NULL, NULL);', $newline)" />
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="string-length($callback) != 0 and string-length($icon) = 0">
				<xsl:choose>
					<xsl:when test="@label">
						<xsl:value-of
							select="concat($indentation, 'vc->', @id, ' = elm_ctxpopup_item_append(vc->', $parent, ', _UIB_LOCALE( &quot;', @label, '&quot;), ', 'NULL, (Evas_Smart_Cb)', $callback, ', vc);', $newline)" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of
							select="concat($indentation, 'vc->', @id, ' = elm_ctxpopup_item_append(vc->', $parent, ', _UIB_LOCALE( &quot;', @text, '&quot;), ', 'NULL, (Evas_Smart_Cb)', $callback, ', vc);', $newline)" />
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="@label">
						<xsl:value-of
							select="concat($indentation, 'vc->', @id, ' = elm_ctxpopup_item_append(vc->', $parent, ', _UIB_LOCALE( &quot;', @label, '&quot;), ', 'NULL, NULL, NULL);', $newline)" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of
							select="concat($indentation, 'vc->', @id, ' = elm_ctxpopup_item_append(vc->', $parent, ', _UIB_LOCALE( &quot;', @text, '&quot;), ', 'NULL, NULL, NULL);', $newline)" />
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>
</xsl:stylesheet>
