<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:variable name="newline">
		<xsl:text>
</xsl:text>
	</xsl:variable>
	<xsl:variable name="tab">
		<xsl:text disable-output-escaping="yes">	</xsl:text>
	</xsl:variable>

	<xsl:template match="/">
		<xsl:apply-templates select="//views">
		</xsl:apply-templates>
	</xsl:template>

	<xsl:template match="views">

		<xsl:text disable-output-escaping="yes">
<![CDATA[/*******************************************************************************
* This file was generated by UI Builder.
* This file will be auto-generated each and everytime you save your project.
* Do not hand edit this file.
********************************************************************************/
#include "g_inc_uib.h"
#include "uib_views.h"
#include "uib_view_manager.h"
#include "uib_app_manager.h"

static uib_view_context* g_uib_view_context_list[DEF_UIB_VIEW_MAX_NUM];
static int g_view_context_total_num=0;

static uib_view_manager_st g_uib_view_manager;

int add_view_context(uib_view_context* uib_view_context);
uib_view_context* find_view_context(char* view_name);
void free_all_view_context();

uib_view_manager_st* uib_view_manager_get_instance() {
	if(!g_uib_view_manager._is_init) {
		g_uib_view_manager._is_init = true;
		g_uib_view_manager.add_view_context = &add_view_context;
		g_uib_view_manager.find_view_context = &find_view_context;
		g_uib_view_manager.free_all_view_context = &free_all_view_context;
	}
	return &g_uib_view_manager;
}

static int find_view_index(const char* view_name) {
	int i=0;

	for(i=0; i < g_view_context_total_num; i++) {
		if(!strcmp(view_name, g_uib_view_context_list[i]->view_name))
			return i;
	}
	return -1; // find failed
}

int add_view_context(uib_view_context* vc) {
	// check conflict the view_name
	if(uib_views_get_instance()->get_total_hit_num(vc) > 0) {
		UIB_DLOG(DLOG_ERROR, LOG_TAG, "This view is already exists. Conflicted view name is '%s'\n", vc->view_name);
		return -1;
	}

	int i = find_view_index(vc->view_name);

	evas_object_data_set(vc->root_container, KEY_VIEW_VC_SAVE, vc);
	if(i < 0) {
		if(g_view_context_total_num < DEF_UIB_VIEW_MAX_NUM) {
			g_uib_view_context_list[g_view_context_total_num] = vc;
			g_view_context_total_num++;
			return 0;
		}
		else {
			UIB_DLOG(DLOG_ERROR, LOG_TAG, "It was failed to create the view. Too many views exist. '%d'\n", g_view_context_total_num);
			return -1;
		}
	}
	else { // overwrite
		g_uib_view_context_list[i] = vc;
	}
	return 0;
}

uib_view_context* find_view_context(char* view_name) {
	int i=0;

	for(i=0; i < g_view_context_total_num; i++) {
		if(!strcmp(view_name, g_uib_view_context_list[i]->view_name)) {
			return g_uib_view_context_list[i];
		}
	}
	return NULL; // find failed
}

void free_all_view_context() {
	int i=0;

	for(i=0; i < g_view_context_total_num; i++) {
		if(g_uib_view_context_list[i])
			free(g_uib_view_context_list[i]);
	}
}
]]>
</xsl:text>

	</xsl:template>
</xsl:stylesheet>
