<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:exslt="http://exslt.org/common">
	<xsl:template match="label">
		<xsl:param name="parent" />
		<xsl:param name="view_configuration_id" />
		<xsl:param name="level" select="count(./ancestor::*)-count(//view/ancestor::*)" />
		<xsl:param name="indentation">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level" />
			</xsl:call-template>
		</xsl:param>
		<xsl:param name="indentation1">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level+1" />
			</xsl:call-template>
		</xsl:param>
		<xsl:value-of select="concat($indentation, 'if (!vc->', @id, ') {', $newline)" />
		<xsl:value-of select="concat($indentation1, 'vc->', @id, ' = elm_label_add(vc->', $parent, ');', $newline)" />
		<xsl:value-of select="concat($indentation,'}', $newline)" />
		<xsl:value-of select="concat($indentation, 'if(vc->', @id, ') {', $newline)" />

		<xsl:call-template name="size_hint_align_set">
			<xsl:with-param name="align_h" select="@align_h" />
			<xsl:with-param name="align_v" select="@align_v" />
			<xsl:with-param name="indentation" select="$indentation1" />
			<xsl:with-param name="id" select="@id" />
		</xsl:call-template>

		<xsl:call-template name="size_hint_weight_set">
			<xsl:with-param name="weight_h" select="@weight_h" />
			<xsl:with-param name="weight_v" select="@weight_v" />
			<xsl:with-param name="indentation" select="$indentation1" />
			<xsl:with-param name="id" select="@id" />
		</xsl:call-template>

		<xsl:if test="string-length(@text) != 0">
			<xsl:value-of select="concat($indentation1, 'elm_object_text_set(vc->', @id, ',_UIB_LOCALE(', '&quot;', @text, '&quot;', '));', $newline)" />
		</xsl:if>

		<xsl:call-template name="style">
			<xsl:with-param name="style" select="@style" />
			<xsl:with-param name="indentation" select="$indentation1" />
			<xsl:with-param name="id" select="@id" />
		</xsl:call-template>

		<xsl:if test="string-length(@line_wrap) != 0">
			<xsl:variable name="rconv_key" select="concat('line_wrap', ':', @line_wrap)" />
			<xsl:variable name="rconv_value" select="exslt:node-set($value_map)//entry[@key=$rconv_key]" />
			<xsl:choose>
				<xsl:when test="string-length($rconv_value) != 0">
					<xsl:value-of select="concat($indentation1, 'elm_label_line_wrap_set(vc->', @id, ', (Elm_Wrap_Type)', $rconv_value, ');', $newline)" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="concat($indentation1, 'elm_label_line_wrap_set(vc->', @id, ', ', @line_wrap, ');', $newline)" />
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:if test="string-length(@wrap_width) != 0">
			<xsl:value-of select="concat($indentation1, 'elm_label_wrap_width_set(vc->', @id, ',', @wrap_width, ');', $newline)" />
		</xsl:if>
		<xsl:if test="string-length(@ellipsis) != 0">
			<xsl:if test="@ellipsis = 'true'">
				<xsl:value-of select="concat($indentation1, 'elm_label_ellipsis_set(vc->', @id, ', EINA_TRUE);', $newline)" />
			</xsl:if>
			<xsl:if test="@ellipsis = 'false'">
				<xsl:value-of select="concat($indentation1, 'elm_label_ellipsis_set(vc->', @id, ', EINA_FALSE);', $newline)" />
			</xsl:if>
		</xsl:if>
		<xsl:if test="string-length(@duration) != 0">
			<xsl:value-of select="concat($indentation1, 'elm_label_slide_duration_set(vc->', @id, ',', @duration, ');', $newline)" />
		</xsl:if>
		<xsl:if test="@disable = 'true'">
			<xsl:value-of select="concat($indentation1, 'elm_object_disabled_set(vc->', @id, ', EINA_TRUE);', $newline)" />
		</xsl:if>
		<xsl:apply-templates mode="visible" select="current()">
			<xsl:with-param name="parent" select="@id" />
			<xsl:with-param name="view_configuration_id" select="$view_configuration_id" />
		</xsl:apply-templates>
		<xsl:value-of select="concat($indentation,'}', $newline)" />
	</xsl:template>
</xsl:stylesheet>
