/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.efluibuilder.internal.connector;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.util.Assert;
import org.tizen.efluibuilder.internal.connector.IService;
import org.tizen.efluibuilder.internal.connector.Service;

public final class ServiceFactory {
    private static final String VERSION_2_3 = "2.3";
    private static final String VERSION_2_3_1 = "2.3.1";
    private static final String VERSION_2_3_2 = "2.3.2";
    private static final String VERSION_2_4 = "2.4";
    private static final String VERSION_3_0 = "3.0";
    private static final String VERSION_4_0 = "4.0";
    private static final String PROFILE_MOBILE = "mobile";
    private static final String PROFILE_WEARABLE = "wearable";
    private static final String PROFILE_WEARABLE_CIRCLE = "wearable-circle";
    private static final String PROFILE_TV = "tv";
    private static final String SERVICE_DIRECTORY_2_3 = "/platforms/tizen-2.3/common/efl-tool/efl-renderer/";
    private static final String SERVICE_DIRECTORY_2_3_1 = "/platforms/tizen-2.3.1/common/efl-tool/efl-renderer/";
    private static final String SERVICE_DIRECTORY_2_3_2 = "/platforms/tizen-2.3.2/common/efl-tool/efl-renderer/";
    private static final String SERVICE_DIRECTORY_2_4 = "/platforms/tizen-2.4/common/efl-tool/efl-renderer/";
    private static final String SERVICE_DIRECTORY_3_0 = "/platforms/tizen-3.0/common/efl-tool/efl-renderer/";
    private static final String SERVICE_DIRECTORY_3_0_wearable = "/platforms/tizen-3.0/wearable/efl-tool/efl-renderer/";
    private static final String SERVICE_DIRECTORY_4_0 = "/platforms/tizen-4.0/common/efl-tool/efl-renderer/";
    private static final String SERVICE_DIRECTORY_4_0_wearable = "/platforms/tizen-4.0/wearable/efl-tool/efl-renderer/";
    private static final String SERVICE_BINARY_LINUX = "efl-renderer.sh";
    private static final String SERVICE_BINARY_WINDOWS = "efl-renderer.bat";
    private static final String SERVICE_BINARY_MACOS = "efl-renderer-macos.sh";
    private static ServiceFactory instance = null;
    private Map<String, String> pathTable = new HashMap<String, String>();
    private Map<String, IService> services = new HashMap<String, IService>();

    public static synchronized ServiceFactory getDefault() {
        if (instance == null) {
            instance = new ServiceFactory();
        }
        return instance;
    }

    private ServiceFactory() {
        this.createTable();
    }

    private String createId(String string, String string2) {
        String string3 = String.valueOf(string) + "-" + string2;
        return string3;
    }

    private void createTable() {
        String string = InstallPathConfig.getSDKPath();
        String string2 = this.getBinary();
        String string3 = String.valueOf(string) + SERVICE_DIRECTORY_2_3 + string2;
        String string4 = "2.3-mobile";
        this.pathTable.put(string4, string3);
        string3 = String.valueOf(string) + SERVICE_DIRECTORY_2_3_1 + string2;
        string4 = "2.3.1-mobile";
        this.pathTable.put(string4, string3);
        string4 = "2.3.1-wearable";
        this.pathTable.put(string4, string3);
        string4 = "2.3.1-wearable-circle";
        this.pathTable.put(string4, string3);
        string3 = String.valueOf(string) + SERVICE_DIRECTORY_2_3_2 + string2;
        string4 = "2.3.2-wearable-circle";
        this.pathTable.put(string4, string3);
        string3 = String.valueOf(string) + SERVICE_DIRECTORY_2_4 + string2;
        string4 = "2.4-mobile";
        this.pathTable.put(string4, string3);
        string3 = String.valueOf(string) + SERVICE_DIRECTORY_3_0 + string2;
        string4 = "3.0-mobile";
        this.pathTable.put(string4, string3);
        string4 = "3.0-tv";
        this.pathTable.put(string4, string3);
        string3 = String.valueOf(string) + SERVICE_DIRECTORY_3_0_wearable + string2;
        string4 = "3.0-wearable-circle";
        this.pathTable.put(string4, string3);
        string3 = String.valueOf(string) + SERVICE_DIRECTORY_4_0 + string2;
        string4 = "4.0-mobile";
        this.pathTable.put(string4, string3);
        string3 = String.valueOf(string) + SERVICE_DIRECTORY_4_0_wearable + string2;
        string4 = "4.0-wearable-circle";
        this.pathTable.put(string4, string3);
    }

    private String getBinary() {
        String string = Platform.getOS();
        String string2 = null;
        if (string.equals("linux")) {
            string2 = SERVICE_BINARY_LINUX;
        } else if (string.equals("win32")) {
            string2 = SERVICE_BINARY_WINDOWS;
        } else if (string.equals("macosx")) {
            string2 = SERVICE_BINARY_MACOS;
        }
        return string2;
    }

    IService create(String string, String string2) {
        Assert.notNull((Object)string);
        Assert.notNull((Object)string2);
        String string3 = this.createId(string, string2);
        String string4 = this.pathTable.get(string3);
        Assert.notNull((Object)string4, (String)("Service path not found : " + string3));
        Service service = new Service(string3, string4, string2);
        this.services.put(string3, service);
        return service;
    }

    void destroy(String string) {
        IService iService = this.services.get(string);
        Assert.notNull((Object)iService, (String)("Service not found : " + string));
        iService.stop();
    }
}

