/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.efluibuilder.descriptor.util;

import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class DeepClone {
    private DeepClone() {
    }

    public static <X> X deepClone(X x) {
        if (x == null) {
            return x;
        }
        if (x instanceof Map) {
            return (X)DeepClone.deepCloneMap((Map)x);
        }
        if (x instanceof List) {
            return (X)DeepClone.deepCloneList((List)x);
        }
        if (x instanceof Object[]) {
            return (X)DeepClone.deepCloneObjectArray((Object[])x);
        }
        if (x.getClass().isArray()) {
            return (X)DeepClone.clonePrimitiveArray(x);
        }
        return x;
    }

    private static Object clonePrimitiveArray(Object object) {
        int n = Array.getLength(object);
        Object object2 = Array.newInstance(object.getClass().getComponentType(), n);
        System.arraycopy(object, 0, object2, 0, n);
        return object2;
    }

    private static <E> E[] deepCloneObjectArray(E[] EArray) {
        Object[] objectArray = (Object[])Array.newInstance(EArray.getClass().getComponentType(), EArray.length);
        int n = 0;
        while (n < EArray.length) {
            objectArray[n] = DeepClone.deepClone(EArray[n]);
            ++n;
        }
        return objectArray;
    }

    private static <E> List<E> deepCloneList(List<E> list) {
        AbstractList abstractList = list instanceof LinkedList ? new LinkedList() : new ArrayList();
        for (E e : list) {
            abstractList.add(DeepClone.deepClone(e));
        }
        return abstractList;
    }

    private static <K, V> Map<K, V> deepCloneMap(Map<K, V> map) {
        AbstractMap abstractMap = map instanceof LinkedHashMap ? new LinkedHashMap() : (map instanceof TreeMap ? new TreeMap() : new HashMap());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            abstractMap.put(DeepClone.deepClone(entry.getKey()), DeepClone.deepClone(entry.getValue()));
        }
        return abstractMap;
    }
}

