<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:template name="popup.comment">
		/*******************************************************************************
		* This file was generated by UI Builder.
		* This file will be auto-generated
		each and everytime you save your project.
		* Do not hand edit this file.
		********************************************************************************/
	</xsl:template>
	<xsl:template name="popup.include">
		<xsl:value-of select="concat('&#35;', 'include ', '&#34;', 'app_main.h', '&#34;')" />
		<xsl:value-of select="$newline" />
		<xsl:value-of select="$newline" />
	</xsl:template>

	<xsl:template name="popup.eventhandler_declaration">
		<xsl:param name="parent"></xsl:param>
		<xsl:value-of select="concat('&#47;&#42;',' event handler declarations ','&#42;&#47;')" />

		<xsl:value-of select="$newline" />
		<xsl:apply-templates select="event/@*" mode="declaration">
			<xsl:with-param name="level">
				<xsl:value-of select="0" />
			</xsl:with-param>
			<xsl:with-param name="parent" select="@id" />
			<xsl:with-param name="view" select="@id" />
		</xsl:apply-templates>
		<xsl:apply-templates select="*" mode="popup.event.declaration" />
		<xsl:value-of select="$newline" />
	</xsl:template>

	<xsl:template match="*" mode="popup.event.declaration">
		<xsl:apply-templates select="event/@*" mode="declaration">
			<xsl:with-param name="level">
				<xsl:value-of select="0" />
			</xsl:with-param>
			<xsl:with-param name="parent" select="@id" />
			<xsl:with-param name="view" select="./ancestor::tizen.popup/@id" />
		</xsl:apply-templates>
		<xsl:apply-templates select="*" mode="popup.event.declaration" />
	</xsl:template>

	<xsl:template match="*" mode="popup.event.registration">
		<xsl:apply-templates select="event/@*" mode="registration">
			<xsl:with-param name="parent" select="@id" />
			<xsl:with-param name="view" select="./ancestor::tizen.popup/@id" />
		</xsl:apply-templates>

		<xsl:apply-templates select="*" mode="popup.event.registration" />
	</xsl:template>

	<xsl:template name="popup.create_popup">
		<xsl:param name="parent" />
		<xsl:param name="viewName" />
		<xsl:param name="indicator" />
		<xsl:param name="level" />
		<xsl:param name="indentation" />
		<xsl:param name="indentation1" />

		<xsl:value-of
			select="concat($indentation, 'uib_view_context','&#42;',' uib_', $parent, '_view_create(Evas_Object','&#42;',' parent, void','&#42;',' create_callback_param) {', $newline)" />

		<xsl:if test="string-length(@indicator) != 0">
			<xsl:choose>
				<xsl:when test="@indicator='false'">
					<xsl:value-of select="concat($indentation1, 'elm_win_indicator_mode_set(get_window(parent), ELM_WIN_INDICATOR_HIDE);', $newline)" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="concat($indentation1, 'elm_win_indicator_mode_set(get_window(parent), ELM_WIN_INDICATOR_SHOW);', $newline)" />
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>

		<xsl:value-of select="concat($indentation1, 'uib_', $parent, '_view_context','&#42;',' vc = calloc(1, sizeof(uib_', $parent, '_view_context));', $newline)" />

		<xsl:value-of select="concat($indentation1, 'vc->parent = parent;', $newline)" />

		<xsl:value-of select="concat($indentation1, 'vc->view_name = &#34;', $viewName,'&#34;;', $newline)" />

		<xsl:if test="string-length(@file) != 0">
			<xsl:value-of select="concat($indentation1, 'elm_bg_file_set(', @id, ',', '&quot;', @file, '&quot;', ');', $newline)" />
		</xsl:if>


		<xsl:if test="string-length(@option) != 0">
			<xsl:choose>
				<xsl:when test="string(number(@option)) = 'NaN'">
					<xsl:value-of select="concat($indentation1, 'elm_bg_option_set(', @id, ', ', @option, ');', $newline)" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="concat($indentation1, 'elm_bg_option_set(', @id, ', (Elm_Bg_Option)', @option, ');', $newline)" />
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>


		<xsl:if test="string-length(@load_size_width) != 0 and string-length(@load_size_height) != 0">
			<xsl:value-of select="concat($indentation1, 'elm_bg_load_size_set(', @id, ',', @load_size_width, ',', @load_size_height, ');', $newline)" />
		</xsl:if>

		<xsl:apply-templates select="*">
			<xsl:with-param name="parent" select="@id" />
			<xsl:with-param name="fromView" select="'true'" />
		</xsl:apply-templates>

		<xsl:value-of select="concat($indentation1, '//bind event handler', $newline)" />
		<!-- evas_object_smart_callback_add(vc->root_container, KEY_VIEW_CREATE, (Evas_Smart_Cb)on_<xsl:value-of select="$parent" />_create, vc); evas_object_smart_callback_add(vc->root_container, 
			KEY_VIEW_DESTROY, (Evas_Smart_Cb)on_<xsl:value-of select="$parent" />_destroy, vc); -->
		<xsl:apply-templates select="event/@*" mode="registration">
			<xsl:with-param name="parent" select="'root_container'" />
			<xsl:with-param name="view" select="@id" />
		</xsl:apply-templates>
		<xsl:apply-templates select="*" mode="popup.event.registration" />

		<xsl:value-of select="$newline" />
		<xsl:value-of select="$newline" />
		<xsl:value-of select="concat($indentation1, 'evas_object_data_set(vc->root_container, KEY_VIEW_CONTEXT, vc);', $newline)" />
		<!-- evas_object_event_callback_add(vc->root_container, EVAS_CALLBACK_DEL, (Evas_Object_Event_Cb)uib_view_destroy_callback, vc); uib_view_create_callback(vc, evas_object_evas_get(vc->root_container), 
			vc->root_container, create_callback_param); <xsl:if test="string-length(*[1]/@id) != 0"> evas_object_show(vc-><xsl:value-of select="*[1]/@id" />); </xsl:if> -->
		<xsl:value-of select="concat($indentation1, 'return (uib_view_context*)vc;', $newline)" />

		<xsl:value-of select="concat($indentation, '}', $newline)" />
	</xsl:template>

	<xsl:template match="popup">
		<xsl:param name="parent" />
		<!-- FIXME -->
		<xsl:param name="viewName" />
		<xsl:param name="level" select="count(./ancestor::*)-count(//view/ancestor::*)" />
		<xsl:param name="indentation">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level" />
			</xsl:call-template>
		</xsl:param>
		<xsl:param name="indentation1">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level+1" />
			</xsl:call-template>
		</xsl:param>
		<xsl:call-template name="popup.comment" />
		<xsl:call-template name="popup.include" />
		<xsl:call-template name="popup.eventhandler_declaration">
			<xsl:with-param name="parent" select="@id" />
		</xsl:call-template>
		<xsl:call-template name="popup.create_popup">
			<xsl:with-param name="parent" select="@id" />
			<xsl:with-param name="level" select="$level" />
			<xsl:with-param name="indentation" select="$indentation" />
			<xsl:with-param name="indentation1" select="$indentation1" />
			<xsl:with-param name="viewName" select="@id" />
			<xsl:with-param name="indicator" select="@indicator" />
			<!-- FIXME <xsl:with-param name="viewName" select="@data-title" /> -->
		</xsl:call-template>
	</xsl:template>

</xsl:stylesheet>
