<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:template match="*" mode="table.pack">
		<xsl:param name="parent" />
		<xsl:param name="view_configuration_id" />
		<xsl:param name="is_version_rm_support" />
		<xsl:param name="profile" />
		<xsl:param name="level" select="count(./ancestor::*)-count(//view/ancestor::*)" />
		<xsl:variable name="widget_id" select="@id" />
		<xsl:param name="indentation">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level" />
			</xsl:call-template>
		</xsl:param>
		<xsl:choose>
			<xsl:when test="name()='variation'" />
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="count(./variation[@config_ref=$view_configuration_id]) > 0">
						<xsl:for-each select="./variation[@config_ref=$view_configuration_id]">
							<xsl:value-of
								select="concat($indentation, 'elm_table_pack(vc->', $parent, ', vc->', $widget_id, ', ', @pack_col, ', ', @pack_row, ', ', @col_span, ', ', @row_span, ');', 					'&#xD;'
										)" />
						</xsl:for-each>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of
							select="concat($indentation, 'elm_table_pack(vc->', $parent, ', vc->', $widget_id, ', ', @pack_col, ', ', @pack_row, ', ', @col_span, ', ', @row_span, ');', 					'&#xD;'
								)" />
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="table">
		<xsl:param name="parent" />
		<xsl:param name="fromView" />
		<xsl:param name="view_configuration_id" />
		<xsl:param name="is_version_rm_support" />
		<xsl:param name="level" select="count(./ancestor::*)-count(//view/ancestor::*)" />
		<xsl:param name="indentation">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level" />
			</xsl:call-template>
		</xsl:param>
		<xsl:param name="indentation1">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level+1" />
			</xsl:call-template>
		</xsl:param>
		<xsl:choose>
			<xsl:when test="$fromView = 'true'">
				<xsl:call-template name="dup">
					<xsl:with-param name="input" select="$indent" />
					<xsl:with-param name="count" select="$level" />
				</xsl:call-template>
				<xsl:value-of select="concat($indentation, 'if (!vc->', @id, ') {', $newline)" />
				<xsl:value-of select="concat($indentation1, 'vc->', @id, '= elm_table_add(parent);', $newline)" />
				<xsl:value-of select="concat($indentation1, 'vc->root_container = vc->', @id, ';', $newline)" />
				<xsl:value-of select="concat($indentation,'}', $newline)" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:if test="string-length($fromView) = 0">
					<xsl:value-of select="concat($indentation, 'if (!vc->', @id, ') {', $newline)" />
					<xsl:value-of select="concat($indentation1, 'vc->', @id, '= elm_table_add(vc->', $parent, ');', $newline)" />
					<xsl:value-of select="concat($indentation,'}', $newline)" />
				</xsl:if>
				<xsl:value-of select="$indentation" />
				<xsl:value-of select="concat('if(vc->', @id, ') {')" />
				<xsl:value-of select="$newline" />
				<xsl:value-of select="concat($indentation1, 'Evas_Object *ph_', @id, ';', $newline)" />
				<xsl:value-of select="concat($indentation1, 'for (int i=0; i &lt;', @rows, '; i++) {', $newline)" />
				<xsl:value-of select="concat($indentation1, $indent, 'for (int j=0; j &lt;', @cols, '; j++) {', $newline)" />
				<xsl:value-of select="concat($indentation1, $indent, $indent, 'ph_', @id, '= evas_object_rectangle_add(evas_object_evas_get(vc->', @id, '));', $newline)" />
				<xsl:value-of select="concat($indentation1, $indent, $indent, 'evas_object_size_hint_weight_set( ph_', @id, ', EVAS_HINT_EXPAND, EVAS_HINT_EXPAND );', $newline)" />
				<xsl:value-of select="concat($indentation1, $indent, $indent, 'evas_object_size_hint_align_set( ph_', @id, ', EVAS_HINT_FILL, EVAS_HINT_FILL );', $newline)" />
				<xsl:value-of select="concat($indentation1, $indent, $indent, 'evas_object_hide(ph_', @id, ');', $newline)" />
				<xsl:value-of select="concat($indentation1, $indent, $indent, 'elm_table_pack(vc->', @id, ', ph_', @id, ', j, i, 1, 1);', $newline)" />
				<xsl:value-of select="concat($indentation1, $indent, '}', $newline)" />
				<xsl:value-of select="concat($indentation1, '}', $newline)" />

				<xsl:choose>
					<xsl:when test="@homogeneous='true'">
						<xsl:value-of select="concat($indentation1, 'elm_table_homogeneous_set(vc->', @id, ', EINA_TRUE);')" />
						<xsl:value-of select="$newline" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="concat($indentation1, 'elm_table_homogeneous_set(vc->', @id, ', EINA_FALSE);')" />
						<xsl:value-of select="$newline" />
					</xsl:otherwise>
				</xsl:choose>
				<xsl:choose>
					<xsl:when test="string-length(@padding_h) != 0 and string-length(@padding_v) != 0">
						<xsl:value-of select="$indentation1" />
						<xsl:value-of select="concat('elm_table_padding_set(vc->', @id, ',', @padding_h, ',', @padding_v, ');', $newline)" />
					</xsl:when>
					<xsl:otherwise>
					</xsl:otherwise>
				</xsl:choose>

				<xsl:call-template name="size_hint_align_set">
					<xsl:with-param name="align_h" select="@align_h" />
					<xsl:with-param name="align_v" select="@align_v" />
					<xsl:with-param name="indentation" select="$indentation1" />
					<xsl:with-param name="id" select="@id" />
				</xsl:call-template>
				<xsl:value-of select="$newline" />

				<xsl:call-template name="size_hint_weight_set">
					<xsl:with-param name="weight_h" select="@weight_h" />
					<xsl:with-param name="weight_v" select="@weight_v" />
					<xsl:with-param name="indentation" select="$indentation1" />
					<xsl:with-param name="id" select="@id" />
				</xsl:call-template>
				<xsl:value-of select="$newline" />

				<xsl:apply-templates select="*">
					<xsl:with-param name="parent" select="@id" />
					<xsl:with-param name="view_configuration_id" select="$view_configuration_id" />
					<xsl:with-param name="is_version_rm_support" select="$is_version_rm_support" />
					<xsl:with-param name="profile" select="$profile" />
				</xsl:apply-templates>

				<xsl:apply-templates mode="table.pack" select="*">
					<xsl:with-param name="parent" select="@id" />
					<xsl:with-param name="view_configuration_id" select="$view_configuration_id" />
					<xsl:with-param name="is_version_rm_support" select="$is_version_rm_support" />
				</xsl:apply-templates>

				<xsl:apply-templates mode="visible" select="current()">
					<xsl:with-param name="parent" select="@id" />
					<xsl:with-param name="view_configuration_id" select="$view_configuration_id" />
				</xsl:apply-templates>

				<xsl:value-of select="concat($indentation,'}', $newline)" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
