/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.efluibuilder.model.descriptors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.tizen.efluibuilder.model.descriptors.WidgetDescriptor;

public class ContentDescriptor {
    private PartType descriptorType = PartType.ANY_PART;
    private List<String> descriptorIds = new ArrayList<String>();
    private int min = 0;
    private int max = 9999;
    private String exclusiveGroup = null;

    public List<String> getPartIds() {
        return this.descriptorIds;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public String getExclusiveGroup() {
        return this.exclusiveGroup;
    }

    public void setPartType(PartType partType) {
        this.descriptorType = partType;
    }

    public void setPartIds(String string) {
        if (string == null || string.isEmpty()) {
            return;
        }
        String[] stringArray = string.split(",");
        this.descriptorIds = Arrays.asList(stringArray);
    }

    public void setMin(int n) {
        this.min = n;
    }

    public void setMax(int n) {
        this.max = n;
    }

    public void setExclusiveGroup(String string) {
        this.exclusiveGroup = string;
    }

    public boolean isMatch(WidgetDescriptor widgetDescriptor) {
        boolean bl = false;
        switch (this.descriptorType) {
            case ANY_PART: {
                bl = true;
                break;
            }
            case DOCUMENT_PART: {
                bl = widgetDescriptor.getDescriptorType() == WidgetDescriptor.DescriptorType.DOC;
                break;
            }
            case PAGE_PART: {
                bl = widgetDescriptor.getDescriptorType() == WidgetDescriptor.DescriptorType.PAGE;
                break;
            }
            case WIDGET_PART: {
                bl = widgetDescriptor.getDescriptorType() == WidgetDescriptor.DescriptorType.WIDGET;
                break;
            }
        }
        if (!bl) {
            return false;
        }
        boolean bl2 = false;
        if (this.descriptorIds.isEmpty()) {
            bl2 = true;
        } else {
            for (String string : this.descriptorIds) {
                if (!string.equals(widgetDescriptor.getDescriptorId())) continue;
                bl2 = true;
                break;
            }
        }
        return bl2;
    }

    public boolean isMatch(WidgetDescriptor widgetDescriptor, int n) {
        if (!this.isMatch(widgetDescriptor)) {
            return false;
        }
        boolean bl = false;
        bl = this.max == 0 ? true : n < this.max;
        return bl;
    }

    public static enum PartType {
        ANY_PART,
        DOCUMENT_PART,
        PAGE_PART,
        WIDGET_PART;

    }
}

