/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.efluibuilder.internal.connector;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.efluibuilder.internal.connector.IService;
import org.tizen.efluibuilder.internal.renderer.util.DebugUtil;

public final class Service
implements IService {
    private Logger logger = LoggerFactory.getLogger(Service.class);
    private static final String SERVICE_IP = "127.0.0.1";
    private static final int SERVICE_PORT = 18216;
    private static final String MESSAGE_PORT = "NUIB-CMD-PORT:";
    private static final String MESSAGE_LISTEN = "NUIB-CMD-LISTEN";
    private static final String MESSAGE_ACCEPT = "NUIB-CMD-ACCEPT";
    private static int TCP_HANDSHAKE_TIMEOUT = 30000;
    private String id = null;
    private String profile = null;
    private int port = 18216;
    private String path = null;
    private Process process = null;
    private final Object lock = new Object();
    public boolean isConnected = false;
    private ServiceThread thread = null;

    Service(String string, String string2, String string3) {
        this.id = string;
        this.path = string2;
        this.profile = string3;
        this.start();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getIp() {
        return SERVICE_IP;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start() {
        this.thread = new ServiceThread();
        this.thread.setName(this.id);
        this.thread.start();
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                Service.this.stop();
            }
        }));
        Object object = this.lock;
        synchronized (object) {
            if (!this.isConnected) {
                try {
                    this.logger.debug("wait connection");
                    this.lock.wait(TCP_HANDSHAKE_TIMEOUT);
                    this.logger.debug("connected");
                }
                catch (InterruptedException interruptedException) {
                    if (this.thread != null) {
                        this.thread.interrupt();
                        this.thread = null;
                    }
                    this.logger.error(interruptedException.getMessage());
                }
            }
        }
    }

    @Override
    public void stop() {
        if (this.process != null) {
            this.process.destroy();
        }
    }

    private class ServiceThread
    extends Thread {
        private ServiceThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(Service.this.path);
            ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
            Map<String, String> map = processBuilder.environment();
            map.put("ELM_PROFILE", Service.this.profile);
            try {
                Service.this.process = processBuilder.start();
                Service.this.process.getOutputStream().close();
                Service.this.process.getErrorStream().close();
                InputStream inputStream = Service.this.process.getInputStream();
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    String[] stringArray;
                    if (string.contains(Service.MESSAGE_PORT)) {
                        string = string.replace("[", "");
                        stringArray = (string = string.replace("]", "")).split(Service.MESSAGE_PORT);
                        if (stringArray == null || stringArray.length <= 0) continue;
                        Service.this.port = Integer.parseInt(stringArray[1]);
                        continue;
                    }
                    if (string.contains(Service.MESSAGE_LISTEN)) {
                        stringArray = Service.this.lock;
                        synchronized (stringArray) {
                            Service.this.isConnected = true;
                            Service.this.lock.notifyAll();
                            continue;
                        }
                    }
                    if (string.contains(Service.MESSAGE_ACCEPT)) continue;
                    DebugUtil.debug(Service.this.logger, string);
                }
                int n = Service.this.process.waitFor();
                DebugUtil.debug(Service.this.logger, "child process exit : " + n);
            }
            catch (IOException iOException) {
                Object object = Service.this.lock;
                synchronized (object) {
                    Service.this.lock.notifyAll();
                }
                DebugUtil.debug(Service.this.logger, this.getClass().getName(), iOException);
            }
            catch (InterruptedException interruptedException) {
                DebugUtil.debug(Service.this.logger, this.getClass().getName(), interruptedException);
            }
            catch (RuntimeException runtimeException) {
                Object object = Service.this.lock;
                synchronized (object) {
                    Service.this.lock.notifyAll();
                }
                DebugUtil.debug(Service.this.logger, this.getClass().getName(), runtimeException);
            }
        }
    }
}

