<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:template match="datetime">
		<xsl:param name="parent" />
		<xsl:param name="view_configuration_id" />
		<xsl:param name="profile" />
		<xsl:param name="level" select="count(./ancestor::*)-count(//view/ancestor::*)" />
		<xsl:param name="indentation">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level" />
			</xsl:call-template>
		</xsl:param>
		<xsl:param name="indentation1">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level+1" />
			</xsl:call-template>
		</xsl:param>

		<xsl:value-of select="concat($indentation, 'if (!vc->', @id, ') {', $newline)" />
		<xsl:value-of select="concat($indentation1, 'vc->', @id, '= elm_datetime_add(vc->',$parent,');', $newline)" />

		<xsl:if test="$profile='wearable-circle'">
			<xsl:value-of
				select="concat($indentation1, 'vc->circle_object_', @id, '= eext_circle_object_datetime_add(vc->', @id, ', uib_views_get_instance()->get_window_obj()->circle_surface);', $newline)" />
			<xsl:value-of select="concat($indentation1, 'eext_rotary_object_event_activated_set(vc->circle_object_', @id, ', EINA_TRUE);', $newline)" />
		</xsl:if>
		<xsl:value-of select="concat($indentation,'}', $newline)" />
		<xsl:value-of select="concat($indentation, 'if(vc->', @id, ') {', $newline)" />

		<xsl:if test="string-length(@style) != 0">
			<xsl:call-template name="style">
				<xsl:with-param name="style" select="@style" />
				<xsl:with-param name="indentation" select="$indentation1" />
				<xsl:with-param name="id" select="@id" />
			</xsl:call-template>
			<xsl:choose>
				<xsl:when test="@style='date_layout'">
					<xsl:value-of select="concat($indentation1, 'elm_datetime_format_set(vc->', @id, ',&quot;%d/%b/%Y/ %I:%M %p&quot;);', $newline)" />
				</xsl:when>
				<xsl:when test="@style='time_layout'">
					<xsl:value-of select="concat($indentation1, 'elm_datetime_format_set(vc->', @id, ',&quot;%d/%b/%Y/ %I:%M %p&quot;);', $newline)" />
				</xsl:when>
				<xsl:when test="@style='time_layout_24hr'">
					<xsl:value-of select="concat($indentation1, 'elm_datetime_format_set(vc->', @id, ',&quot;%d/%b/%Y/ %H:%M %p&quot;);', $newline)" />
				</xsl:when>
				<xsl:when test="@style='datepicker/circle'">
					<xsl:value-of select="concat($indentation1, 'elm_datetime_format_set(vc->', @id, ',&quot;%d/%b/%Y%I:%M%p&quot;);', $newline)" />
				</xsl:when>
				<xsl:when test="@style='timepicker/circle'">
					<xsl:value-of select="concat($indentation1, 'elm_datetime_format_set(vc->', @id, ',&quot;%d/%b/%Y%I:%M%p&quot;);', $newline)" />
				</xsl:when>
			</xsl:choose>
		</xsl:if>

		<xsl:choose>
			<xsl:when test="string-length(@year) = 0 and string-length(@month) = 0 and string-length(@date) = 0 and string-length(@hour) = 0 and string-length(@minute) = 0">
			</xsl:when>
			<xsl:otherwise>

				<xsl:value-of select="concat($indentation1, 'time_t local_time = time(NULL);', $newline)" />
				<xsl:value-of select="concat($indentation1, 'struct tm ', @id, ';', $newline)" />
				<xsl:value-of select="concat($indentation1, 'struct tm *', @id, '_info = localtime(&amp;local_time);', $newline)" />
				<xsl:value-of select="concat($indentation1, @id , ' = *', @id, '_info;', $newline)" />
				<xsl:if test="string-length(@year) != 0">
					<xsl:value-of select="concat($indentation1, @id, '.tm_year = ', @year, '-1900;', $newline)" />
				</xsl:if>
				<xsl:if test="string-length(@month) != 0">
					<xsl:value-of select="concat($indentation1, @id, '.tm_mon = ', @month, '-1;', $newline)" />
				</xsl:if>
				<xsl:if test="string-length(@date) != 0">
					<xsl:value-of select="concat($indentation1, @id, '.tm_mday = ', @date, ';', $newline)" />
				</xsl:if>
				<xsl:if test="string-length(@hour) != 0">
					<xsl:value-of select="concat($indentation1, @id, '.tm_hour = ', @hour, ';', $newline)" />
				</xsl:if>
				<xsl:if test="string-length(@minute) != 0">
					<xsl:value-of select="concat($indentation1, @id, '.tm_min = ', @minute, ';', $newline)" />
				</xsl:if>
				<xsl:value-of select="concat($indentation1, 'elm_datetime_value_set(vc->' , @id, ', &amp;' , @id, ');', $newline)" />
			</xsl:otherwise>
		</xsl:choose>
		<xsl:call-template name="size_hint_align_set">
			<xsl:with-param name="align_h" select="@align_h" />
			<xsl:with-param name="align_v" select="@align_v" />
			<xsl:with-param name="indentation" select="$indentation1" />
			<xsl:with-param name="id" select="@id" />
		</xsl:call-template>
		<xsl:value-of select="$newline" />

		<xsl:call-template name="size_hint_weight_set">
			<xsl:with-param name="weight_h" select="@weight_h" />
			<xsl:with-param name="weight_v" select="@weight_v" />
			<xsl:with-param name="indentation" select="$indentation1" />
			<xsl:with-param name="id" select="@id" />
		</xsl:call-template>
		<xsl:value-of select="$newline" />

		<xsl:call-template name="disable">
			<xsl:with-param name="disable" select="@disable" />
			<xsl:with-param name="indentation" select="$indentation1" />
			<xsl:with-param name="id" select="@id" />
		</xsl:call-template>

		<xsl:apply-templates mode="visible" select="current()">
			<xsl:with-param name="parent" select="@id" />
			<xsl:with-param name="view_configuration_id" select="$view_configuration_id" />
		</xsl:apply-templates>
		<xsl:value-of select="concat($indentation,'}', $newline)" />

	</xsl:template>
</xsl:stylesheet>
