<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:exslt="http://exslt.org/common">

	<xsl:template match="toolbar">
		<xsl:param name="parent" />
		<xsl:param name="view_configuration_id" />
		<xsl:param name="is_version_rm_support" />
		<xsl:param name="level" select="count(./ancestor::*)-count(//view/ancestor::*)" />
		<xsl:param name="indentation">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level" />
			</xsl:call-template>
		</xsl:param>
		<xsl:param name="indentation1">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level+1" />
			</xsl:call-template>
		</xsl:param>

		<xsl:value-of select="concat($indentation, 'if (!vc->', @id, ') {', $newline)" />
		<xsl:value-of select="concat($indentation1, 'vc->', @id, '= elm_toolbar_add(vc->', $parent, ');', $newline)" />
		<xsl:value-of select="concat($indentation,'}', $newline)" />

		<xsl:value-of select="concat($indentation, 'if(vc->', @id, ') {', $newline)" />

	<xsl:if test="@style='navigationbar'">
		<xsl:value-of select="concat($indentation1, 'elm_object_style_set(vc->', @id, ', ','&#34;', @style,'&#34;', ');', $newline)" />
	</xsl:if>

		<xsl:choose>
			<xsl:when test="string-length(@shrink_mode) != 0 ">
				<xsl:variable name="rconv_key" select="concat('shrink_mode', ':', @shrink_mode)" />
				<xsl:variable name="rconv_value" select="exslt:node-set($value_map)//entry[@key=$rconv_key]" />
				<xsl:choose>
					<xsl:when test="string-length($rconv_value) != 0">
						<xsl:value-of select="concat($indentation1, 'elm_toolbar_shrink_mode_set(vc->', @id, ', (Elm_Toolbar_Shrink_Mode)', $rconv_value, ');', $newline)" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="concat($indentation1, 'elm_toolbar_shrink_mode_set(vc->', @id, ', ', @shrink_mode, ');', $newline)" />
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="concat($indentation1, 'elm_toolbar_shrink_mode_set(vc->', @id, ', ELM_TOOLBAR_SHRINK_NONE);', $newline)" />
			</xsl:otherwise>
		</xsl:choose>
		<xsl:if test="string-length(@select_mode) != 0 ">
			<xsl:variable name="rconv_key" select="concat('select_mode', ':', @select_mode)" />
			<xsl:variable name="rconv_value" select="exslt:node-set($value_map)//entry[@key=$rconv_key]" />
			<xsl:choose>
				<xsl:when test="string-length($rconv_value) != 0">
					<xsl:value-of select="concat($indentation1, 'elm_toolbar_select_mode_set(vc->', @id, ', (Elm_Object_Select_Mode)', $rconv_value, ');', $newline)" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="concat($indentation1, 'elm_toolbar_select_mode_set(vc->', @id, ', ', @select_mode, ');', $newline)" />
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>

		<xsl:if test="string-length(@icon_size) != 0 ">
			<xsl:value-of select="concat($indentation1, 'elm_toolbar_icon_size_set(vc->', @id, ', ', @icon_size, ');', $newline)" />
		</xsl:if>

		<xsl:choose>
			<xsl:when test="@transverse_expand='true'">
				<xsl:value-of select="concat($indentation1, 'elm_toolbar_transverse_expanded_set(vc->', @id, ', EINA_TRUE);', $newline)" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="concat($indentation1, 'elm_toolbar_transverse_expanded_set(vc->', @id, ', EINA_FALSE);', $newline)" />
			</xsl:otherwise>
		</xsl:choose>

		<xsl:choose>
			<xsl:when test="@shrink_mode='1' or @shrink-mode='3' or @shrink-mode='4' ">
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="@homogeneous='true'">
						<xsl:value-of select="concat($indentation1, 'elm_toolbar_homogeneous_set(vc->', @id, ', EINA_TRUE);', $newline)" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="concat($indentation1, 'elm_toolbar_homogeneous_set(vc->', @id, ', EINA_FALSE);', $newline)" />
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>

		<xsl:if test="string-length(@align) != 0 ">
			<xsl:value-of select="concat($indentation1, 'elm_toolbar_align_set(vc->', @id, ', ', @align, ');', $newline)" />
		</xsl:if>

		<xsl:choose>
			<xsl:when test="@direction='vertical'">
				<xsl:value-of select="concat($indentation1, 'elm_toolbar_horizontal_set(vc->', @id, ', EINA_FALSE);', $newline)" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="concat($indentation1, 'elm_toolbar_horizontal_set(vc->', @id, ', EINA_TRUE);', $newline)" />
			</xsl:otherwise>
		</xsl:choose>

		<xsl:apply-templates select="*">
			<xsl:with-param name="parent" select="@id" />
			<xsl:with-param name="is_version_rm_support" select="$is_version_rm_support" />
		</xsl:apply-templates>

		<xsl:call-template name="size_hint_align_set">
			<xsl:with-param name="align_h" select="@align_h" />
			<xsl:with-param name="align_v" select="@align_v" />
			<xsl:with-param name="indentation" select="$indentation1" />
			<xsl:with-param name="id" select="@id" />
		</xsl:call-template>
		<xsl:value-of select="$newline" />

		<xsl:call-template name="size_hint_weight_set">
			<xsl:with-param name="weight_h" select="@weight_h" />
			<xsl:with-param name="weight_v" select="@weight_v" />
			<xsl:with-param name="indentation" select="$indentation1" />
			<xsl:with-param name="id" select="@id" />
		</xsl:call-template>
		<xsl:value-of select="$newline" />

		<xsl:call-template name="disable">
			<xsl:with-param name="disable" select="@disable" />
			<xsl:with-param name="indentation" select="$indentation1" />
			<xsl:with-param name="id" select="@id" />
		</xsl:call-template>

		<xsl:apply-templates mode="visible" select="current()">
			<xsl:with-param name="parent" select="@id" />
			<xsl:with-param name="view_configuration_id" select="$view_configuration_id" />
		</xsl:apply-templates>
		<xsl:value-of select="concat($indentation,'}', $newline)" />
	</xsl:template>

</xsl:stylesheet>
