/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.efluibuilder.utility;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.MalformedURLException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.tizen.common.util.Assert;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class XMLUtil {
    public static Document clean(Document document) throws XPathExpressionException {
        XPath xPath = XPathFactory.newInstance().newXPath();
        NodeList nodeList = (NodeList)xPath.evaluate("//text()[normalize-space()='']", document, XPathConstants.NODESET);
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            node.getParentNode().removeChild(node);
            ++n;
        }
        return document;
    }

    public static Node getNode(Document document, String string) throws XPathExpressionException {
        XPath xPath = XPathFactory.newInstance().newXPath();
        Object object = xPath.evaluate(string, document, XPathConstants.NODE);
        Assert.isTrue((boolean)(object instanceof Node), (String)object.getClass().getName());
        Node node = (Node)object;
        return node;
    }

    public static String getValue(Document document, String string) throws XPathExpressionException {
        Node node = XMLUtil.getNode(document, string);
        String string2 = node.getTextContent();
        return string2;
    }

    public static Document load(File file) throws ParserConfigurationException, MalformedURLException, SAXException, IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        InputStream inputStream = file.toURI().toURL().openStream();
        Document document = documentBuilder.parse(inputStream);
        inputStream.close();
        return document;
    }

    public static void save(Document document, File file) throws IOException, TransformerException {
        DOMSource dOMSource = new DOMSource(document);
        FileWriter fileWriter = new FileWriter(file.getAbsolutePath());
        StreamResult streamResult = new StreamResult(fileWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("indent-number", 4);
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("encoding", "utf-8");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(dOMSource, streamResult);
        fileWriter.close();
    }

    public static String transform(Document document, Document document2) throws TransformerException, IOException {
        DOMSource dOMSource = new DOMSource(document);
        DOMSource dOMSource2 = new DOMSource(document2);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer(dOMSource2);
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("method", "text");
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(dOMSource, streamResult);
        String string = stringWriter.toString();
        stringWriter.close();
        return string;
    }

    public static String transform(Document document) throws TransformerException, IOException {
        DOMSource dOMSource = new DOMSource(document);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("indent-number", 4);
        Transformer transformer = null;
        transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(dOMSource, streamResult);
        String string = stringWriter.getBuffer().toString();
        stringWriter.close();
        return string;
    }
}

