/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.efluibuilder.model.descriptors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tizen.efluibuilder.model.descriptors.ContentDescriptor;
import org.tizen.efluibuilder.model.descriptors.WidgetDescriptor;

public class RelationDescriptor {
    private List<ContentDescriptor> contents = new ArrayList<ContentDescriptor>();
    private List<String> excludeIds = new ArrayList<String>();
    private List<String> parentIds = new ArrayList<String>();
    private List<String> noParentIds = new ArrayList<String>();

    public void addContent(ContentDescriptor contentDescriptor) {
        if (contentDescriptor == null) {
            return;
        }
        this.contents.add(contentDescriptor);
    }

    public void addContentPartIds(List<ContentDescriptor> list) {
        if (list == null) {
            return;
        }
        this.contents.addAll(list);
    }

    public void addContentPartIds(String string) {
        if (string == null) {
            return;
        }
        ContentDescriptor contentDescriptor = new ContentDescriptor();
        contentDescriptor.setPartIds(string);
        this.contents.add(contentDescriptor);
    }

    public void addNoContentPartIds(List<String> list) {
        if (list == null) {
            return;
        }
        this.excludeIds.addAll(list);
    }

    public void addNoContentPartIds(String string) {
        if (string == null) {
            return;
        }
        String[] stringArray = string.split(",");
        List<String> list = Arrays.asList(stringArray);
        this.addNoContentPartIds(list);
    }

    public void addParentPartIds(List<String> list) {
        if (list == null) {
            return;
        }
        this.parentIds.addAll(list);
    }

    public void addParentPartIds(String string) {
        if (string == null) {
            return;
        }
        String[] stringArray = string.split(",");
        List<String> list = Arrays.asList(stringArray);
        this.addParentPartIds(list);
    }

    public void addNoParentPartIds(List<String> list) {
        if (list == null) {
            return;
        }
        this.noParentIds.addAll(list);
    }

    public void addNoParentPartIds(String string) {
        if (string == null) {
            return;
        }
        String[] stringArray = string.split(",");
        List<String> list = Arrays.asList(stringArray);
        this.addNoParentPartIds(list);
    }

    public List<ContentDescriptor> getContents() {
        return this.contents;
    }

    public String getExclusiveGroupOfContent(String string) {
        String string2 = null;
        if (!this.contents.isEmpty()) {
            for (ContentDescriptor contentDescriptor : this.contents) {
                List<String> list = contentDescriptor.getPartIds();
                if (!list.isEmpty()) {
                    for (String string3 : list) {
                        if (!string3.equals(string)) continue;
                        string2 = contentDescriptor.getExclusiveGroup();
                        break;
                    }
                }
                if (string2 != null) break;
            }
        }
        return string2;
    }

    public boolean canHaveChild(String string, WidgetDescriptor widgetDescriptor, int n) {
        boolean bl;
        RelationDescriptor relationDescriptor;
        List<String> list;
        Object object;
        if (widgetDescriptor == null) {
            return false;
        }
        boolean bl2 = false;
        if (!this.contents.isEmpty()) {
            for (ContentDescriptor object22 : this.contents) {
                if (!object22.isMatch(widgetDescriptor, n)) continue;
                bl2 = true;
                break;
            }
        }
        if (!bl2) {
            return false;
        }
        if (!this.excludeIds.isEmpty()) {
            boolean bl3;
            boolean bl32 = false;
            object = this.excludeIds.iterator();
            while (object.hasNext()) {
                list = object.next();
                if (!((String)((Object)list)).equals(widgetDescriptor.getDescriptorId())) continue;
                bl3 = true;
                break;
            }
            if (bl3) {
                return false;
            }
        }
        if ((relationDescriptor = widgetDescriptor.getRelation()) == null) {
            return false;
        }
        list = relationDescriptor.parentIds;
        if (!list.isEmpty()) {
            boolean bl4 = false;
            bl = false;
            for (String string2 : list) {
                bl = true;
                if (!string2.equals(string)) continue;
                bl4 = true;
                break;
            }
            if (bl && !bl4) {
                return false;
            }
        }
        if (!(object = relationDescriptor.noParentIds).isEmpty()) {
            bl = false;
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string2;
                string2 = (String)iterator.next();
                if (!string2.equals(string)) continue;
                bl = true;
                break;
            }
            if (bl) {
                return false;
            }
        }
        return true;
    }

    public boolean canHaveChildren() {
        if (this.contents != null && !this.contents.isEmpty()) {
            return true;
        }
        return this.excludeIds != null && !this.excludeIds.isEmpty();
    }

    public boolean canCopyChild(WidgetDescriptor widgetDescriptor) {
        if (!this.contents.isEmpty()) {
            for (ContentDescriptor contentDescriptor : this.contents) {
                if (!contentDescriptor.isMatch(widgetDescriptor) || contentDescriptor.getMax() != contentDescriptor.getMin()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean canRemoveChild(WidgetDescriptor widgetDescriptor, int n) {
        boolean bl = true;
        if (!this.contents.isEmpty()) {
            for (ContentDescriptor contentDescriptor : this.contents) {
                if (!contentDescriptor.isMatch(widgetDescriptor) || n > contentDescriptor.getMin()) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    public boolean canSetParent(WidgetDescriptor widgetDescriptor) {
        boolean bl = true;
        String string = widgetDescriptor.getDescriptorId();
        if (!this.parentIds.isEmpty()) {
            bl = false;
            for (String string2 : this.parentIds) {
                if (!string2.equals(string)) continue;
                bl = true;
                break;
            }
        }
        if (bl && !this.noParentIds.isEmpty()) {
            for (String string2 : this.noParentIds) {
                if (!string2.equals(string)) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }
}

