/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.efluibuilder.core.configuration.device;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.tizen.efluibuilder.core.configuration.device.Device;
import org.tizen.efluibuilder.core.configuration.device.DeviceDeserializer;
import org.tizen.uibuilder.tizenfile.TizenFileFormatter;
import org.tizen.uibuilder.tizenfile.TizenFileReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DeviceFileReader
extends TizenFileReader {
    public static List<Device> read(String string) throws IOException, SAXException, ParserConfigurationException {
        Document document = DeviceFileReader.readFile((String)string);
        List<Device> list = DeviceFileReader.parseDevice(document);
        return list;
    }

    private static List<Device> parseDevice(Document document) {
        if (document == null) {
            return null;
        }
        Element element = document.getDocumentElement();
        TizenFileFormatter tizenFileFormatter = new TizenFileFormatter(element);
        if (!tizenFileFormatter.isValidate()) {
            return null;
        }
        if (!tizenFileFormatter.getType().equals("tizen-device")) {
            return null;
        }
        if (!tizenFileFormatter.getVersion().equals("1")) {
            return null;
        }
        ArrayList<Device> arrayList = new ArrayList<Device>();
        NodeList nodeList = element.getElementsByTagName("devices");
        int n = 0;
        while (n < nodeList.getLength()) {
            arrayList.addAll(DeviceFileReader.parseDevice((Element)nodeList.item(n)));
            ++n;
        }
        return arrayList;
    }

    private static List<Device> parseDevice(Element element) {
        ArrayList<Device> arrayList = new ArrayList<Device>();
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node instanceof Element && node.getNodeName().equals("device")) {
                arrayList.add(DeviceDeserializer.parseElement((Element)node));
            }
            ++n;
        }
        return arrayList;
    }
}

