<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:exslt="http://exslt.org/common">
    <xsl:template match="bg">
        <xsl:param name="parent" />
        <xsl:param name="view_configuration_id" />
        <xsl:param name="is_version_rm_support" />
        <xsl:param name="level" select="count(./ancestor::*)-count(//view/ancestor::*)" />
        <xsl:param name="indentation">
            <xsl:call-template name="dup">
                <xsl:with-param name="input" select="$indent" />
                <xsl:with-param name="count" select="$level" />
            </xsl:call-template>
        </xsl:param>
        <xsl:param name="indentation1">
            <xsl:call-template name="dup">
                <xsl:with-param name="input" select="$indent" />
                <xsl:with-param name="count" select="$level+1" />
            </xsl:call-template>
        </xsl:param>
        <xsl:param name="indentation2">
            <xsl:call-template name="dup">
                <xsl:with-param name="input" select="$indent" />
                <xsl:with-param name="count" select="$level+2" />
            </xsl:call-template>
        </xsl:param>

        <xsl:value-of select="concat($indentation, 'if (!vc->', @id, ') {', $newline)" />
        <xsl:value-of select="concat($indentation1, 'vc->', @id, ' = elm_bg_add(', 'vc->' ,$parent, ');', $newline)" />
        <xsl:value-of select="concat($indentation,'}', $newline)" />
        <xsl:value-of select="concat($indentation, 'if(vc->', @id, ') {', $newline)" />

        <xsl:call-template name="size_hint_align_set">
            <xsl:with-param name="align_h" select="@align_h" />
            <xsl:with-param name="align_v" select="@align_v" />
            <xsl:with-param name="indentation" select="$indentation1" />
            <xsl:with-param name="id" select="@id" />
        </xsl:call-template>

        <xsl:call-template name="size_hint_weight_set">
            <xsl:with-param name="weight_h" select="@weight_h" />
            <xsl:with-param name="weight_v" select="@weight_v" />
            <xsl:with-param name="indentation" select="$indentation1" />
            <xsl:with-param name="id" select="@id" />
        </xsl:call-template>

        <xsl:if test="string-length(@src) != 0">
            <xsl:variable name="escapedSrc">
                <xsl:call-template name="escapeStr">
                    <xsl:with-param name="str" select="@src" />
                </xsl:call-template>
            </xsl:variable>
            <xsl:value-of select="concat($indentation1, 'char *resource_path = NULL;', $newline)" />
            <xsl:choose>
                <xsl:when test="$is_version_rm_support='true'">
                    <xsl:value-of select="concat($indentation1, 'uib_util_rm_get_resource_path(APP_RESOURCE_TYPE_IMAGE, &quot;', $escapedSrc, '&quot;, &amp;resource_path);', $newline)" />
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="concat($indentation1, 'uib_util_rm_get_resource_path(-1, &quot;', $escapedSrc, '&quot;, &amp;resource_path);', $newline)" />
                </xsl:otherwise>
            </xsl:choose>
            <xsl:value-of select="concat($indentation1, 'elm_bg_file_set(vc->', @id, ', resource_path, NULL);', $newline)" />
            <xsl:value-of select="concat($indentation1, 'if(resource_path) {', $newline)" />
            <xsl:value-of select="concat($indentation2, 'free(resource_path);', $newline)" />
            <xsl:value-of select="concat($indentation1, '}', $newline)" />
        </xsl:if>
        <xsl:if test="string-length(@option) != 0">
            <xsl:variable name="rconv_key" select="concat('option', ':', @option)" />
            <xsl:variable name="rconv_value" select="exslt:node-set($value_map)//entry[@key=$rconv_key]" />
            <xsl:choose>
                <xsl:when test="string-length($rconv_value) != 0">
                    <xsl:value-of select="concat($indentation1, 'elm_bg_option_set(vc->', @id, ', (Elm_Bg_Option)', $rconv_value, ');', $newline)" />
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="concat($indentation1, 'elm_bg_option_set(vc->', @id, ', ', @option, ');', $newline)" />
                </xsl:otherwise>
            </xsl:choose>
        </xsl:if>
        <xsl:if test="string-length(@color) != 0">
            <xsl:value-of select="concat($indentation1, 'int hexValue = strtol(&quot;', @color, '&quot;+1, NULL, 16);', $newline)" />
            <xsl:value-of disable-output-escaping="yes" select="concat($indentation1, 'int r = (hexValue', '&amp;', '0xFF0000)', '&gt;&gt;', '16;', $newline)" />
            <xsl:value-of disable-output-escaping="yes" select="concat($indentation1, 'int g = (hexValue', '&amp;', '0xFF00)', '&gt;&gt;', '8;', $newline)" />
            <xsl:value-of disable-output-escaping="yes" select="concat($indentation1, 'int b = (hexValue', '&amp;', '0xFF);', $newline)" />
            <xsl:value-of select="concat($indentation1, 'elm_bg_color_set(vc->', @id, ', r, g, b);', $newline)" />
        </xsl:if>
        <xsl:apply-templates mode="visible" select="current()">
            <xsl:with-param name="parent" select="@id" />
            <xsl:with-param name="view_configuration_id" select="$view_configuration_id" />
        </xsl:apply-templates>
        <xsl:value-of select="concat($indentation,'}', $newline)" />
    </xsl:template>
</xsl:stylesheet>
