<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:variable name="newline">
		<xsl:text>
</xsl:text>
	</xsl:variable>
	<xsl:variable name="tab">
		<xsl:text disable-output-escaping="yes">	</xsl:text>
	</xsl:variable>
	<xsl:param name="startup_view" />
	<xsl:param name="profile" />
	<xsl:param name="is_version_rm_support" />
	<xsl:param name="is_widget_project" />
	<xsl:param name="version" />

	<xsl:variable name="common_resolution" select="/document/mscreen/configuration[@type = 'common']/@device" />
	<xsl:variable name="common_orientation" select="/document/mscreen/configuration[@type = 'common']/@orientation" />
	<xsl:variable name="common_id" select="/document/mscreen/configuration[@type = 'common']/@id" />
	<xsl:variable name="common_name" select="/document/mscreen/configuration[@type = 'common']/@name" />

	<xsl:template match="/">
		<xsl:call-template name="uib_common_view_source" />
	</xsl:template>

	<xsl:template name="uib_common_view_source">

		<!-- BEGIN : OUTPUT -->
		<xsl:text disable-output-escaping="yes">
<![CDATA[/*******************************************************************************
* This file was generated by UI Builder.
* This file will be auto-generated each and everytime you save your project.
* Do not hand edit this file.
********************************************************************************/

#include "g_inc_uib.h"

#include "uib_views_inc.h"
#include "uib_util.h"
#include "uib_views.h"
#include "uib_app_manager.h"

#define ICON_MIN_SIZE 30
#define DEF_STARTUP_VIEW_NAME ]]></xsl:text>
		<xsl:value-of select="concat('&quot;',$startup_view,'&quot;')" />
		<xsl:text disable-output-escaping="yes">
<![CDATA[
uib_views_st gst_uib_views;
static window_obj* g_win_obj = NULL;
]]></xsl:text>
		<xsl:choose>
			<xsl:when test="$is_widget_project='true'">
				<xsl:text><![CDATA[window_obj* create_window_obj(widget_context_h context, int w, int y);]]></xsl:text>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text><![CDATA[window_obj* create_window_obj();]]></xsl:text>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:text><![CDATA[
window_obj* get_window_obj();
void destroy_window_obj();

char* get_current_config_name ();
void uib_views_orientation_handler(int orient_status, Evas_Object* evas_obj_win);
uib_view_context* startup_view_create(window_obj* win);
void set_targeted_view(const char* view_name);

]]></xsl:text>
		<xsl:for-each select="/document/views/view">
			<xsl:value-of
				select="concat('static void (*uib_',@id,'_config_delegate_portrait)();',$newline, 'static void (*uib_',@id,'_config_delegate_landscape)();',$newline,$newline)" />
		</xsl:for-each>

		<xsl:for-each select="/document/views/view">
			<xsl:variable name="configuration_id" select="@id" />
			<xsl:value-of select="concat('char* ','g_',@id,'_','config_name_portrait = NULL;',$newline)" />
			<xsl:value-of select="concat('char* ','g_',@id,'_','config_name_landscape = NULL;',$newline)" />
		</xsl:for-each> <!-- update PM : get_current_configuration_name -->
		<xsl:text><![CDATA[
char* g_views_config_delegate_name_portrait = NULL;
char* g_views_config_delegate_name_landscape = NULL;
char* g_views_current_config_name = NULL;
	
static uib_view_context* g_uib_saved_vc = NULL;
static void push_to_stack_uib_vc(uib_view_context* push_vc);
static void pop_from_stack_uib_vc(uib_view_context* pop_vc);
static void uib_views_current_view_redraw();

static void uib_views_orientation_changed_cb(void*, Evas_Object*, void*);
]]></xsl:text>
		<xsl:choose>
			<xsl:when test="$profile='mobile' or $profile='tv'">
				<xsl:choose>
					<xsl:when test="$version='2.3' or $version='2.3.1'">
						<xsl:text><![CDATA[
typedef enum _uib_gengrid_item_style_e{
	UIB_GENGRID_ITEM_STYLE_UNKNOWN=-1,
	UIB_GENGRID_ITEM_STYLE_DEFAULT,
	UIB_GENGRID_ITEM_STYLE_ALBUM_PREVIEW,
	UIB_GENGRID_ITEM_STYLE_BLOCK,
	UIB_GENGRID_ITEM_STYLE_GROUP_INDEX,
	UIB_GENGRID_ITEM_STYLE_DEFAULT_GRID,
	UIB_GENGRID_ITEM_STYLE_DEFAULT_GRIDTEXT2,
	UIB_GENGRID_ITEM_STYLE_DEFAULT_GRIDTEXT,
	UIB_GENGRID_ITEM_STYLE_DEFAULT_STYLE,
	UIB_GENGRID_ITEM_STYLE_SIZE
} uib_gengrid_item_style_e;

typedef enum _uib_genlist_item_style_e{
	UIB_GENLIST_ITEM_STYLE_UNKNOWN=-1,
	UIB_GENLIST_ITEM_STYLE_DEFAULT,
	UIB_GENLIST_ITEM_STYLE_DEFAULT_STYLE,
	UIB_GENLIST_ITEM_STYLE_DOUBLE_LABEL,
	UIB_GENLIST_ITEM_STYLE_END_ICON,
	UIB_GENLIST_ITEM_STYLE_FULL,
	UIB_GENLIST_ITEM_STYLE_GROUPINDEX,
	UIB_GENLIST_ITEM_STYLE_ONE_ICON,
	UIB_GENLIST_ITEM_STYLE_ONE_MESSAGE,
	UIB_GENLIST_ITEM_STYLE_SIZE,
} uib_genlist_item_style_e;
]]></xsl:text>
					</xsl:when>
					<xsl:when test="$version='2.4' or $version='3.0'">
						<xsl:text><![CDATA[
typedef enum _uib_gengrid_item_style_e{
	UIB_GENGRID_ITEM_STYLE_UNKNOWN=-1,
	UIB_GENGRID_ITEM_STYLE_DEFAULT,
	UIB_GENGRID_ITEM_STYLE_TYPE1,
	UIB_GENGRID_ITEM_STYLE_TYPE2,
	UIB_GENGRID_ITEM_STYLE_SIZE
} uib_gengrid_item_style_e;

typedef enum _uib_genlist_item_style_e{
	UIB_GENLIST_ITEM_STYLE_UNKNOWN=-1,
	UIB_GENLIST_ITEM_STYLE_TYPE1,
	UIB_GENLIST_ITEM_STYLE_TYPE2,
	UIB_GENLIST_ITEM_STYLE_MULTILINE,
	UIB_GENLIST_ITEM_STYLE_FULL,
	UIB_GENLIST_ITEM_STYLE_GROUPINDEX,
	UIB_GENLIST_ITEM_STYLE_GROUPINDEX_EXPANDABLE,
	UIB_GENLIST_ITEM_STYLE_DEFAULT,
	UIB_GENLIST_ITEM_STYLE_DOUBLE_LABEL,
	UIB_GENLIST_ITEM_STYLE_ONE_ICON,
	UIB_GENLIST_ITEM_STYLE_END_ICON,
	UIB_GENLIST_ITEM_STYLE_SIZE
} uib_genlist_item_style_e;
]]></xsl:text>
					</xsl:when>
					<xsl:otherwise>
						<xsl:text><![CDATA[]]></xsl:text>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:text><![CDATA[
static Elm_Gengrid_Item_Class* _gic[UIB_GENGRID_ITEM_STYLE_SIZE];
static void destory_gengrid_item_class();
static uib_gengrid_item_style_e get_gengrid_item_style_e(const char* style);
static Elm_Gengrid_Item_Class* get_gengrid_item_class(const char* style);
static Elm_Gengrid_Item_Class* create_gengrid_item_class(const char* style);
]]></xsl:text>
			</xsl:when>
			<xsl:when test="$profile='wearable'">
				<xsl:text><![CDATA[
typedef enum _uib_genlist_item_style_e{
	UIB_GENLIST_ITEM_STYLE_UNKNOWN=-1,
	UIB_GENLIST_ITEM_STYLE_DEFAULT,
	UIB_GENLIST_ITEM_STYLE_GROUPINDEX,
	UIB_GENLIST_ITEM_STYLE_1TEXT,
	UIB_GENLIST_ITEM_STYLE_1TEXT_1ICON,
	UIB_GENLIST_ITEM_STYLE_2TEXT,
	UIB_GENLIST_ITEM_STYLE_2TEXT_1,
	UIB_GENLIST_ITEM_STYLE_1TEXT_1ICON_DIVIDER,
	UIB_GENLIST_ITEM_STYLE_1TEXT_1ICON_1,
	UIB_GENLIST_ITEM_STYLE_2TEXT_1ICON_1,
	UIB_GENLIST_ITEM_STYLE_NULTILINE_1TEXT,
	UIB_GENLIST_ITEM_STYLE_NULTILINE_2TEXT,
	UIB_GENLIST_ITEM_STYLE_SIZE
} uib_genlist_item_style_e;
]]></xsl:text>
			</xsl:when>
			<xsl:when test="$profile='wearable-circle'">
				<xsl:text><![CDATA[
typedef enum _uib_genlist_item_style_e{
	UIB_GENLIST_ITEM_STYLE_UNKNOWN=-1,
	UIB_GENLIST_ITEM_STYLE_DEFAULT,
	UIB_GENLIST_ITEM_STYLE_TITLE,
	UIB_GENLIST_ITEM_STYLE_GROUPINDEX,
	UIB_GENLIST_ITEM_STYLE_1TEXT,
	UIB_GENLIST_ITEM_STYLE_1TEXT_1ICON,
	UIB_GENLIST_ITEM_STYLE_2TEXT,
	UIB_GENLIST_ITEM_STYLE_1TEXT_1ICON_DIVIDER,
	UIB_GENLIST_ITEM_STYLE_1TEXT_1ICON_1,
	UIB_GENLIST_ITEM_STYLE_2TEXT_1ICON_1,
	UIB_GENLIST_ITEM_STYLE_EDITFIELD,
	UIB_GENLIST_ITEM_STYLE_SIZE
} uib_genlist_item_style_e;
]]></xsl:text>
			</xsl:when>
			<xsl:otherwise />
		</xsl:choose>
		<xsl:text><![CDATA[
static Elm_Genlist_Item_Class* _gis[UIB_GENLIST_ITEM_STYLE_SIZE];
static void destory_genlist_item_class();
static uib_genlist_item_style_e get_genlist_item_style_e(const char* style);
static Elm_Genlist_Item_Class* get_genlist_item_class(const char* style);
static Elm_Genlist_Item_Class* create_genlist_item_class(const char* style);

void uib_views_init() {
	if(!gst_uib_views.is_init) {
		gst_uib_views.is_init = true;
		gst_uib_views.create_window_obj = &create_window_obj;
		gst_uib_views.destroy_window_obj = &destroy_window_obj;
		gst_uib_views.get_window_obj = &get_window_obj;
		gst_uib_views.get_window = &get_window;
		gst_uib_views.get_conformant = &get_conformant;
		gst_uib_views.uib_views_current_view_redraw = &uib_views_current_view_redraw;
		gst_uib_views.uib_views_orientation_handler = &uib_views_orientation_handler;
		gst_uib_views.startup_view_create = &startup_view_create;
		gst_uib_views.set_targeted_view = &set_targeted_view;
		gst_uib_views.get_current_config_name = &get_current_config_name;

		// check resoltuion type
		const uib_device_info_st* uib_device_info = uib_app_manager_get_instance()->get_uib_device_info();
		switch(uib_device_info->resolution_type) {
]]></xsl:text>
		<xsl:for-each select="/document/mscreen/configuration">
			<xsl:variable name="configuration_resolution" select="@device" />
			<xsl:variable name="configuration_id" select="/document/mscreen/configuration[@device=$configuration_resolution and @orientation='portrait']/@id" />
			<xsl:variable name="configuration_name" select="/document/mscreen/configuration[@device=$configuration_resolution and @orientation='portrait']/@name" /> <!-- update PM : get_current_configuration_name -->

			<xsl:if test="count(following-sibling::configuration[$configuration_resolution = @device]) = 0">
				<xsl:value-of select="concat($tab, $tab, 'case e_resolution_',$configuration_resolution,':',$newline)" />
				<xsl:for-each select="/document/views/view">
					<xsl:variable name="view_id" select="@id" />
					<xsl:variable name="view_position" select="position()" />

					<xsl:if test="count(/document/mscreen//configuration[@device=$configuration_resolution and @orientation='portrait']) > 0">
						<xsl:variable name="configuration_id" select="/document/mscreen/configuration[@device=$configuration_resolution and @orientation='portrait']/@id" />
						<xsl:variable name="configuration_name" select="/document/mscreen/configuration[@device=$configuration_resolution and @orientation='portrait']/@name" />
						<xsl:choose>
							<xsl:when test="(count(/document/views/view[$view_position]//variation[@config_ref=$configuration_id]) = 0)">
								<xsl:if test="$common_id = $configuration_id">
									<xsl:value-of
										select="concat($tab,$tab,$tab,'uib_',$view_id,'_config_delegate_portrait = &amp;uib_',$view_id,'_config_',$common_resolution,'_portrait;',$newline)" />
									<xsl:value-of select="concat($tab,$tab,$tab,'g_',$view_id,'_config_name_portrait = ','&quot;',$common_name,'&quot;',';',$newline)" /> <!-- update PM : get_current_configuration_name -->
								</xsl:if>
								<xsl:if test="not($common_id = $configuration_id)">
									<xsl:value-of
										select="concat($tab,$tab,$tab,'uib_',$view_id,'_config_delegate_portrait = &amp;uib_',$view_id,'_config_',$common_resolution,'_',$common_orientation,';',$newline)" />
									<xsl:value-of select="concat($tab,$tab,$tab,'g_',$view_id,'_config_name_portrait = ','&quot;',$common_name,'&quot;',';',$newline)" /> <!-- update PM : get_current_configuration_name -->
								</xsl:if>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="concat($tab,$tab,$tab,'uib_',@id,'_config_delegate_portrait = &amp;uib_',@id,'_config_',$configuration_resolution,'_portrait;',$newline)" />
								<xsl:value-of select="concat($tab,$tab,$tab,'g_',$view_id,'_config_name_portrait = ','&quot;',$configuration_name,'&quot;',';',$newline)" /> <!-- update PM : get_current_configuration_name -->
							</xsl:otherwise>
						</xsl:choose>
					</xsl:if>

					<xsl:if test="count(/document/mscreen//configuration[@device=$configuration_resolution and @orientation='portrait']) = 0">
						<xsl:value-of
							select="concat($tab,$tab,$tab,'uib_',$view_id,'_config_delegate_portrait = &amp;uib_',$view_id,'_config_',$common_resolution,'_',$common_orientation,';',$newline)" />
						<xsl:value-of select="concat($tab,$tab,$tab,'g_',$view_id,'_config_name_portrait = ','&quot;',$common_name,'&quot;',';',$newline)" /> <!-- update PM : get_current_configuration_name -->
					</xsl:if>


					<xsl:if test="count(/document/mscreen//configuration[@device=$configuration_resolution and @orientation='landscape']) > 0">
						<xsl:variable name="configuration_id" select="/document/mscreen/configuration[@device=$configuration_resolution and @orientation='landscape']/@id" />
						<xsl:variable name="configuration_name" select="/document/mscreen/configuration[@device=$configuration_resolution and @orientation='landscape']/@name" />
						<xsl:choose>
							<xsl:when test="(count(/document/views/view[$view_position]//variation[@config_ref=$configuration_id]) = 0)">
								<xsl:if test="$common_id = $configuration_id">
									<xsl:value-of
										select="concat($tab,$tab,$tab,'uib_',$view_id,'_config_delegate_landscape = &amp;uib_',$view_id,'_config_',$common_resolution,'_landscape;',$newline)" />
									<xsl:value-of select="concat($tab,$tab,$tab,'g_',$view_id,'_config_name_landscape = ','&quot;',$common_name,'&quot;',';',$newline)" /> <!-- update PM : get_current_configuration_name -->
								</xsl:if>
								<xsl:if test="not($common_id = $configuration_id)">
									<xsl:value-of
										select="concat($tab,$tab,$tab,'uib_',$view_id,'_config_delegate_landscape = &amp;uib_',$view_id,'_config_',$common_resolution,'_',$common_orientation,';',$newline)" />
									<xsl:value-of select="concat($tab,$tab,$tab,'g_',$view_id,'_config_name_landscape = ','&quot;',$common_name,'&quot;',';',$newline)" /> <!-- update PM : get_current_configuration_name -->
								</xsl:if>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of
									select="concat($tab,$tab,$tab,'uib_',@id,'_config_delegate_landscape',' = &amp;uib_',@id,'_config_',$configuration_resolution,'_landscape;',$newline)" />
								<xsl:value-of select="concat($tab,$tab,$tab,'g_',$view_id,'_config_name_landscape = ','&quot;',$configuration_name,'&quot;',';',$newline)" /> <!-- update PM : get_current_configuration_name -->
							</xsl:otherwise>
						</xsl:choose>
					</xsl:if>
					<xsl:if test="count(/document/mscreen//configuration[@device=$configuration_resolution and @orientation='landscape']) = 0">
						<xsl:value-of
							select="concat($tab,$tab,$tab,'uib_',$view_id,'_config_delegate_landscape = &amp;uib_',$view_id,'_config_',$common_resolution,'_',$common_orientation,';',$newline)" />
						<xsl:value-of select="concat($tab,$tab,$tab,'g_',$view_id,'_config_name_landscape = ','&quot;',$common_name,'&quot;',';',$newline)" /> <!-- update PM : get_current_configuration_name -->
					</xsl:if>
					<xsl:value-of select="concat($newline)" />
				</xsl:for-each>
				<xsl:value-of select="concat($tab,$tab,$tab,'break;',$newline)" />
			</xsl:if>
		</xsl:for-each>

		<xsl:text><![CDATA[
		default:
]]></xsl:text>
		<xsl:for-each select="/document/views/view">
			<xsl:value-of
				select="concat($tab,$tab,$tab,'uib_',@id,'_config_delegate_portrait',' = &amp;uib_',@id,'_config_',$common_resolution,'_',$common_orientation,';',$newline)" />
			<xsl:value-of
				select="concat($tab,$tab,$tab,'uib_',@id,'_config_delegate_landscape',' = &amp;uib_',@id,'_config_',$common_resolution,'_',$common_orientation,';',$newline)" />
			<xsl:value-of select="concat($tab,$tab,$tab,'g_',@id,'_config_name_portrait = ','&quot;',$common_name,'&quot;',';',$newline)" /> <!-- update PM : get_current_configuration_name -->
			<xsl:value-of select="concat($tab,$tab,$tab,'g_',@id,'_config_name_landscape = ','&quot;',$common_name,'&quot;',';',$newline,$newline)" /> <!-- update PM : get_current_configuration_name -->
		</xsl:for-each>
		<xsl:text disable-output-escaping="yes"><![CDATA[
			break;
		}
	}
}

uib_views_st* uib_views_get_instance() {
	uib_views_init();
	return &gst_uib_views;
}


void uib_views_create_callback(void* vc, Evas* e, Evas_Object* obj, void* event_info) {
	push_to_stack_uib_vc(vc);
	evas_object_smart_callback_call(obj, KEY_VIEW_CREATE, event_info);
}

void uib_views_destroy_callback(void* vc, Evas* e, Evas_Object* obj, void* event_info) {
	evas_object_smart_callback_call(obj, KEY_VIEW_DESTROY, event_info);
	pop_from_stack_uib_vc(vc);
}

// called by views_create_callback
void push_to_stack_uib_vc(uib_view_context* push_vc) {
	evas_object_data_set(push_vc->root_container, KEY_VIEW_VC_SAVE, g_uib_saved_vc);
	g_uib_saved_vc = push_vc;
}

// called by views_destroy_callback
void pop_from_stack_uib_vc(uib_view_context* pop_vc) {
	uib_view_context* rollback_vc = evas_object_data_get(pop_vc->root_container, KEY_VIEW_VC_SAVE);
	g_uib_saved_vc = rollback_vc;
	if(g_uib_saved_vc) {
		set_targeted_view(g_uib_saved_vc->view_name);
	}
}

void set_targeted_view(const char* view_name) {
]]></xsl:text>
		<xsl:for-each select="/document/views/view">
			<xsl:choose>
				<xsl:when test="position()=1">
					<xsl:value-of
						select="concat($tab,'if(!strcmp(view_name,&quot;',@id,'&quot;)) {',$newline,
							   $tab,$tab,'gst_uib_views.uib_view_target_config_portrait = uib_',@id, '_config_delegate_portrait;',$newline,
							   $tab,$tab,'gst_uib_views.uib_view_target_config_landscape = uib_',@id, '_config_delegate_landscape;',$newline,$newline,
							   $tab,$tab,'g_views_config_delegate_name_portrait = g_',@id, '_config_name_portrait;',$newline,
							   $tab,$tab,'g_views_config_delegate_name_landscape = g_',@id, '_config_name_landscape;',$newline,$newline)" /> <!-- update PM : get_current_configuration_name -->


					<!-- update sensor control -->
					<xsl:choose>
						<xsl:when test="@screen_orientation='full_sensor'">
							<xsl:value-of select="concat($tab, $tab, 'uib_util_rotation_set(g_win_obj->win, e_rotation_fullSensor);',$newline,
							   $tab,'}')" />
						</xsl:when>
						<xsl:when test="@screen_orientation='no_sensor'">
							<xsl:value-of select="concat($tab, $tab, 'uib_util_rotation_set(g_win_obj->win, e_rotation_noSensor);',$newline,
							   $tab,'}')" />
						</xsl:when>
						<xsl:when test="@screen_orientation='only_landscape'">
							<xsl:value-of select="concat($tab, $tab, 'uib_util_rotation_set(g_win_obj->win, e_rotation_onlyLandscape);',$newline,
							   $tab,'}')" />
						</xsl:when>
						<xsl:when test="@screen_orientation='only_portrait'">
							<xsl:value-of select="concat($tab, $tab, 'uib_util_rotation_set(g_win_obj->win, e_rotation_onlyPortrait);',$newline,
							   $tab,'}')" />
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="concat($tab, $tab, 'uib_util_rotation_set(g_win_obj->win, e_rotation_default);',$newline,
							   $tab,'}')" />
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of
						select="concat(' else if(!strcmp(view_name,&quot;',@id,'&quot;)) {',$newline,
							   $tab,$tab,'gst_uib_views.uib_view_target_config_portrait = uib_',@id, '_config_delegate_portrait;',$newline,
							   $tab,$tab,'gst_uib_views.uib_view_target_config_landscape = uib_',@id, '_config_delegate_landscape;',$newline,$newline,
							   $tab,$tab,'g_views_config_delegate_name_portrait = g_',@id, '_config_name_portrait;',$newline,
							   $tab,$tab,'g_views_config_delegate_name_landscape = g_',@id, '_config_name_landscape;',$newline,$newline)" />
					<!-- update sensor control -->
					<xsl:choose>
						<xsl:when test="@screen_orientation='full_sensor'">
							<xsl:value-of select="concat($tab, $tab, 'uib_util_rotation_set(g_win_obj->win, e_rotation_fullSensor);',$newline,
							   $tab,'}')" />
						</xsl:when>
						<xsl:when test="@screen_orientation='no_sensor'">
							<xsl:value-of select="concat($tab, $tab, 'uib_util_rotation_set(g_win_obj->win, e_rotation_noSensor);',$newline,
							   $tab,'}')" />
						</xsl:when>
						<xsl:when test="@screen_orientation='only_landscape'">
							<xsl:value-of select="concat($tab, $tab, 'uib_util_rotation_set(g_win_obj->win, e_rotation_onlyLandscape);',$newline,
							   $tab,'}')" />
						</xsl:when>
						<xsl:when test="@screen_orientation='only_portrait'">
							<xsl:value-of select="concat($tab, $tab, 'uib_util_rotation_set(g_win_obj->win, e_rotation_onlyPortrait);',$newline,
							   $tab,'}')" />
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="concat($tab, $tab, 'uib_util_rotation_set(g_win_obj->win, e_rotation_default);',$newline,
							   $tab,'}')" />
						</xsl:otherwise>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>
		<xsl:text disable-output-escaping="yes"><![CDATA[
	int orientation=elm_win_rotation_get(uib_views_get_instance()->get_window());
	uib_views_get_instance()->uib_views_orientation_handler(orientation, uib_views_get_instance()->get_window());
}

void uib_views_orientation_handler(int orient_status, Evas_Object* evas_obj_win) {
	switch(DEF_UIB_ORIENT_TYPE(orient_status)) {
	case e_orientation_port:
		uib_views_get_instance()->uib_view_target_config_portrait();
		g_views_current_config_name = g_views_config_delegate_name_portrait;
		break;
	case e_orientation_land:
		uib_views_get_instance()->uib_view_target_config_landscape();
		g_views_current_config_name = g_views_config_delegate_name_landscape;
		break;
	default:
		uib_views_get_instance()->uib_view_target_config_portrait();
		g_views_current_config_name = g_views_config_delegate_name_portrait;
		break;
	}
}

char* get_current_config_name() {
	return g_views_current_config_name;
}


void uib_views_orientation_changed_cb(void *win, Evas_Object *obj, void *event_info) {
	int orientation=elm_win_rotation_get(win);
	uib_views_orientation_handler(orientation, win);
}

void uib_views_current_view_redraw() {
	uib_views_orientation_changed_cb(g_win_obj->win, NULL, NULL);
}


uib_view_context* startup_view_create(window_obj* win_obj)
{
	evas_object_smart_callback_add(win_obj->win, KEY_WM_ROTATION_CHANGED, uib_views_orientation_changed_cb, win_obj->win);
	uib_util_push_view(DEF_STARTUP_VIEW_NAME);
	return uib_app_manager_get_instance()->find_view_context(DEF_STARTUP_VIEW_NAME);
}

]]></xsl:text>
		<xsl:choose>
			<xsl:when test="$profile='tv'">
				<xsl:text><![CDATA[
window_obj* create_window_obj()
{
	g_win_obj = calloc(1, sizeof(window_obj));
	if (!g_win_obj) {
		return NULL;
	}
	g_win_obj->win = elm_win_add(NULL, NULL, ELM_WIN_BASIC);
	elm_win_fullscreen_set(g_win_obj->win, EINA_TRUE);
	elm_win_alpha_set(g_win_obj->win, EINA_TRUE);

	g_win_obj->bg = elm_bg_add(g_win_obj->win);
	evas_object_size_hint_weight_set(g_win_obj->bg, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	elm_win_resize_object_add(g_win_obj->win, g_win_obj->bg);
	evas_object_show(g_win_obj->bg);

	g_win_obj->conformant = elm_box_add(g_win_obj->win);
	evas_object_size_hint_align_set(g_win_obj->conformant, EVAS_HINT_FILL, EVAS_HINT_FILL);
	evas_object_size_hint_weight_set(g_win_obj->conformant, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	evas_object_show(g_win_obj->conformant);
	elm_win_resize_object_add(g_win_obj->win, g_win_obj->conformant);

	g_win_obj->app_naviframe = elm_naviframe_add(g_win_obj->conformant);
	evas_object_size_hint_weight_set(g_win_obj->app_naviframe, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	evas_object_size_hint_align_set(g_win_obj->app_naviframe, EVAS_HINT_FILL, EVAS_HINT_FILL);
	evas_object_show(g_win_obj->app_naviframe);
	elm_box_pack_end(g_win_obj->conformant, g_win_obj->app_naviframe);
	
	evas_object_data_set(g_win_obj->win, "root", g_win_obj);

	evas_object_show(g_win_obj->win);
	return g_win_obj;
}
		]]></xsl:text>
			</xsl:when>
			<xsl:when test="$is_widget_project='true'">
				<xsl:text><![CDATA[
window_obj* create_window_obj(widget_context_h context, int w, int h)
{
	g_win_obj = calloc(1, sizeof(window_obj));
	if (!g_win_obj) {
		return NULL;
	}
	int ret = widget_app_get_elm_win(context, &(g_win_obj->win));
	if (ret != WIDGET_ERROR_NONE) {
		UIB_DLOG(DLOG_ERROR, LOG_TAG, "failed to get window. err = %d", ret);
		return NULL;
	}
	evas_object_resize(g_win_obj->win, w, h);

	elm_win_conformant_set(g_win_obj->win, EINA_TRUE);
	evas_object_show(g_win_obj->win);
	g_win_obj->bg = elm_bg_add(g_win_obj->win);
	evas_object_size_hint_weight_set(g_win_obj->bg, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	elm_win_resize_object_add(g_win_obj->win, g_win_obj->bg);
	evas_object_show(g_win_obj->bg);

	elm_win_indicator_mode_set(g_win_obj->win, ELM_WIN_INDICATOR_SHOW);
	g_win_obj->conformant = elm_conformant_add(g_win_obj->win);
	evas_object_size_hint_weight_set(g_win_obj->conformant, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	elm_win_resize_object_add(g_win_obj->win, g_win_obj->conformant);
	evas_object_show(g_win_obj->conformant);

	g_win_obj->app_naviframe = elm_naviframe_add(g_win_obj->conformant);
	elm_object_content_set(g_win_obj->conformant, g_win_obj->app_naviframe);]]></xsl:text>
				<!-- <xsl:if test="$profile='wearable-circle'">
					<xsl:value-of select="concat($newline, $tab, 'g_win_obj->circle_surface = eext_circle_surface_conformant_add(g_win_obj->conformant);')" />
				</xsl:if> -->
				<xsl:text><![CDATA[
	evas_object_data_set(g_win_obj->win, "root", g_win_obj);
	return g_win_obj;
}]]></xsl:text>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text><![CDATA[
window_obj* create_window_obj()
{
	g_win_obj = calloc(1, sizeof(window_obj));
	if (!g_win_obj) {
		return NULL;
	}
	g_win_obj->win = elm_win_add(NULL, NULL, ELM_WIN_BASIC);
	elm_win_conformant_set(g_win_obj->win, EINA_TRUE);
	evas_object_show(g_win_obj->win);
	g_win_obj->bg = elm_bg_add(g_win_obj->win);
	evas_object_size_hint_weight_set(g_win_obj->bg, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	elm_win_resize_object_add(g_win_obj->win, g_win_obj->bg);
	evas_object_show(g_win_obj->bg);

	elm_win_indicator_mode_set(g_win_obj->win, ELM_WIN_INDICATOR_SHOW);
	g_win_obj->conformant = elm_conformant_add(g_win_obj->win);
	evas_object_size_hint_weight_set(g_win_obj->conformant, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	elm_win_resize_object_add(g_win_obj->win, g_win_obj->conformant);
	evas_object_show(g_win_obj->conformant);

	g_win_obj->app_naviframe = elm_naviframe_add(g_win_obj->conformant);
	elm_object_content_set(g_win_obj->conformant, g_win_obj->app_naviframe);]]></xsl:text>
				<!-- <xsl:if test="$profile='wearable-circle'">
					<xsl:value-of select="concat($newline, $tab, 'g_win_obj->circle_surface = eext_circle_surface_conformant_add(g_win_obj->conformant);')" />
				</xsl:if> -->
				<xsl:text><![CDATA[
	
	evas_object_data_set(g_win_obj->win, "root", g_win_obj);
	return g_win_obj;
}
		]]></xsl:text>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:text><![CDATA[	


void destroy_window_obj()
{
	if (g_win_obj) {
		evas_object_del(g_win_obj->win);
		free(g_win_obj);
		g_win_obj = NULL;
	}
	destory_genlist_item_class();]]></xsl:text>
		<xsl:choose>
			<xsl:when test="$profile='mobile' or $profile='tv'">
				<xsl:text><![CDATA[
	destory_gengrid_item_class();]]></xsl:text>
			</xsl:when>
		</xsl:choose>
		<xsl:text><![CDATA[
}

window_obj* get_window_obj() {
	return g_win_obj;
}

Evas_Object* get_window() {
	return gst_uib_views.get_window_obj()->win;
}

Evas_Object* get_conformant() {
	return gst_uib_views.get_window_obj()->conformant;
}

/***********************************************************************************************
 *
 * item class callbacks
 *
 ***********************************************************************************************/
static Evas_Object* create_item_image(Evas_Object* parent, const char* path) {
	Evas_Object *icon = elm_icon_add(parent);
	char *resource_path = NULL;
]]></xsl:text>
		<xsl:choose>
			<xsl:when test="$is_version_rm_support='true'">
				<xsl:text><![CDATA[
	uib_util_rm_get_resource_path(APP_RESOURCE_TYPE_IMAGE, path, &resource_path);
		]]></xsl:text>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text><![CDATA[
	uib_util_rm_get_resource_path(-1, path, &resource_path);
		]]></xsl:text>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:text><![CDATA[	
	elm_image_file_set(icon, resource_path, NULL);
	if(resource_path) {
		free(resource_path);
	}
	evas_object_size_hint_min_set(icon, ELM_SCALE_SIZE(ICON_MIN_SIZE),ELM_SCALE_SIZE(ICON_MIN_SIZE));
	evas_object_show(icon);
	return icon;
}

char* uib_genlist_label_get(void *data, Evas_Object *obj, const char *part) {
	uib_genlist_item *item = (uib_genlist_item*)data;
	if(!strcmp(part, "elm.text")) {
		if (item->label) {
			return strdup(item->label);
		}
	}
	else if (!strcmp(part, "elm.text.sub") || !strcmp(part, "elm.text.1")) {
		if (item->sub_label) {
			return strdup(item->sub_label);
		}
	}
	return NULL;
}

Evas_Object* uib_genlist_icon_get(void *data , Evas_Object *obj, const char *part) {
	uib_genlist_item *item = (uib_genlist_item*) data;
	if (!strcmp(part, "elm.swallow.icon")) {
		if(item->icon_standard){
			Evas_Object *ic = elm_icon_add(obj);
			elm_icon_standard_set(ic, item->icon_standard);
			evas_object_size_hint_min_set(ic, ELM_SCALE_SIZE(ICON_MIN_SIZE),ELM_SCALE_SIZE(ICON_MIN_SIZE));
			return ic;
		} else if(item->icon_path){
			return create_item_image(obj, item->icon_path);
		}
	}

	if (!strcmp(part, "elm.swallow.end")) {
		if (item->end_icon_standard) {
			Evas_Object *ic = elm_icon_add(obj);
			elm_icon_standard_set(ic, item->end_icon_standard);
			evas_object_size_hint_min_set(ic, ELM_SCALE_SIZE(ICON_MIN_SIZE),ELM_SCALE_SIZE(ICON_MIN_SIZE));
			return ic;
		} else if (item->end_icon_path) {
			return create_item_image(obj, item->end_icon_path);
		}
	}

	if (!strcmp(part, "elm.icon")) {
		if(item->icon_path){
			Evas_Object *btn = elm_button_add(obj);
			elm_object_style_set(btn, "list_divider_btn");
			evas_object_size_hint_weight_set(btn, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
			evas_object_size_hint_align_set(btn, EVAS_HINT_FILL, EVAS_HINT_FILL);

			Evas_Object *ic = create_item_image(obj, item->icon_path);
			elm_object_content_set(btn, ic);
			evas_object_propagate_events_set(btn, EINA_FALSE);
			return btn;
		}
	}
	return NULL;
}

Eina_Bool uib_genlist_state_get(void *data , Evas_Object *obj , const char *part) {
	return EINA_FALSE;
}

void uib_genlist_del(void *data , Evas_Object *obj) {
	uib_genlist_item *item = (uib_genlist_item*)data;
	if (item) {
		if (item->label) free(item->label);
		if (item->sub_label) free(item->sub_label);
		if (item->icon_path) free(item->icon_path);
		if (item->icon_standard) free(item->icon_standard);
		if (item->end_icon_path) free(item->end_icon_path);
		if (item->end_icon_standard) free(item->end_icon_standard);
		free(item);
	}
}


Elm_Object_Item* create_genlist_item(Evas_Object* genlist, const char* style, const char* label, const char* sub_label, const char* icon_path, const char* icon_standard, const char* end_icon_path, const char* end_icon_standard, Elm_Object_Item* parent, Elm_Genlist_Item_Type type, Evas_Smart_Cb func, void* data){
	uib_genlist_item* item = malloc(sizeof(uib_genlist_item));
	memset(item, 0x0, sizeof(uib_genlist_item));

	item->label = strdup(label);
	item->sub_label = strdup(sub_label);
	if(strlen(icon_path) != 0){
		item->icon_path = strdup(icon_path);
	} else if(strlen(icon_standard) != 0){
		item->icon_standard = strdup(icon_standard);
    }
	
	if(strlen(end_icon_path) != 0){
		item->end_icon_path = strdup(end_icon_path);
	} else if(strlen(end_icon_standard) != 0){
		item->end_icon_standard = strdup(end_icon_standard);
	}
	
	uib_genlist_item_style_e style_e = get_genlist_item_style_e(style);
	if(style_e == UIB_GENLIST_ITEM_STYLE_GROUPINDEX) {
		type = ELM_GENLIST_ITEM_TREE;
	}
	return elm_genlist_item_append(genlist,  get_genlist_item_class(style), item, parent, type, func, data);
}

static void destory_genlist_item_class() {
	for(int i = 0; i< UIB_GENLIST_ITEM_STYLE_SIZE; i++) {
		Elm_Genlist_Item_Class *itc = _gis[i];
		if(itc != NULL) {
			elm_genlist_item_class_free(itc);
		}
	}
}

static Elm_Genlist_Item_Class* get_genlist_item_class(const char* style) {
	uib_genlist_item_style_e style_e = get_genlist_item_style_e(style);
	Elm_Genlist_Item_Class *itc = _gis[style_e];
	if(itc == NULL) {
		itc = create_genlist_item_class(style);
		if(itc != NULL) {
			_gis[style_e] = itc;
		}
	}
	return itc;
}

static Elm_Genlist_Item_Class* create_genlist_item_class(const char* style) {
	Elm_Genlist_Item_Class *itc = elm_genlist_item_class_new();
	itc->item_style = style;
	itc->func.text_get = uib_genlist_label_get;
	itc->func.content_get = uib_genlist_icon_get;
	itc->func.state_get = uib_genlist_state_get;
	itc->func.del = uib_genlist_del;

	return itc;
}
]]></xsl:text>
		<xsl:choose>
			<xsl:when test="$profile='mobile' or $profile='tv'">
				<xsl:text><![CDATA[
char* uib_gengrid_label_get(void *data, Evas_Object *obj, const char *part) {
	uib_gengrid_item *item = (uib_gengrid_item*)data;
	if (item->label) {
		return strdup(item->label);
	} else {
		return NULL;
	}
}

Evas_Object* uib_gengrid_icon_get(void *data, Evas_Object *obj, const char *part) {
	uib_gengrid_item *item = (uib_gengrid_item*) data;
	if (!strcmp(part, "elm.swallow.icon") && item->icon_path) {
		return create_item_image(obj, item->icon_path);
	} else {
		return NULL;
	}
}

Eina_Bool uib_gengrid_state_get(void *data, Evas_Object *obj, const char *part) {
	return EINA_FALSE;
}

void uib_gengrid_del(void *data, Evas_Object *obj) {
	uib_gengrid_item *item = (uib_gengrid_item*)data;
	if (item) {
		if (item->label) free(item->label);
		if (item->icon_path) free(item->icon_path);
		free(item);
	}
}

static void destory_gengrid_item_class() {
	for(int i = 0; i< UIB_GENGRID_ITEM_STYLE_SIZE; i++) {
		Elm_Genlist_Item_Class *itc = _gic[i];
		if(itc != NULL) {
			elm_gengrid_item_class_free(itc);
		}
	}
}

static Elm_Gengrid_Item_Class* get_gengrid_item_class(const char* style) {
	uib_gengrid_item_style_e style_e = get_gengrid_item_style_e(style);
	Elm_Gengrid_Item_Class *itc = _gic[style_e];
	if(itc == NULL) {
		itc = create_gengrid_item_class(style);
		if(itc != NULL) {
			_gic[style_e] = itc;
		}
	}
	return itc;
}

static Elm_Gengrid_Item_Class* create_gengrid_item_class(const char* style) {
	Elm_Gengrid_Item_Class *itc = elm_gengrid_item_class_new();
	itc->item_style = style;
	itc->func.text_get = uib_gengrid_label_get;
	itc->func.content_get = uib_gengrid_icon_get;
	itc->func.state_get = uib_gengrid_state_get;
	itc->func.del = uib_gengrid_del;

	return itc;
}

Elm_Object_Item* create_multibuttonentry_item(Evas_Object* multibuttonentry, const char* label, Evas_Smart_Cb func, void* data) {
	Elm_Object_Item* item = elm_multibuttonentry_item_append(multibuttonentry, label, func, data); 
	return item;
}

Elm_Object_Item* create_gengrid_item(Evas_Object* gengrid, const char* style, const char* label, const char* path, Evas_Smart_Cb func, void* data) {
	uib_gengrid_item* item = malloc(sizeof(uib_gengrid_item));
	memset(item, 0x0, sizeof(uib_gengrid_item));	
	item->label = strdup(label);
	item->icon_path = strdup(path);

	return elm_gengrid_item_append(gengrid, get_gengrid_item_class(style), item, func, data);
}
]]></xsl:text>
				<xsl:choose>
					<xsl:when test="$version='2.3' or $version='2.3.1'">
						<xsl:text><![CDATA[
static uib_gengrid_item_style_e get_gengrid_item_style_e(const char* style) {
	uib_gengrid_item_style_e item_style = UIB_GENGRID_ITEM_STYLE_UNKNOWN;

	if(!strcmp("default", style)){
		item_style = UIB_GENGRID_ITEM_STYLE_DEFAULT;
	}else if(!strcmp("album-preview", style)){
		item_style = UIB_GENGRID_ITEM_STYLE_ALBUM_PREVIEW;
	}else if(!strcmp("block", style)){
		item_style = UIB_GENGRID_ITEM_STYLE_BLOCK;
	}else if(!strcmp("group_index", style)){
		item_style = UIB_GENGRID_ITEM_STYLE_GROUP_INDEX;
	}else if(!strcmp("default_grid", style)){
		item_style = UIB_GENGRID_ITEM_STYLE_DEFAULT_GRID;
	}else if(!strcmp("default_gridtext2", style)){
		item_style = UIB_GENGRID_ITEM_STYLE_DEFAULT_GRIDTEXT2;
	}else if(!strcmp("default_gridtext", style)){
		item_style = UIB_GENGRID_ITEM_STYLE_DEFAULT_GRIDTEXT;
	}else if(!strcmp("default_style", style)){
		item_style = UIB_GENGRID_ITEM_STYLE_DEFAULT_STYLE;
	}else {
		item_style = UIB_GENGRID_ITEM_STYLE_DEFAULT;
	}

	return item_style;
}

static uib_genlist_item_style_e get_genlist_item_style_e(const char* style) {
	uib_genlist_item_style_e item_style = UIB_GENLIST_ITEM_STYLE_UNKNOWN;

	if(!strcmp("default", style)){
		item_style = UIB_GENLIST_ITEM_STYLE_DEFAULT;
	}else if(!strcmp("default_style", style)){
		item_style = UIB_GENLIST_ITEM_STYLE_DEFAULT_STYLE;
	}else if(!strcmp("double_label", style)){
		item_style = UIB_GENLIST_ITEM_STYLE_DOUBLE_LABEL;
	}else if(!strcmp("end_icon", style)){
		item_style = UIB_GENLIST_ITEM_STYLE_END_ICON;
	}else if(!strcmp("full", style)){
		item_style = UIB_GENLIST_ITEM_STYLE_FULL;
	}else if(!strcmp("group_index", style)){
		item_style = UIB_GENLIST_ITEM_STYLE_GROUPINDEX;
	}else if(!strcmp("one_icon", style)){
		item_style = UIB_GENLIST_ITEM_STYLE_ONE_ICON;
	}else if(!strcmp("message", style)){
		item_style = UIB_GENLIST_ITEM_STYLE_ONE_MESSAGE;
	}else {
		item_style = UIB_GENLIST_ITEM_STYLE_DEFAULT;
	}

	return item_style;
}

]]></xsl:text>
					</xsl:when>
					<xsl:when test="$version='2.4' or $version='3.0'">
						<xsl:text><![CDATA[
static uib_gengrid_item_style_e get_gengrid_item_style_e(const char* style) {
	uib_gengrid_item_style_e item_style = UIB_GENGRID_ITEM_STYLE_UNKNOWN;

	if(!strcmp("default", style)){
		item_style = UIB_GENGRID_ITEM_STYLE_DEFAULT;
	}else if(!strcmp("type1", style)){
		item_style = UIB_GENGRID_ITEM_STYLE_TYPE1;
	}else if(!strcmp("type2", style)){
		item_style = UIB_GENGRID_ITEM_STYLE_TYPE2;
	}else {
		item_style = UIB_GENGRID_ITEM_STYLE_DEFAULT;
	}

	return item_style;
}

static uib_genlist_item_style_e get_genlist_item_style_e(const char* style) {
	uib_genlist_item_style_e item_style = UIB_GENLIST_ITEM_STYLE_UNKNOWN;

	if(!strcmp("type1", style)){
		item_style = UIB_GENLIST_ITEM_STYLE_TYPE1;
	}else if(!strcmp("type2", style)){
		item_style = UIB_GENLIST_ITEM_STYLE_TYPE2;
	}else if(!strcmp("multiline", style)){
		item_style = UIB_GENLIST_ITEM_STYLE_MULTILINE;
	}else if(!strcmp("full", style)){
		item_style = UIB_GENLIST_ITEM_STYLE_FULL;
	}else if(!strcmp("group_index", style)){
		item_style = UIB_GENLIST_ITEM_STYLE_GROUPINDEX;
	}else if(!strcmp("group_index/expandable", style)){
		item_style = UIB_GENLIST_ITEM_STYLE_GROUPINDEX_EXPANDABLE;
	}else if(!strcmp("default", style)){
		item_style = UIB_GENLIST_ITEM_STYLE_DEFAULT;
	}else if(!strcmp("double_label", style)){
		item_style = UIB_GENLIST_ITEM_STYLE_DOUBLE_LABEL;
	}else if(!strcmp("one_icon", style)){
		item_style = UIB_GENLIST_ITEM_STYLE_ONE_ICON;
	}else if(!strcmp("end_icon", style)){
		item_style = UIB_GENLIST_ITEM_STYLE_END_ICON;
	}else{
		item_style = UIB_GENLIST_ITEM_STYLE_DEFAULT;
	}

	return item_style;
}
]]></xsl:text>
					</xsl:when>
					<xsl:otherwise>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$profile='wearable'">
				<xsl:text><![CDATA[
static uib_genlist_item_style_e get_genlist_item_style_e(const char* style) {
	uib_genlist_item_style_e item_style = UIB_GENLIST_ITEM_STYLE_UNKNOWN;

	if(!strcmp("default", style)){
		item_style = UIB_GENLIST_ITEM_STYLE_DEFAULT;;
	}else if(!strcmp("groupindex", style)){
		item_style = UIB_GENLIST_ITEM_STYLE_GROUPINDEX;
	}else if(!strcmp("1text", style)){
		item_style = UIB_GENLIST_ITEM_STYLE_1TEXT;
	}else if(!strcmp("1text.1icon", style)){
		item_style = UIB_GENLIST_ITEM_STYLE_1TEXT_1ICON;
	}else if(!strcmp("2text", style)){
		item_style = UIB_GENLIST_ITEM_STYLE_2TEXT;
	}else if(!strcmp("2text.1", style)){
		item_style = UIB_GENLIST_ITEM_STYLE_2TEXT_1;
	}else if(!strcmp("1text.1icon.divider", style)){
		item_style = UIB_GENLIST_ITEM_STYLE_1TEXT_1ICON_DIVIDER;
	}else if(!strcmp("1text.1icon.1", style)){
		item_style = UIB_GENLIST_ITEM_STYLE_1TEXT_1ICON_1;
	}else if(!strcmp("2text.1icon.1", style)){
		item_style = UIB_GENLIST_ITEM_STYLE_2TEXT_1ICON_1;
	}else if(!strcmp("multiline/1text", style)){
		item_style = UIB_GENLIST_ITEM_STYLE_NULTILINE_1TEXT;
	}else if(!strcmp("multiline/2text", style)){
		item_style = UIB_GENLIST_ITEM_STYLE_NULTILINE_2TEXT;
	}else{
		item_style = UIB_GENLIST_ITEM_STYLE_DEFAULT;
	}

	return item_style;
}
]]></xsl:text>
			</xsl:when>
			<xsl:when test="$profile='wearable-circle'">
				<xsl:text><![CDATA[
static uib_genlist_item_style_e get_genlist_item_style_e(const char* style) {
	uib_genlist_item_style_e item_style = UIB_GENLIST_ITEM_STYLE_UNKNOWN;

	if(!strcmp("default", style)){
		item_style = UIB_GENLIST_ITEM_STYLE_DEFAULT;
	}else if(!strcmp("title", style)){
		item_style = UIB_GENLIST_ITEM_STYLE_TITLE;
	}else if(!strcmp("groupindex", style)){
		item_style = UIB_GENLIST_ITEM_STYLE_GROUPINDEX;
	}else if(!strcmp("1text", style)){
		item_style = UIB_GENLIST_ITEM_STYLE_1TEXT;
	}else if(!strcmp("1text.1icon", style)){
		item_style = UIB_GENLIST_ITEM_STYLE_1TEXT_1ICON;
	}else if(!strcmp("2text", style)){
		item_style = UIB_GENLIST_ITEM_STYLE_2TEXT;
	}else if(!strcmp("1text.1icon.divider", style)){
		item_style = UIB_GENLIST_ITEM_STYLE_1TEXT_1ICON_DIVIDER;
	}else if(!strcmp("1text.1icon.1", style)){
		item_style = UIB_GENLIST_ITEM_STYLE_1TEXT_1ICON_1;
	}else if(!strcmp("2text.1icon.1", style)){
		item_style = UIB_GENLIST_ITEM_STYLE_2TEXT_1ICON_1;
	}else if(!strcmp("editfield", style)){
		item_style = UIB_GENLIST_ITEM_STYLE_EDITFIELD;
	}else{
		item_style = UIB_GENLIST_ITEM_STYLE_DEFAULT;
	}

	return item_style;
}
]]></xsl:text>
			</xsl:when>
			<xsl:otherwise />
		</xsl:choose>
		<!-- END : OUTPUT -->
	</xsl:template>
</xsl:stylesheet>
