/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.efluibuilder.codegenerator;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.tizen.common.util.Assert;
import org.tizen.efluibuilder.codegenerator.CodeGenerator;
import org.tizen.efluibuilder.codegenerator.CodeGeneratorException;
import org.tizen.efluibuilder.codegenerator.CodeGeneratorPolicy;
import org.tizen.efluibuilder.codegenerator.ICodeGenerator;

public final class CodeGeneratorImpl
implements ICodeGenerator {
    private IProject project = null;

    public CodeGeneratorImpl(IProject iProject) {
        this.project = iProject;
    }

    private IProject getProject() {
        return this.project;
    }

    @Override
    public void generate() throws CodeGeneratorException {
        CodeGenerator codeGenerator = new CodeGenerator(this.getProject());
        codeGenerator.generate();
    }

    @Override
    public void addView(String string) throws CodeGeneratorException {
        IFile iFile;
        NullProgressMonitor nullProgressMonitor = new NullProgressMonitor();
        IFolder iFolder = CodeGeneratorPolicy.getEventHandlerFolder(this.getProject());
        if (!iFolder.exists()) {
            try {
                iFolder.create(false, true, (IProgressMonitor)new NullProgressMonitor());
                iFolder.refreshLocal(0, (IProgressMonitor)nullProgressMonitor);
            }
            catch (CoreException coreException) {
                throw new CodeGeneratorException(coreException.getMessage());
            }
        }
        if ((iFile = CodeGeneratorPolicy.getEventHandlerFile(this.getProject(), string)).exists()) {
            return;
        }
        CodeGenerator codeGenerator = new CodeGenerator(this.getProject());
        String string2 = codeGenerator.getProfile();
        Assert.notNull((Object)string2);
        String string3 = string2.equals("wearable-circle") ? "/*******************************************************************************\n* This file was generated by UI Builder.\n* User should hand edit this file.\n********************************************************************************/\n\n#include \"app_main.h\"\n#include \"uib_views.h\"\n#include \"uib_views_inc.h\"\n\ntypedef struct _uib_%id%_control_context {\n /* add your variables here */\n\n} uib_%id%_control_context;\n\n" : "/*******************************************************************************\n* This file was generated by UI Builder.\n* User should hand edit this file.\n********************************************************************************/\n\n#include \"app_main.h\"\n#include \"view_data.h\"\n#include \"uib_app_manager.h\"\n#include \"uib_views.h\"\n#include \"uib_views_inc.h\"\n\ntypedef struct _uib_%id%_control_context {\n\t/* add your variables here */\n\n} uib_%id%_control_context;\n\n";
        string3 = string3.replace("%id%", string);
        try {
            iFile.create((InputStream)new ByteArrayInputStream(string3.getBytes()), true, (IProgressMonitor)nullProgressMonitor);
        }
        catch (CoreException coreException) {
            throw new CodeGeneratorException(coreException.getMessage());
        }
    }

    @Override
    public void removeView(String string) throws CodeGeneratorException {
        IFile iFile = CodeGeneratorPolicy.getEventHandlerFile(this.getProject(), string);
        if (!iFile.exists()) {
            return;
        }
        try {
            iFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {
            throw new CodeGeneratorException(coreException.getMessage());
        }
    }

    @Override
    public void clean() throws CodeGeneratorException {
        CodeGenerator codeGenerator = new CodeGenerator(this.getProject());
        try {
            codeGenerator.clean();
        }
        catch (IOException iOException) {
            throw new CodeGeneratorException(iOException.getMessage());
        }
        catch (CoreException coreException) {
            throw new CodeGeneratorException(coreException.getMessage());
        }
    }
}

