/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.efluibuilder.project.core;

import java.util.Arrays;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.process.ProcessArgument;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.core.templateengine.process.ProcessRunner;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.tizen.efluibuilder.project.core.Messages;
import org.tizen.efluibuilder.project.core.NUIBNature;
import org.tizen.efluibuilder.utility.IDEUtil;

public final class AddNatureProcess
extends ProcessRunner {
    private static final String FILE_LAYOUT_META = "layout/layout.xml";

    public void process(TemplateCore templateCore, ProcessArgument[] processArgumentArray, String string, IProgressMonitor iProgressMonitor) {
        String string2 = processArgumentArray[0].getSimpleValue();
        IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(string2);
        try {
            this.addNature(iProject, iProgressMonitor);
            this.open(iProject);
        }
        catch (ProcessFailureException processFailureException) {
            processFailureException.printStackTrace();
            final String string3 = processFailureException.getMessage();
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.MESSAGE_DIALOG_TITLE, (String)string3);
                }
            });
        }
    }

    private void addNature(IProject iProject, IProgressMonitor iProgressMonitor) throws ProcessFailureException {
        String[] stringArray;
        String[] stringArray2;
        IProjectDescription iProjectDescription = null;
        try {
            iProjectDescription = iProject.getDescription();
        }
        catch (CoreException coreException) {
            throw new ProcessFailureException(coreException.getMessage());
        }
        String[] stringArray3 = stringArray2 = iProjectDescription.getNatureIds();
        int n = stringArray2.length;
        int n2 = 0;
        while (n2 < n) {
            stringArray = stringArray3[n2];
            if (stringArray.equals(NUIBNature.getId())) {
                return;
            }
            ++n2;
        }
        stringArray = Arrays.copyOf(stringArray2, stringArray2.length + 1);
        stringArray[stringArray2.length] = NUIBNature.getId();
        iProjectDescription.setNatureIds(stringArray);
        try {
            iProject.setDescription(iProjectDescription, iProgressMonitor);
        }
        catch (CoreException coreException) {
            throw new ProcessFailureException(coreException.getMessage());
        }
    }

    private void open(IProject iProject) throws ProcessFailureException {
        IFile iFile = iProject.getFile(FILE_LAYOUT_META);
        if (!iFile.exists()) {
            throw new ProcessFailureException(Messages.MESSAGE_DIALOG_LAYOUT_FILE_NOT_FOUND);
        }
        IDEUtil.open((IFile)iFile);
    }
}

