/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.efluibuilder.internal.connector;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.commands.common.EventManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.Assert;
import org.tizen.efluibuilder.internal.connector.ConnectorEvent;
import org.tizen.efluibuilder.internal.connector.IConnector;
import org.tizen.efluibuilder.internal.connector.IConnectorListener;
import org.tizen.efluibuilder.internal.connector.IMessage;
import org.tizen.efluibuilder.internal.connector.IService;
import org.tizen.efluibuilder.internal.connector.MessageReader;
import org.tizen.efluibuilder.internal.connector.MessageWriter;
import org.tizen.efluibuilder.internal.renderer.util.DebugUtil;

public final class Connector
extends EventManager
implements IConnector {
    private static Logger logger = LoggerFactory.getLogger(Connector.class);
    private static final int TIME_OUT = 1000;
    private String id = null;
    private Socket socket = null;
    private MessageReader reader = null;
    private MessageWriter writer = null;
    private Thread receiver = null;
    private Thread worker = null;
    private List<IMessage> messages = Collections.synchronizedList(new LinkedList());

    void setId(String string) {
        this.id = string;
    }

    String getId() {
        return this.id;
    }

    Connector(IService iService) throws IOException {
        this.create(iService);
    }

    private void create(IService iService) throws IOException {
        String string = iService.getIp();
        int n = iService.getPort();
        this.socket = new Socket(Proxy.NO_PROXY);
        try {
            this.socket.connect(new InetSocketAddress(string, n), 1000);
            this.socket.setKeepAlive(true);
            this.socket.setSoLinger(true, 0);
        }
        catch (IOException iOException) {
            logger.error(iOException.getMessage());
            logger.error(String.format("IP : %s | Port : %d", string, n));
            throw iOException;
        }
        try {
            InputStream inputStream = this.socket.getInputStream();
            OutputStream outputStream = this.socket.getOutputStream();
            this.reader = new MessageReader(inputStream);
            this.writer = new MessageWriter(outputStream);
        }
        catch (IOException iOException) {
            logger.error(iOException.getMessage());
            throw iOException;
        }
        this.receiver = new Receiver();
        this.receiver.setName(String.valueOf(iService.getId()) + " Receiver");
        this.receiver.start();
        this.worker = new Worker();
        this.worker.setName(String.valueOf(iService.getId()) + " Worker");
        this.worker.start();
    }

    void destroy() {
        try {
            if (this.socket != null && !this.socket.isInputShutdown()) {
                this.socket.shutdownInput();
            }
            if (this.socket != null && !this.socket.isOutputShutdown()) {
                this.socket.shutdownOutput();
            }
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException iOException) {
            logger.error(iOException.getMessage());
        }
        this.socket = null;
    }

    @Override
    public void send(IMessage iMessage) {
        if (!this.isConnected()) {
            logger.error("Renderer connection not found");
        } else {
            try {
                this.writer.write(iMessage);
            }
            catch (IOException iOException) {
                logger.error(iOException.getMessage());
            }
        }
    }

    @Override
    public void addConnectorListener(IConnectorListener iConnectorListener) {
        this.addListenerObject(iConnectorListener);
    }

    @Override
    public void removeConnectorListener(IConnectorListener iConnectorListener) {
        this.removeListenerObject(iConnectorListener);
    }

    public boolean isConnected() {
        if (this.socket == null) {
            return false;
        }
        return this.socket.isConnected();
    }

    private void fireEvent(ConnectorEvent connectorEvent) {
        Object[] objectArray;
        if (connectorEvent == null) {
            throw new NullPointerException("Cannot send a null event to listeners.");
        }
        if (!this.isListenerAttached()) {
            return;
        }
        Object[] objectArray2 = objectArray = this.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray2[n2];
            ((IConnectorListener)object).receiveEvent(connectorEvent);
            ++n2;
        }
    }

    private void receive() {
        IMessage iMessage = null;
        try {
            iMessage = this.reader.read();
            Assert.notNull((Object)iMessage);
        }
        catch (IOException iOException) {
            DebugUtil.debug(logger, this.getClass().getName(), iOException);
            this.destroy();
            return;
        }
        if (this.messages.isEmpty()) {
            this.messages.add(iMessage);
            return;
        }
        if (iMessage.getType() != 11) {
            this.messages.add(iMessage);
            return;
        }
        int n = this.find(iMessage);
        if (n == -1) {
            this.messages.add(iMessage);
            return;
        }
        this.messages.set(n, iMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int find(IMessage iMessage) {
        int n = -1;
        List<IMessage> list = this.messages;
        synchronized (list) {
            int n2 = 0;
            while (n2 < this.messages.size()) {
                IMessage iMessage2 = this.messages.get(n2);
                if (iMessage.getId() == iMessage2.getId() && iMessage2.getType() == 11) {
                    n = n2;
                    break;
                }
                ++n2;
            }
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    private void work() {
        if (!this.messages.isEmpty()) ** GOTO lbl16
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException var1_1) {
            Connector.logger.error(var1_1.getMessage());
        }
        return;
lbl-1000:
        // 1 sources

        {
            var1_2 = this.messages.get(0);
            this.messages.remove(0);
            var2_3 = new ConnectorEvent();
            var2_3.setMessage(var1_2);
            var2_3.setId(var1_2.getId());
            var2_3.setType(var1_2.getType());
            this.fireEvent(var2_3);
lbl16:
            // 2 sources

            ** while (!this.messages.isEmpty())
        }
lbl17:
        // 1 sources

    }

    private final class Receiver
    extends Thread {
        private Receiver() {
        }

        @Override
        public void run() {
            while (Connector.this.isConnected()) {
                Connector.this.receive();
            }
        }
    }

    private final class Worker
    extends Thread {
        private Worker() {
        }

        @Override
        public void run() {
            while (Connector.this.isConnected()) {
                Connector.this.work();
            }
        }
    }
}

