/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.efluibuilder.converter;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.TizenProjectDescription;
import org.tizen.common.util.ProjectUtil;
import org.tizen.efluibuilder.converter.IProjectConverter;
import org.tizen.efluibuilder.converter.ProjectConverterException;
import org.tizen.efluibuilder.converter.table.LayoutConverterTable;
import org.tizen.efluibuilder.core.configuration.device.Device;
import org.tizen.efluibuilder.core.configuration.device.DeviceManager;
import org.tizen.efluibuilder.core.configurator.Configurator;
import org.tizen.efluibuilder.model.app.loader.PropertiesLoader;
import org.tizen.efluibuilder.model.app.loader.jaxb.Properties;
import org.tizen.efluibuilder.model.app.loader.jaxb.ViewModel;
import org.tizen.efluibuilder.utility.PlatformUtil;
import org.tizen.efluibuilder.utility.ResourceUtil;
import org.tizen.efluibuilder.utility.XMLUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class ProjectConverter
implements IProjectConverter {
    private static Logger logger = LoggerFactory.getLogger(ProjectConverter.class);
    private static final String APP_MAIN_H_PATH = "inc/app_main.h";
    private static final String APP_MAIN_C_PATH = "src/app_main.c";
    private static final String BAK_APP_MAIN_H_FILE = "app_main.h.bak";
    private static final String BAK_APP_MAIN_C_FILE = "app_main.c.bak";
    private static final String RES_APP_MAIN_H_PATH = "res/convert/default/app_main.h";
    private static final String RES_APP_MAIN_C_PATH = "res/convert/default/app_main.c";
    private IProject project = null;
    private List<ViewModel> viewModelList = new ArrayList<ViewModel>();

    public ProjectConverter(IProject iProject) {
        this.project = iProject;
    }

    private IProject getProject() {
        return this.project;
    }

    @Override
    public void convert() throws ProjectConverterException {
        logger.debug("1. Verify Preconditions");
        IFile iFile = this.getProject().getFile("layout/layout.tuml");
        if (!iFile.exists()) {
            throw new ProjectConverterException("layout.tuml file is not exist");
        }
        IFile iFile2 = this.getProject().getFile("app.xml");
        if (!iFile2.exists()) {
            throw new ProjectConverterException("app.xml file is not exist");
        }
        IFile iFile3 = this.getProject().getFile("layout/layout.xml");
        if (iFile3.exists()) {
            throw new ProjectConverterException("layout.xml file is already exist");
        }
        IFile iFile4 = this.getProject().getFile(".uproject");
        if (iFile4.exists()) {
            throw new ProjectConverterException(".uproject file is already exist");
        }
        try {
            try {
                logger.debug("2. Load app.xml");
                File file = iFile2.getLocation().toFile();
                Document document = XMLUtil.load((File)file);
                String string = XMLUtil.getValue((Document)document, (String)"/tizenFile/tizenProject/startup/@viewId");
                String string2 = XMLUtil.getValue((Document)document, (String)"/tizenFile/tizenProject/device/@name");
                String string3 = "square";
                if (string2.contains("CIRCLE")) {
                    string3 = "circle";
                }
                logger.debug("3. Delete app.xml");
                iFile2.delete(true, (IProgressMonitor)new NullProgressMonitor());
                logger.debug("4. Save .uproject");
                Properties properties = new Properties();
                properties.setShape(string3);
                logger.debug("5. Load and Convert layout.tuml");
                Document document2 = this.convert(iFile);
                properties.setViews(this.viewModelList);
                PropertiesLoader propertiesLoader = new PropertiesLoader();
                propertiesLoader.data = properties;
                propertiesLoader.save(iFile4);
                String string4 = iFile3.getLocation().toString();
                String string5 = string4.replace(".tuml", ".xml");
                logger.debug("6. Add common configuration for mscreen ");
                Node node = XMLUtil.getNode((Document)document2, (String)"document/mscreen/configuration[1]/@device");
                node.setNodeValue(this.getDeviceName(string3));
                logger.debug("7. Add startup info to new document ");
                Node node2 = XMLUtil.getNode((Document)document2, (String)"document/views/@startup");
                node2.setNodeValue(string);
                logger.debug("8. Save layout.xml");
                XMLUtil.save((Document)document2, (File)new File(string5));
                logger.debug("9. Move layout.tuml to .layout.tuml");
                iFile.move((IPath)new Path(".layout.tuml"), true, true, null);
                logger.debug("10. Backup");
                this.convertAppMainFiles();
            }
            catch (XPathExpressionException xPathExpressionException) {
                throw new ProjectConverterException("Project convert failed : " + xPathExpressionException.getMessage());
            }
            catch (IOException iOException) {
                throw new ProjectConverterException("Project convert failed : " + iOException.getMessage());
            }
            catch (TransformerException transformerException) {
                throw new ProjectConverterException("Project convert failed : " + transformerException.getMessage());
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new ProjectConverterException("Project convert failed : " + parserConfigurationException.getMessage());
            }
            catch (SAXException sAXException) {
                throw new ProjectConverterException("Project convert failed : " + sAXException.getMessage());
            }
            catch (CoreException coreException) {
                throw new ProjectConverterException("Project convert failed : " + coreException.getMessage());
            }
            catch (JAXBException jAXBException) {
                throw new ProjectConverterException("Project convert failed : " + jAXBException.getMessage());
            }
        }
        finally {
            try {
                iFile4.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                iFile3.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception exception) {
                throw new ProjectConverterException("Project convert failed : " + exception.getMessage());
            }
        }
    }

    private String getDeviceName(String string) {
        Object object;
        String string2 = null;
        TizenProjectDescription tizenProjectDescription = ProjectUtil.getTizenProjectDescription((IProject)this.project);
        if (string.equals("square")) {
            string2 = tizenProjectDescription.getPlatformName();
        } else if (string.equals("circle")) {
            object = "wearable-circle";
            string2 = ((String)object).concat("-").concat(tizenProjectDescription.getVersion());
        }
        object = Configurator.getConfigurator();
        DeviceManager deviceManager = object.getDeviceManager(string2);
        Collection collection = deviceManager.getDevices();
        Iterator iterator = collection.iterator();
        Device device = (Device)iterator.next();
        return device.getName();
    }

    private void convertAppMainFiles() throws MalformedURLException, IOException, CoreException {
        IFile iFile;
        String string;
        IFile iFile2 = this.getProject().getFile("inc/app_main.h.bak");
        IFile iFile3 = this.getProject().getFile("src/app_main.c.bak");
        if (iFile2.exists() && iFile3.exists()) {
            return;
        }
        IFile iFile4 = this.getProject().getFile(APP_MAIN_H_PATH);
        IFile iFile5 = this.getProject().getFile(APP_MAIN_C_PATH);
        String string2 = iFile4.getLocation().toOSString();
        String string3 = iFile5.getLocation().toOSString();
        if (!iFile2.exists() && iFile4.exists()) {
            iFile4.move((IPath)new Path(BAK_APP_MAIN_H_FILE), true, true, null);
            iFile4.refreshLocal(1, null);
            string = ResourceUtil.getURI((String)"org.tizen.efluibuilder.converter", (String)RES_APP_MAIN_H_PATH).getPath();
            string = PlatformUtil.getCorrectedOSFullPath((String)string);
            Files.copy(Paths.get(string, new String[0]), Paths.get(string2, new String[0]), new CopyOption[0]);
            iFile = this.getProject().getFile(APP_MAIN_H_PATH);
            iFile.refreshLocal(1, null);
        }
        if (!iFile3.exists() && iFile5.exists()) {
            iFile5.move((IPath)new Path(BAK_APP_MAIN_C_FILE), true, true, null);
            iFile5.refreshLocal(1, null);
            string = ResourceUtil.getURI((String)"org.tizen.efluibuilder.converter", (String)RES_APP_MAIN_C_PATH).getPath();
            string = PlatformUtil.getCorrectedOSFullPath((String)string);
            Files.copy(Paths.get(string, new String[0]), Paths.get(string3, new String[0]), new CopyOption[0]);
            iFile = this.getProject().getFile(APP_MAIN_C_PATH);
            iFile.refreshLocal(1, null);
        }
    }

    private Document convert(IFile iFile) throws XPathExpressionException, MalformedURLException, ParserConfigurationException, SAXException, IOException {
        String string = iFile.getLocation().toString();
        File file = new File(string);
        Document document = XMLUtil.clean((Document)XMLUtil.load((File)file));
        Element element = document.getDocumentElement();
        Element element2 = document.createElement("document");
        Element element3 = document.createElement("mscreen");
        Element element4 = document.createElement("configuration");
        element4.setAttribute("id", "config1");
        element4.setAttribute("device", "");
        element4.setAttribute("name", "common");
        element4.setAttribute("orientation", "portrait");
        element4.setAttribute("type", "common");
        element3.appendChild(element4);
        element2.appendChild(element3);
        Element element5 = document.createElement("views");
        element5.setAttribute("startup", "");
        element2.appendChild(element5);
        NodeList nodeList = document.getElementsByTagName("tizen.doc");
        if (nodeList == null) {
            return null;
        }
        Node node = nodeList.item(0);
        Element element6 = (Element)node;
        if (element6 == null) {
            return null;
        }
        ArrayList<Node> arrayList = new ArrayList<Node>();
        NodeList nodeList2 = element6.getChildNodes();
        int n = 0;
        while (n < nodeList2.getLength()) {
            Node node2 = nodeList2.item(n);
            if (node2 instanceof Element) {
                Element element7 = (Element)node2;
                Attr attr = element7.getAttributeNode("id");
                String string2 = null;
                if (attr != null) {
                    string2 = attr.getValue();
                    this.addToViewModelList(element7, string2);
                }
                ProjectConverter.convertBody(document, element6, (Element)node2, string2);
                arrayList.add(node2);
            }
            ++n;
        }
        n = 0;
        while (n < arrayList.size()) {
            element5.appendChild((Node)arrayList.get(n));
            ++n;
        }
        document.replaceChild(element2, element);
        return document;
    }

    private void addToViewModelList(Element element, String string) {
        ViewModel viewModel = new ViewModel();
        viewModel.setId(string);
        Attr attr = element.getAttributeNode("location-x");
        if (attr != null) {
            viewModel.setLocationX(Integer.parseInt(attr.getValue()));
        }
        if ((attr = element.getAttributeNode("location-y")) != null) {
            viewModel.setLocationY(Integer.parseInt(attr.getValue()));
        }
        this.viewModelList.add(viewModel);
    }

    private static void convertBody(Document document, Element element, Element element2, String string) {
        Node node;
        String string2 = element2.getNodeName();
        if (LayoutConverterTable.isRemovedElement(string2)) {
            element.removeChild(element2);
            return;
        }
        if (string2.equals("event")) {
            ProjectConverter.convertEvent(element2, string);
        } else {
            string2 = LayoutConverterTable.convertElement(string2);
            document.renameNode(element2, null, string2);
        }
        NamedNodeMap namedNodeMap = element2.getAttributes();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < namedNodeMap.getLength()) {
            Attr attr = (Attr)namedNodeMap.item(n);
            arrayList.add(attr.getName());
            ++n;
        }
        for (String string3 : arrayList) {
            node = element2.getAttributeNode(string3);
            if (node.getValue().isEmpty()) {
                element2.removeAttributeNode((Attr)node);
                continue;
            }
            if (LayoutConverterTable.isRemovedAttribute(element.getNodeName(), string2, node.getName())) {
                element2.removeAttributeNode((Attr)node);
                continue;
            }
            String string4 = LayoutConverterTable.convertAttribute(element.getNodeName(), string2, node.getName());
            String string5 = LayoutConverterTable.convertValue(element.getNodeName(), string2, string4, node.getValue());
            element2.removeAttributeNode((Attr)node);
            element2.setAttribute(string4, string5);
        }
        NodeList nodeList = element2.getChildNodes();
        int n2 = 0;
        while (n2 < nodeList.getLength()) {
            node = nodeList.item(n2);
            if (node instanceof Element) {
                ProjectConverter.convertBody(document, element2, (Element)node, string);
            }
            ++n2;
        }
    }

    private static void convertEvent(Element element, String string) {
        NamedNodeMap namedNodeMap = element.getAttributes();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < namedNodeMap.getLength()) {
            Attr attr = (Attr)namedNodeMap.item(n);
            arrayList.add(attr.getName());
            ++n;
        }
        for (String string2 : arrayList) {
            String string3;
            Attr attr = element.getAttributeNode(string2);
            String string4 = attr.getName();
            if (string4.startsWith("on")) {
                string3 = attr.getValue();
                element.setAttribute("signal", ProjectConverter.convertEventSignal(string4.replace("on", "")));
                element.setAttribute("function_name", String.valueOf(string) + "_" + string3);
                element.removeAttributeNode(attr);
                continue;
            }
            if (!string4.equals("connection_wrapper")) continue;
            string3 = attr.getValue();
            string3 = string3.replace("connection_", "connection_" + string + "_");
            attr.setValue(string3);
        }
    }

    private static String convertEventSignal(String string) {
        if (string == null) {
            return null;
        }
        if (!string.contains("_")) {
            return string;
        }
        String[] stringArray = string.split("_");
        String string2 = "";
        int n = 0;
        while (n < stringArray.length) {
            string2 = String.valueOf(string2) + stringArray[n];
            if (n != stringArray.length - 1) {
                string2 = String.valueOf(string2) + ",";
            }
            ++n;
        }
        return string2;
    }
}

