/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.efluibuilder.core.configurator;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.tizen.efluibuilder.core.configuration.device.DeviceManager;
import org.tizen.efluibuilder.core.configurator.ConfiguratorException;
import org.tizen.efluibuilder.core.configurator.IConfigurator;
import org.tizen.efluibuilder.model.descriptors.DescriptorManager;
import org.tizen.efluibuilder.utility.ResourceUtil;
import org.xml.sax.SAXException;

public final class Configurator
implements IConfigurator {
    private static IConfigurator configurator = null;
    private Map<String, Object> configurations = new HashMap<String, Object>();
    private Map<String, String> descriptorMap = new HashMap<String, String>();
    private Map<String, String> deviceMap = new HashMap<String, String>();
    private Map<String, String> schemaMap = new HashMap<String, String>();

    public static synchronized IConfigurator getConfigurator() {
        if (configurator == null) {
            configurator = new Configurator();
        }
        return configurator;
    }

    private Configurator() {
        this.create();
    }

    private void create() {
        this.initDescriptorMap();
        this.initDeviceMap();
        this.initSchemaMap();
        this.initConfigurations();
    }

    private void initDescriptorMap() {
        this.descriptorMap.put("mobile-2.3", "mobile-2.3_descriptor");
        this.descriptorMap.put("mobile-2.3.1", "mobile-2.3_descriptor");
        this.descriptorMap.put("wearable-2.3.1", "wearable-2.3.1_descriptor");
        this.descriptorMap.put("wearable-circle-2.3.1", "wearable-circle-2.3.1_descriptor");
        this.descriptorMap.put("wearable-circle-2.3.2", "wearable-circle-2.3.1_descriptor");
        this.descriptorMap.put("mobile-2.4", "mobile-2.4_descriptor");
        this.descriptorMap.put("mobile-3.0", "mobile-2.4_descriptor");
        this.descriptorMap.put("wearable-circle-3.0", "wearable-circle-2.3.1_descriptor");
        this.descriptorMap.put("tv-3.0", "tv-3.0_descriptor");
    }

    private void initDeviceMap() {
        this.deviceMap.put("mobile-2.3", "mobile-2.3_device");
        this.deviceMap.put("mobile-2.3.1", "mobile-2.3_device");
        this.deviceMap.put("wearable-2.3.1", "wearable-2.3.1_device");
        this.deviceMap.put("wearable-circle-2.3.1", "wearable-circle-2.3.1_device");
        this.deviceMap.put("wearable-circle-2.3.2", "wearable-circle-2.3.1_device");
        this.deviceMap.put("mobile-2.4", "mobile-2.3_device");
        this.deviceMap.put("mobile-3.0", "mobile-2.3_device");
        this.deviceMap.put("wearable-circle-3.0", "wearable-circle-2.3.1_device");
        this.deviceMap.put("tv-3.0", "tv-3.0_device");
    }

    private void initSchemaMap() {
        this.schemaMap.put("mobile-2.3", "res/xsd/mobile_2.3");
        this.schemaMap.put("mobile-2.3.1", "res/xsd/mobile_2.3");
        this.schemaMap.put("wearable-2.3.1", "res/xsd/wearable_2.3.1");
        this.schemaMap.put("wearable-circle-2.3.1", "res/xsd/wearable_circle_2.3.1");
        this.schemaMap.put("wearable-circle-2.3.2", "res/xsd/wearable_circle_2.3.1");
        this.schemaMap.put("mobile-2.4", "res/xsd/mobile_2.4");
        this.schemaMap.put("mobile-3.0", "res/xsd/mobile_2.4");
        this.schemaMap.put("wearable-circle-3.0", "res/xsd/wearable_circle_2.3.1");
        this.schemaMap.put("tv-3.0", "res/xsd/tv_3.0");
    }

    private void createDescriptorManager(String string, String string2) {
        try {
            DescriptorManager descriptorManager = new DescriptorManager();
            descriptorManager.load(string2);
            this.configurations.put(string, descriptorManager);
        }
        catch (IOException iOException) {
            throw new ConfiguratorException(iOException.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new ConfiguratorException(parserConfigurationException.getMessage());
        }
        catch (SAXException sAXException) {
            throw new ConfiguratorException(sAXException.getMessage());
        }
    }

    private void createDeviceManager(String string, String string2) {
        try {
            DeviceManager deviceManager = new DeviceManager();
            URI uRI = ResourceUtil.getURI((String)"org.tizen.efluibuilder.configurator", (String)string2);
            deviceManager.load(uRI);
            this.configurations.put(string, deviceManager);
        }
        catch (IOException iOException) {
            throw new ConfiguratorException(iOException.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new ConfiguratorException(parserConfigurationException.getMessage());
        }
        catch (SAXException sAXException) {
            throw new ConfiguratorException(sAXException.getMessage());
        }
    }

    private void initConfigurations() {
        this.createDescriptorManager("mobile-2.3_descriptor", "res/mobile-2.3");
        this.createDescriptorManager("mobile-2.4_descriptor", "res/mobile-2.4");
        this.createDescriptorManager("wearable-2.3.1_descriptor", "res/wearable-2.3.1");
        this.createDescriptorManager("wearable-circle-2.3.1_descriptor", "res/wearable-circle-2.3.1");
        this.createDescriptorManager("tv-3.0_descriptor", "res/tv-3.0");
        this.createDeviceManager("mobile-2.3_device", "res/devices/mobile-2.3");
        this.createDeviceManager("wearable-2.3.1_device", "res/devices/wearable-2.3.1");
        this.createDeviceManager("wearable-circle-2.3.1_device", "res/devices/wearable-circle-2.3.1");
        this.createDeviceManager("mobile-3.0_device", "res/devices/mobile-3.0");
        this.createDeviceManager("wearable-circle-3.0_device", "res/devices/wearable-circle-3.0");
        this.createDeviceManager("tv-3.0_device", "res/devices/tv-3.0");
    }

    private Object getConfiguration(String string) {
        Object object = this.configurations.get(string);
        if (object == null) {
            throw new ConfiguratorException("configuration not found : " + string);
        }
        return object;
    }

    @Override
    public DescriptorManager getDescriptorManager(String string) {
        Object object = this.getConfiguration(this.descriptorMap.get(string));
        if (object instanceof DescriptorManager) {
            return (DescriptorManager)object;
        }
        throw new ConfiguratorException();
    }

    @Override
    public DeviceManager getDeviceManager(String string) {
        Object object = this.getConfiguration(this.deviceMap.get(string));
        if (object instanceof DeviceManager) {
            return (DeviceManager)object;
        }
        throw new ConfiguratorException();
    }

    @Override
    public String getLayoutSchemaLocation(String string) {
        return this.schemaMap.get(string);
    }
}

