<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:variable name="newline">
		<xsl:text>
</xsl:text>
	</xsl:variable>
	<xsl:variable name="tab">
		<xsl:text disable-output-escaping="yes">	</xsl:text>
	</xsl:variable>
	
	<xsl:param name="is_widget_project" />

	<xsl:template match="/">
		<xsl:apply-templates select="//views">
		</xsl:apply-templates>
	</xsl:template>

	<xsl:template match="views">

		<xsl:text disable-output-escaping="yes">
<![CDATA[/*******************************************************************************
* This file was generated by UI Builder.
* This file will be auto-generated each and everytime you save your project.
* Do not hand edit this file.
********************************************************************************/
#include "uib_app_manager.h"
#include "uib_view_manager.h"


static uib_app_manager_st g_uib_app_manager;
uib_device_info_st g_uib_device_info;

]]></xsl:text>
		<xsl:choose>
			<xsl:when test="$is_widget_project='true'">
				<xsl:text><![CDATA[
uib_view_context* initialize(widget_context_h context, int w, int h) {
	memset(&g_uib_device_info, 0x00, sizeof(uib_device_info_st));
	uib_util_get_device_info(&g_uib_device_info);
	window_obj* win_obj = uib_views_get_instance()->create_window_obj(context, w, h);]]></xsl:text>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text><![CDATA[
uib_view_context* initialize() {
	memset(&g_uib_device_info, 0x00, sizeof(uib_device_info_st));
	uib_util_get_device_info(&g_uib_device_info);
	window_obj* win_obj = uib_views_get_instance()->create_window_obj();]]></xsl:text>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:text><![CDATA[
    uib_util_rotation_set(win_obj->win, e_rotation_fullSensor);
	uib_view_context* vc = uib_views_get_instance()->startup_view_create(win_obj);
	Evas_Object* nf = win_obj->app_naviframe;
	Elm_Object_Item* nf_it = elm_naviframe_bottom_item_get(nf);

	eext_object_event_callback_add(nf, EEXT_CALLBACK_BACK, nf_hw_back_cb, vc);
	evas_object_show(nf);
	elm_naviframe_item_pop_cb_set(nf_it, nf_root_it_pop_cb, win_obj->win);

	elm_app_base_scale_set(g_uib_device_info.base_scale);
	evas_object_smart_callback_add(win_obj->win, "delete,request", win_del_request_cb, NULL);
	return vc;
}

const uib_device_info_st* get_uib_device_info() {
	return &g_uib_device_info;
}

uib_app_manager_st* uib_app_manager_get_instance() {
	if(!g_uib_app_manager._is_init) {
		g_uib_app_manager._is_init = true;
		g_uib_app_manager.add_view_context = uib_view_manager_get_instance()->add_view_context;
		g_uib_app_manager.find_view_context = uib_view_manager_get_instance()->find_view_context;
		g_uib_app_manager.free_all_view_context = uib_view_manager_get_instance()->free_all_view_context;
		g_uib_app_manager.initialize = &initialize;
		g_uib_app_manager.get_uib_device_info = &get_uib_device_info;
	}
	return &g_uib_app_manager;
}
]]>
</xsl:text>

	</xsl:template>
</xsl:stylesheet>
